/* ispyTables.h was originally generated by the autoSql program, which also 
 * generated ispyTables.c and ispyTables.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef ISPYTABLES_H
#define ISPYTABLES_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define PATIENT_NUM_COLS 3

struct patient
/* Table patient */
    {
    struct patient *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *DataExtractDt;	/* Date data was downloaded from the CALGB database */
    char *Inst_ID;	/* Registering Institution */
    };

void patientStaticLoadWithNull(char **row, struct patient *ret);
/* Load a row from patient table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct patient *patientLoadWithNull(char **row);
/* Load a patient from row fetched with select * from patient
 * from database.  Dispose of this with patientFree(). */

struct patient *patientLoadAll(char *fileName);
/* Load all patient from whitespace-separated file.
 * Dispose of this with patientFreeList(). */

struct patient *patientLoadAllByChar(char *fileName, char chopper);
/* Load all patient from chopper separated file.
 * Dispose of this with patientFreeList(). */

#define patientLoadAllByTab(a) patientLoadAllByChar(a, '\t');
/* Load all patient from tab separated file.
 * Dispose of this with patientFreeList(). */

struct patient *patientLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all patient from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with patientFreeList(). */

void patientSaveToDb(struct sqlConnection *conn, struct patient *el, char *tableName, int updateSize);
/* Save patient as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use patientSaveToDbEscaped() */

void patientSaveToDbEscaped(struct sqlConnection *conn, struct patient *el, char *tableName, int updateSize);
/* Save patient as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than patientSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct patient *patientCommaIn(char **pS, struct patient *ret);
/* Create a patient out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new patient */

void patientFree(struct patient **pEl);
/* Free a single dynamically allocated patient such as created
 * with patientLoad(). */

void patientFreeList(struct patient **pList);
/* Free a list of dynamically allocated patient's */

void patientOutput(struct patient *el, FILE *f, char sep, char lastSep);
/* Print out patient.  Separate fields with sep. Follow last field with lastSep. */

#define patientTabOut(el,f) patientOutput(el,f,'\t','\n');
/* Print out patient as a line in a tab-separated file. */

#define patientCommaOut(el,f) patientOutput(el,f,',',',');
/* Print out patient as a comma separated list including final comma. */

#define PATIENTINFO_NUM_COLS 8

struct patientInfo
/* Table patientInfo */
    {
    struct patientInfo *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *DataExtractDt;	/* Date data was downloaded from the CALGB database */
    char *Inst_ID;	/* Registering Institution */
    char *AgeCat;	/* Patient Age Category */
    float *Age;	/* Patient Age */
    char *Race_id;	/* Patient Race (1 case is 136 for white, black and American Indian or Alaska Native) */
    char *Sstat;	/* Survival Status */
    int *SurvDtD;	/* Survival date (time from study entry to death or last follow-up) */
    };

void patientInfoStaticLoadWithNull(char **row, struct patientInfo *ret);
/* Load a row from patientInfo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct patientInfo *patientInfoLoadWithNull(char **row);
/* Load a patientInfo from row fetched with select * from patientInfo
 * from database.  Dispose of this with patientInfoFree(). */

struct patientInfo *patientInfoLoadAll(char *fileName);
/* Load all patientInfo from whitespace-separated file.
 * Dispose of this with patientInfoFreeList(). */

struct patientInfo *patientInfoLoadAllByChar(char *fileName, char chopper);
/* Load all patientInfo from chopper separated file.
 * Dispose of this with patientInfoFreeList(). */

#define patientInfoLoadAllByTab(a) patientInfoLoadAllByChar(a, '\t');
/* Load all patientInfo from tab separated file.
 * Dispose of this with patientInfoFreeList(). */

struct patientInfo *patientInfoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all patientInfo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with patientInfoFreeList(). */

void patientInfoSaveToDb(struct sqlConnection *conn, struct patientInfo *el, char *tableName, int updateSize);
/* Save patientInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use patientInfoSaveToDbEscaped() */

void patientInfoSaveToDbEscaped(struct sqlConnection *conn, struct patientInfo *el, char *tableName, int updateSize);
/* Save patientInfo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than patientInfoSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct patientInfo *patientInfoCommaIn(char **pS, struct patientInfo *ret);
/* Create a patientInfo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new patientInfo */

void patientInfoFree(struct patientInfo **pEl);
/* Free a single dynamically allocated patientInfo such as created
 * with patientInfoLoad(). */

void patientInfoFreeList(struct patientInfo **pList);
/* Free a list of dynamically allocated patientInfo's */

void patientInfoOutput(struct patientInfo *el, FILE *f, char sep, char lastSep);
/* Print out patientInfo.  Separate fields with sep. Follow last field with lastSep. */

#define patientInfoTabOut(el,f) patientInfoOutput(el,f,'\t','\n');
/* Print out patientInfo as a line in a tab-separated file. */

#define patientInfoCommaOut(el,f) patientInfoOutput(el,f,',',',');
/* Print out patientInfo as a comma separated list including final comma. */

#define CHEMO_NUM_COLS 7

struct chemo
/* Table chemo */
    {
    struct chemo *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *Chemo;	/* Neo-Adjuvant Chemotherapy Regimen */
    char *ChemoCat;	/* Chemotherapy Group Category */
    char *DoseDenseAnthra;	/* Dose Dense Anthracycline Therapy? */
    char *DoseDenseTaxane;	/* Dose Dense Taxane Therapy? */
    char *Tam;	/* Tamoxifen received */
    char *Herceptin;	/* Herceptin received */
    };

void chemoStaticLoadWithNull(char **row, struct chemo *ret);
/* Load a row from chemo table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct chemo *chemoLoadWithNull(char **row);
/* Load a chemo from row fetched with select * from chemo
 * from database.  Dispose of this with chemoFree(). */

struct chemo *chemoLoadAll(char *fileName);
/* Load all chemo from whitespace-separated file.
 * Dispose of this with chemoFreeList(). */

struct chemo *chemoLoadAllByChar(char *fileName, char chopper);
/* Load all chemo from chopper separated file.
 * Dispose of this with chemoFreeList(). */

#define chemoLoadAllByTab(a) chemoLoadAllByChar(a, '\t');
/* Load all chemo from tab separated file.
 * Dispose of this with chemoFreeList(). */

struct chemo *chemoLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all chemo from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with chemoFreeList(). */

void chemoSaveToDb(struct sqlConnection *conn, struct chemo *el, char *tableName, int updateSize);
/* Save chemo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use chemoSaveToDbEscaped() */

void chemoSaveToDbEscaped(struct sqlConnection *conn, struct chemo *el, char *tableName, int updateSize);
/* Save chemo as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than chemoSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct chemo *chemoCommaIn(char **pS, struct chemo *ret);
/* Create a chemo out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new chemo */

void chemoFree(struct chemo **pEl);
/* Free a single dynamically allocated chemo such as created
 * with chemoLoad(). */

void chemoFreeList(struct chemo **pList);
/* Free a list of dynamically allocated chemo's */

void chemoOutput(struct chemo *el, FILE *f, char sep, char lastSep);
/* Print out chemo.  Separate fields with sep. Follow last field with lastSep. */

#define chemoTabOut(el,f) chemoOutput(el,f,'\t','\n');
/* Print out chemo as a line in a tab-separated file. */

#define chemoCommaOut(el,f) chemoOutput(el,f,',',',');
/* Print out chemo as a comma separated list including final comma. */

#define ONSTUDY_NUM_COLS 13

struct onStudy
/* Table onStudy */
    {
    struct onStudy *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *MenoStatus;	/* Menopausal Status */
    char *SentinelNodeSample;	/* Was Sentinel node sampling performed pre-treatment? */
    char *SentinelNodeResult;	/* Sentinel Node Biopsy Results pretreatment */
    char *HistTypeInvOS;	/* Histologic Type of Invasive Tumor (On-Study) */
    char *HistologicGradeOS;	/* Combined Histologic Grade - On-study (According to SBR/Elston Classification) */
    int *ER_TS;	/* Estrogen Receptor Status - Total Score Total Score = ER_PS+ ER_IS Considered Allred Score; 3 is positive */
    int *PgR_TS;	/* Progesterone Receptor Status - Total Score Total Score = PgR_PgS+ PgR_IS Considered Allred Score; 3 is positive */
    char *ERpos;	/* Estrogen Receptor Status (Allred Score or Community determined) */
    char *PgRpos;	/* Progesterone Receptor Status (Allred Score or Community determined) */
    char *Her2CommunityPos;	/* Her2 Summary as measured in the Community */
    char *Her2CommunityMethod;	/* Her2 Summary method as measured in the Community */
    char *pCR;	/* pathological complete response */
    };

void onStudyStaticLoadWithNull(char **row, struct onStudy *ret);
/* Load a row from onStudy table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct onStudy *onStudyLoadWithNull(char **row);
/* Load a onStudy from row fetched with select * from onStudy
 * from database.  Dispose of this with onStudyFree(). */

struct onStudy *onStudyLoadAll(char *fileName);
/* Load all onStudy from whitespace-separated file.
 * Dispose of this with onStudyFreeList(). */

struct onStudy *onStudyLoadAllByChar(char *fileName, char chopper);
/* Load all onStudy from chopper separated file.
 * Dispose of this with onStudyFreeList(). */

#define onStudyLoadAllByTab(a) onStudyLoadAllByChar(a, '\t');
/* Load all onStudy from tab separated file.
 * Dispose of this with onStudyFreeList(). */

struct onStudy *onStudyLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all onStudy from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with onStudyFreeList(). */

void onStudySaveToDb(struct sqlConnection *conn, struct onStudy *el, char *tableName, int updateSize);
/* Save onStudy as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use onStudySaveToDbEscaped() */

void onStudySaveToDbEscaped(struct sqlConnection *conn, struct onStudy *el, char *tableName, int updateSize);
/* Save onStudy as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than onStudySaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct onStudy *onStudyCommaIn(char **pS, struct onStudy *ret);
/* Create a onStudy out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new onStudy */

void onStudyFree(struct onStudy **pEl);
/* Free a single dynamically allocated onStudy such as created
 * with onStudyLoad(). */

void onStudyFreeList(struct onStudy **pList);
/* Free a list of dynamically allocated onStudy's */

void onStudyOutput(struct onStudy *el, FILE *f, char sep, char lastSep);
/* Print out onStudy.  Separate fields with sep. Follow last field with lastSep. */

#define onStudyTabOut(el,f) onStudyOutput(el,f,'\t','\n');
/* Print out onStudy as a line in a tab-separated file. */

#define onStudyCommaOut(el,f) onStudyOutput(el,f,',',',');
/* Print out onStudy as a comma separated list including final comma. */

#define POSTSURGERY_NUM_COLS 13

struct postSurgery
/* Table postSurgery */
    {
    struct postSurgery *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *SurgeryLumpectomy;	/* Surgery Procedure Performed was Partial mastectomy/lumpectomy/excisional biopsy */
    char *SurgeryMastectomy;	/* SurgeryMastectomy Surgery Procedure Performed was Mastectomy, NOS */
    char *InitLump_FupMast;	/* Initial Lumpectomy Surgery followed by Mastectomy Surgery at a later date */
    char *Surgery;	/* Did patient have extensive Primary Surgery immediately following chemotherapy? */
    char *DCISonly;	/* DCIS only thing left following surgery */
    float *PTumor1Szcm_Micro;	/* Primary Tumor Pathological Tumor */
    char *HistologicTypePS;	/* Histologic Type of Primary Tumor (Post-Surgery) */
    int *HistologicGradePS;	/* Combined Histologic Grade -Post-Surgery (According to SBR/Elston Classification) */
    int *NumPosNodes;	/* Total Number positive Axillary + Sentinel (post) Nodes, post-chemotherapy */
    char *NodesExamined;	/* Total Number of Axillary + Sentinel (post) nodes Examined, postchemotherapy */
    char *PathologyStage;	/* Pathology Assessment Staging */
    char *ReasonNoSurg;	/* Principal Reason Breast Conserving Surgery Not Performed */
    };

void postSurgeryStaticLoadWithNull(char **row, struct postSurgery *ret);
/* Load a row from postSurgery table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct postSurgery *postSurgeryLoadWithNull(char **row);
/* Load a postSurgery from row fetched with select * from postSurgery
 * from database.  Dispose of this with postSurgeryFree(). */

struct postSurgery *postSurgeryLoadAll(char *fileName);
/* Load all postSurgery from whitespace-separated file.
 * Dispose of this with postSurgeryFreeList(). */

struct postSurgery *postSurgeryLoadAllByChar(char *fileName, char chopper);
/* Load all postSurgery from chopper separated file.
 * Dispose of this with postSurgeryFreeList(). */

#define postSurgeryLoadAllByTab(a) postSurgeryLoadAllByChar(a, '\t');
/* Load all postSurgery from tab separated file.
 * Dispose of this with postSurgeryFreeList(). */

struct postSurgery *postSurgeryLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all postSurgery from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with postSurgeryFreeList(). */

void postSurgerySaveToDb(struct sqlConnection *conn, struct postSurgery *el, char *tableName, int updateSize);
/* Save postSurgery as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use postSurgerySaveToDbEscaped() */

void postSurgerySaveToDbEscaped(struct sqlConnection *conn, struct postSurgery *el, char *tableName, int updateSize);
/* Save postSurgery as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than postSurgerySaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct postSurgery *postSurgeryCommaIn(char **pS, struct postSurgery *ret);
/* Create a postSurgery out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new postSurgery */

void postSurgeryFree(struct postSurgery **pEl);
/* Free a single dynamically allocated postSurgery such as created
 * with postSurgeryLoad(). */

void postSurgeryFreeList(struct postSurgery **pList);
/* Free a list of dynamically allocated postSurgery's */

void postSurgeryOutput(struct postSurgery *el, FILE *f, char sep, char lastSep);
/* Print out postSurgery.  Separate fields with sep. Follow last field with lastSep. */

#define postSurgeryTabOut(el,f) postSurgeryOutput(el,f,'\t','\n');
/* Print out postSurgery as a line in a tab-separated file. */

#define postSurgeryCommaOut(el,f) postSurgeryOutput(el,f,',',',');
/* Print out postSurgery as a comma separated list including final comma. */

#define FOLLOWUP_NUM_COLS 9

struct followUp
/* Table followUp */
    {
    struct followUp *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *RtTherapy;	/* Has patient received adjuvant radiation therapy (prior to treatment failure or second primary cancer)?  */
    char *RtBreast;	/* Radiation to Breast */
    char *RtBoost;	/* Radiation to Boost */
    char *RtAxilla;	/* Radiation to Axilla */
    char *RtSNode;	/* Radiation to Supraclavicular node */
    char *RtIMamNode;	/* Radiation to Internal Mammary node */
    char *RTChestW;	/* Radiation to Chest Wall */
    char *RtOther;	/* Radiation to Other Site */
    };

void followUpStaticLoadWithNull(char **row, struct followUp *ret);
/* Load a row from followUp table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct followUp *followUpLoadWithNull(char **row);
/* Load a followUp from row fetched with select * from followUp
 * from database.  Dispose of this with followUpFree(). */

struct followUp *followUpLoadAll(char *fileName);
/* Load all followUp from whitespace-separated file.
 * Dispose of this with followUpFreeList(). */

struct followUp *followUpLoadAllByChar(char *fileName, char chopper);
/* Load all followUp from chopper separated file.
 * Dispose of this with followUpFreeList(). */

#define followUpLoadAllByTab(a) followUpLoadAllByChar(a, '\t');
/* Load all followUp from tab separated file.
 * Dispose of this with followUpFreeList(). */

struct followUp *followUpLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all followUp from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with followUpFreeList(). */

void followUpSaveToDb(struct sqlConnection *conn, struct followUp *el, char *tableName, int updateSize);
/* Save followUp as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use followUpSaveToDbEscaped() */

void followUpSaveToDbEscaped(struct sqlConnection *conn, struct followUp *el, char *tableName, int updateSize);
/* Save followUp as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than followUpSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct followUp *followUpCommaIn(char **pS, struct followUp *ret);
/* Create a followUp out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new followUp */

void followUpFree(struct followUp **pEl);
/* Free a single dynamically allocated followUp such as created
 * with followUpLoad(). */

void followUpFreeList(struct followUp **pList);
/* Free a list of dynamically allocated followUp's */

void followUpOutput(struct followUp *el, FILE *f, char sep, char lastSep);
/* Print out followUp.  Separate fields with sep. Follow last field with lastSep. */

#define followUpTabOut(el,f) followUpOutput(el,f,'\t','\n');
/* Print out followUp as a line in a tab-separated file. */

#define followUpCommaOut(el,f) followUpOutput(el,f,',',',');
/* Print out followUp as a comma separated list including final comma. */

#define RESPEVAL_NUM_COLS 10

struct respEval
/* Table respEval */
    {
    struct respEval *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    float *TSizeClinical;	/* Size of Primary Tumor (cm) - Clinical Assessment at Baseline */
    float *NSizeClinical;	/* Size of Largest Palpable Node (cm) - Clinical Assessment at Baseline */
    char *StageTe;	/* Disease Stage T (metastasis) Baseline */
    char *StageNe;	/* Disease Stage N (metastasis) Baseline */
    char *StageMe;	/* Disease Stage M (metastasis) Baseline */
    char *ClinicalStage;	/* Clinical Staging at Baseline */
    char *ClinRespT1_T2;	/* Clinical Response Baseline to Early Treatment */
    char *ClinRespT1_T3;	/* Clinical Response Baseline to Inter-Regimen */
    char *ClinRespT1_T4;	/* Clinical Response Baseline to Pre-Surgery */
    };

void respEvalStaticLoadWithNull(char **row, struct respEval *ret);
/* Load a row from respEval table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct respEval *respEvalLoadWithNull(char **row);
/* Load a respEval from row fetched with select * from respEval
 * from database.  Dispose of this with respEvalFree(). */

struct respEval *respEvalLoadAll(char *fileName);
/* Load all respEval from whitespace-separated file.
 * Dispose of this with respEvalFreeList(). */

struct respEval *respEvalLoadAllByChar(char *fileName, char chopper);
/* Load all respEval from chopper separated file.
 * Dispose of this with respEvalFreeList(). */

#define respEvalLoadAllByTab(a) respEvalLoadAllByChar(a, '\t');
/* Load all respEval from tab separated file.
 * Dispose of this with respEvalFreeList(). */

struct respEval *respEvalLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all respEval from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with respEvalFreeList(). */

void respEvalSaveToDb(struct sqlConnection *conn, struct respEval *el, char *tableName, int updateSize);
/* Save respEval as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use respEvalSaveToDbEscaped() */

void respEvalSaveToDbEscaped(struct sqlConnection *conn, struct respEval *el, char *tableName, int updateSize);
/* Save respEval as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than respEvalSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct respEval *respEvalCommaIn(char **pS, struct respEval *ret);
/* Create a respEval out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new respEval */

void respEvalFree(struct respEval **pEl);
/* Free a single dynamically allocated respEval such as created
 * with respEvalLoad(). */

void respEvalFreeList(struct respEval **pList);
/* Free a list of dynamically allocated respEval's */

void respEvalOutput(struct respEval *el, FILE *f, char sep, char lastSep);
/* Print out respEval.  Separate fields with sep. Follow last field with lastSep. */

#define respEvalTabOut(el,f) respEvalOutput(el,f,'\t','\n');
/* Print out respEval as a line in a tab-separated file. */

#define respEvalCommaOut(el,f) respEvalOutput(el,f,',',',');
/* Print out respEval as a comma separated list including final comma. */

#define MR_NUM_COLS 20

struct mr
/* Table mr */
    {
    struct mr *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *ChemoCat;	/* CHEMOCAT */
    char *DoseDenseAnthra;	/* DOSEDENSEANTHRA */
    char *DoseDenseTaxane;	/* DOSEDENSETAXANE */
    char *LES_T1;	/* Lesion type at T1 Pre-Treatment - Baseline. */
    char *LES_T2;	/* Lesion type at the T2 Early Treatment timepoint (as indicated on the M4 form). */
    char *LES_T3;	/* Lesion type at the T3 Between Treatment Regimes timepoint (as indicated on the M4 form). */
    char *LES_T4;	/* Lesion type at the T4 Pre-Surgery timepoint (as indicated on the M4 form). */
    int *LD_T1;	/* Longest Diameter (LD) in the cancer mass at T1 Pre-Treatment - Baseline. */
    int *LD_T2;	/* Longest Diameter (LD) in the cancer mass at the T2 Early Treatment timepoint. */
    int *LD_T3;	/* Longest Diameter (LD) in the cancer mass at the T3 Between Treatment Regimes timepoint. */
    int *LD_T4;	/* Longest Diameter (LD) in the cancer mass at the T4 Pre-Surgery timepoint. */
    float *LD_T1_T2_PERCT;	/* The percentage of Longest Dimension (LD) change between T1 and T2 */
    float *LD_T1_T3_PERCT;	/* The percentage of Longest Dimension (LD) change between T1 and T3 */
    float *LD_T1_T4_PERCT;	/* The percentage of Longest Dimension (LD) change between T1 and T4 */
    float *LD_T2_T3_PERCT;	/* The percentage of Longest Dimension (LD) change between T2 and T3 */
    float *LD_T2_T4_PERCT;	/* The percentage of Longest Dimension (LD) change between T2 and T4 */
    float *LD_T3_T4_PERCT;	/* The percentage of Longest Dimension (LD) change between T3 and T4 */
    char *Mri_Pattern_Code;	/* MRI Pattern Code */
    char *Mri_Pattern_Desc;	/* MRI Pattern Description */
    };

void mrStaticLoadWithNull(char **row, struct mr *ret);
/* Load a row from mr table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct mr *mrLoadWithNull(char **row);
/* Load a mr from row fetched with select * from mr
 * from database.  Dispose of this with mrFree(). */

struct mr *mrLoadAll(char *fileName);
/* Load all mr from whitespace-separated file.
 * Dispose of this with mrFreeList(). */

struct mr *mrLoadAllByChar(char *fileName, char chopper);
/* Load all mr from chopper separated file.
 * Dispose of this with mrFreeList(). */

#define mrLoadAllByTab(a) mrLoadAllByChar(a, '\t');
/* Load all mr from tab separated file.
 * Dispose of this with mrFreeList(). */

struct mr *mrLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all mr from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with mrFreeList(). */

void mrSaveToDb(struct sqlConnection *conn, struct mr *el, char *tableName, int updateSize);
/* Save mr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use mrSaveToDbEscaped() */

void mrSaveToDbEscaped(struct sqlConnection *conn, struct mr *el, char *tableName, int updateSize);
/* Save mr as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than mrSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct mr *mrCommaIn(char **pS, struct mr *ret);
/* Create a mr out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new mr */

void mrFree(struct mr **pEl);
/* Free a single dynamically allocated mr such as created
 * with mrLoad(). */

void mrFreeList(struct mr **pList);
/* Free a list of dynamically allocated mr's */

void mrOutput(struct mr *el, FILE *f, char sep, char lastSep);
/* Print out mr.  Separate fields with sep. Follow last field with lastSep. */

#define mrTabOut(el,f) mrOutput(el,f,'\t','\n');
/* Print out mr as a line in a tab-separated file. */

#define mrCommaOut(el,f) mrOutput(el,f,',',',');
/* Print out mr as a comma separated list including final comma. */

#define CDNA_NUM_COLS 5

struct cdna
/* Table cdna */
    {
    struct cdna *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *Cdna_T1;	/* CDNA at T1 */
    char *Cdna_T2;	/* CDNA at T2 */
    char *Cdna_T3;	/* CDNA at T3 */
    char *Cdna_T4;	/* CDNA at T4 */
    };

void cdnaStaticLoadWithNull(char **row, struct cdna *ret);
/* Load a row from cdna table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct cdna *cdnaLoadWithNull(char **row);
/* Load a cdna from row fetched with select * from cdna
 * from database.  Dispose of this with cdnaFree(). */

struct cdna *cdnaLoadAll(char *fileName);
/* Load all cdna from whitespace-separated file.
 * Dispose of this with cdnaFreeList(). */

struct cdna *cdnaLoadAllByChar(char *fileName, char chopper);
/* Load all cdna from chopper separated file.
 * Dispose of this with cdnaFreeList(). */

#define cdnaLoadAllByTab(a) cdnaLoadAllByChar(a, '\t');
/* Load all cdna from tab separated file.
 * Dispose of this with cdnaFreeList(). */

struct cdna *cdnaLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all cdna from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with cdnaFreeList(). */

void cdnaSaveToDb(struct sqlConnection *conn, struct cdna *el, char *tableName, int updateSize);
/* Save cdna as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use cdnaSaveToDbEscaped() */

void cdnaSaveToDbEscaped(struct sqlConnection *conn, struct cdna *el, char *tableName, int updateSize);
/* Save cdna as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than cdnaSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct cdna *cdnaCommaIn(char **pS, struct cdna *ret);
/* Create a cdna out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cdna */

void cdnaFree(struct cdna **pEl);
/* Free a single dynamically allocated cdna such as created
 * with cdnaLoad(). */

void cdnaFreeList(struct cdna **pList);
/* Free a list of dynamically allocated cdna's */

void cdnaOutput(struct cdna *el, FILE *f, char sep, char lastSep);
/* Print out cdna.  Separate fields with sep. Follow last field with lastSep. */

#define cdnaTabOut(el,f) cdnaOutput(el,f,'\t','\n');
/* Print out cdna as a line in a tab-separated file. */

#define cdnaCommaOut(el,f) cdnaOutput(el,f,',',',');
/* Print out cdna as a comma separated list including final comma. */

#define AGI_NUM_COLS 5

struct agi
/* Table agi */
    {
    struct agi *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *Agi_T1;	/* AGI at T1 */
    char *Agi_T2;	/* AGI at T2 */
    char *Agi_T3;	/* AGI at T3 */
    char *Agi_T4;	/* AGI at T4 */
    };

void agiStaticLoadWithNull(char **row, struct agi *ret);
/* Load a row from agi table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct agi *agiLoadWithNull(char **row);
/* Load a agi from row fetched with select * from agi
 * from database.  Dispose of this with agiFree(). */

struct agi *agiLoadAll(char *fileName);
/* Load all agi from whitespace-separated file.
 * Dispose of this with agiFreeList(). */

struct agi *agiLoadAllByChar(char *fileName, char chopper);
/* Load all agi from chopper separated file.
 * Dispose of this with agiFreeList(). */

#define agiLoadAllByTab(a) agiLoadAllByChar(a, '\t');
/* Load all agi from tab separated file.
 * Dispose of this with agiFreeList(). */

struct agi *agiLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all agi from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with agiFreeList(). */

void agiSaveToDb(struct sqlConnection *conn, struct agi *el, char *tableName, int updateSize);
/* Save agi as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use agiSaveToDbEscaped() */

void agiSaveToDbEscaped(struct sqlConnection *conn, struct agi *el, char *tableName, int updateSize);
/* Save agi as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than agiSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct agi *agiCommaIn(char **pS, struct agi *ret);
/* Create a agi out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new agi */

void agiFree(struct agi **pEl);
/* Free a single dynamically allocated agi such as created
 * with agiLoad(). */

void agiFreeList(struct agi **pList);
/* Free a list of dynamically allocated agi's */

void agiOutput(struct agi *el, FILE *f, char sep, char lastSep);
/* Print out agi.  Separate fields with sep. Follow last field with lastSep. */

#define agiTabOut(el,f) agiOutput(el,f,'\t','\n');
/* Print out agi as a line in a tab-separated file. */

#define agiCommaOut(el,f) agiOutput(el,f,',',',');
/* Print out agi as a comma separated list including final comma. */

#define IHC_NUM_COLS 5

struct ihc
/* Table ihc */
    {
    struct ihc *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *Ihc_T1;	/* IHC at T1 */
    char *Ihc_T2;	/* IHC at T2 */
    char *Ihc_T3;	/* IHC at T3 */
    char *Ihc_T4;	/* IHC at T4 */
    };

void ihcStaticLoadWithNull(char **row, struct ihc *ret);
/* Load a row from ihc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct ihc *ihcLoadWithNull(char **row);
/* Load a ihc from row fetched with select * from ihc
 * from database.  Dispose of this with ihcFree(). */

struct ihc *ihcLoadAll(char *fileName);
/* Load all ihc from whitespace-separated file.
 * Dispose of this with ihcFreeList(). */

struct ihc *ihcLoadAllByChar(char *fileName, char chopper);
/* Load all ihc from chopper separated file.
 * Dispose of this with ihcFreeList(). */

#define ihcLoadAllByTab(a) ihcLoadAllByChar(a, '\t');
/* Load all ihc from tab separated file.
 * Dispose of this with ihcFreeList(). */

struct ihc *ihcLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all ihc from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with ihcFreeList(). */

void ihcSaveToDb(struct sqlConnection *conn, struct ihc *el, char *tableName, int updateSize);
/* Save ihc as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use ihcSaveToDbEscaped() */

void ihcSaveToDbEscaped(struct sqlConnection *conn, struct ihc *el, char *tableName, int updateSize);
/* Save ihc as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than ihcSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct ihc *ihcCommaIn(char **pS, struct ihc *ret);
/* Create a ihc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new ihc */

void ihcFree(struct ihc **pEl);
/* Free a single dynamically allocated ihc such as created
 * with ihcLoad(). */

void ihcFreeList(struct ihc **pList);
/* Free a list of dynamically allocated ihc's */

void ihcOutput(struct ihc *el, FILE *f, char sep, char lastSep);
/* Print out ihc.  Separate fields with sep. Follow last field with lastSep. */

#define ihcTabOut(el,f) ihcOutput(el,f,'\t','\n');
/* Print out ihc as a line in a tab-separated file. */

#define ihcCommaOut(el,f) ihcOutput(el,f,',',',');
/* Print out ihc as a comma separated list including final comma. */

#define FISH_NUM_COLS 5

struct fish
/* Table fish */
    {
    struct fish *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *Fish_T1;	/* FISH at T1 */
    char *Fish_T2;	/* FISH at T2 */
    char *Fish_T3;	/* FISH at T3 */
    char *Fish_T4;	/* FISH at T4 */
    };

void fishStaticLoadWithNull(char **row, struct fish *ret);
/* Load a row from fish table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct fish *fishLoadWithNull(char **row);
/* Load a fish from row fetched with select * from fish
 * from database.  Dispose of this with fishFree(). */

struct fish *fishLoadAll(char *fileName);
/* Load all fish from whitespace-separated file.
 * Dispose of this with fishFreeList(). */

struct fish *fishLoadAllByChar(char *fileName, char chopper);
/* Load all fish from chopper separated file.
 * Dispose of this with fishFreeList(). */

#define fishLoadAllByTab(a) fishLoadAllByChar(a, '\t');
/* Load all fish from tab separated file.
 * Dispose of this with fishFreeList(). */

struct fish *fishLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all fish from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with fishFreeList(). */

void fishSaveToDb(struct sqlConnection *conn, struct fish *el, char *tableName, int updateSize);
/* Save fish as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use fishSaveToDbEscaped() */

void fishSaveToDbEscaped(struct sqlConnection *conn, struct fish *el, char *tableName, int updateSize);
/* Save fish as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than fishSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct fish *fishCommaIn(char **pS, struct fish *ret);
/* Create a fish out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new fish */

void fishFree(struct fish **pEl);
/* Free a single dynamically allocated fish such as created
 * with fishLoad(). */

void fishFreeList(struct fish **pList);
/* Free a list of dynamically allocated fish's */

void fishOutput(struct fish *el, FILE *f, char sep, char lastSep);
/* Print out fish.  Separate fields with sep. Follow last field with lastSep. */

#define fishTabOut(el,f) fishOutput(el,f,'\t','\n');
/* Print out fish as a line in a tab-separated file. */

#define fishCommaOut(el,f) fishOutput(el,f,',',',');
/* Print out fish as a comma separated list including final comma. */

#define LABTRACK_NUM_COLS 5

struct labTrack
/* Table labTrack */
    {
    struct labTrack *next;  /* Next in singly linked list. */
    char *ispyId;	/* I-SPY identifier uniquely corresponds 1 to 1 to the CALGB patient identifier */
    char *trackId;	/* Lab Track ID */
    char *coreType;	/* Core Type */
    char *timePoint;	/* Time Point */
    char *section;	/* Section */
    };

void labTrackStaticLoadWithNull(char **row, struct labTrack *ret);
/* Load a row from labTrack table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct labTrack *labTrackLoadWithNull(char **row);
/* Load a labTrack from row fetched with select * from labTrack
 * from database.  Dispose of this with labTrackFree(). */

struct labTrack *labTrackLoadAll(char *fileName);
/* Load all labTrack from whitespace-separated file.
 * Dispose of this with labTrackFreeList(). */

struct labTrack *labTrackLoadAllByChar(char *fileName, char chopper);
/* Load all labTrack from chopper separated file.
 * Dispose of this with labTrackFreeList(). */

#define labTrackLoadAllByTab(a) labTrackLoadAllByChar(a, '\t');
/* Load all labTrack from tab separated file.
 * Dispose of this with labTrackFreeList(). */

struct labTrack *labTrackLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all labTrack from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with labTrackFreeList(). */

void labTrackSaveToDb(struct sqlConnection *conn, struct labTrack *el, char *tableName, int updateSize);
/* Save labTrack as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use labTrackSaveToDbEscaped() */

void labTrackSaveToDbEscaped(struct sqlConnection *conn, struct labTrack *el, char *tableName, int updateSize);
/* Save labTrack as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than labTrackSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct labTrack *labTrackCommaIn(char **pS, struct labTrack *ret);
/* Create a labTrack out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new labTrack */

void labTrackFree(struct labTrack **pEl);
/* Free a single dynamically allocated labTrack such as created
 * with labTrackLoad(). */

void labTrackFreeList(struct labTrack **pList);
/* Free a list of dynamically allocated labTrack's */

void labTrackOutput(struct labTrack *el, FILE *f, char sep, char lastSep);
/* Print out labTrack.  Separate fields with sep. Follow last field with lastSep. */

#define labTrackTabOut(el,f) labTrackOutput(el,f,'\t','\n');
/* Print out labTrack as a line in a tab-separated file. */

#define labTrackCommaOut(el,f) labTrackOutput(el,f,',',',');
/* Print out labTrack as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* ISPYTABLES_H */

