/* variome.h was originally generated by the autoSql program, which also 
 * generated variome.c and variome.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef VARIOME_H
#define VARIOME_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define VARIOME_NUM_COLS 16

struct variome
/* variome bed 6+ structure */
    {
    struct variome *next;  /* Next in singly linked list. */
    unsigned short bin;	/* used for efficient position indexing */
    char *chrom;	/* Reference sequence chromosome or scaffold */
    unsigned chromStart;	/* Start position in chromosome */
    unsigned chromEnd;	/* End position in chromosome */
    char *name;	/* Name of item */
    unsigned score;	/* Score from 0-1000 */
    char strand[2];	/* + or - */
    char *db;	/* database for item */
    char *owner;	/* creator of item */
    char *color;	/* rgb color of item (currently unused) */
    char *class;	/* classification of item (browser group) */
    char *creationDate;	/* date item created */
    char *lastModifiedDate;	/* date item last updated */
    char *descriptionKey;	/* name of wiki description page */
    unsigned id;	/* auto-increment item ID */
    char *geneSymbol;	/* knownGene kgXref geneSymbol name */
    };

void variomeStaticLoad(char **row, struct variome *ret);
/* Load a row from variome table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct variome *variomeLoad(char **row);
/* Load a variome from row fetched with select * from variome
 * from database.  Dispose of this with variomeFree(). */

struct variome *variomeLoadAll(char *fileName);
/* Load all variome from whitespace-separated file.
 * Dispose of this with variomeFreeList(). */

struct variome *variomeLoadAllByChar(char *fileName, char chopper);
/* Load all variome from chopper separated file.
 * Dispose of this with variomeFreeList(). */

#define variomeLoadAllByTab(a) variomeLoadAllByChar(a, '\t');
/* Load all variome from tab separated file.
 * Dispose of this with variomeFreeList(). */

struct variome *variomeLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all variome from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with variomeFreeList(). */

void variomeSaveToDb(struct sqlConnection *conn, struct variome *el, char *tableName, int updateSize);
/* Save variome as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use variomeSaveToDbEscaped() */

void variomeSaveToDbEscaped(struct sqlConnection *conn, struct variome *el, char *tableName, int updateSize);
/* Save variome as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than variomeSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct variome *variomeCommaIn(char **pS, struct variome *ret);
/* Create a variome out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new variome */

void variomeFree(struct variome **pEl);
/* Free a single dynamically allocated variome such as created
 * with variomeLoad(). */

void variomeFreeList(struct variome **pList);
/* Free a list of dynamically allocated variome's */

void variomeOutput(struct variome *el, FILE *f, char sep, char lastSep);
/* Print out variome.  Separate fields with sep. Follow last field with lastSep. */

#define variomeTabOut(el,f) variomeOutput(el,f,'\t','\n');
/* Print out variome as a line in a tab-separated file. */

#define variomeCommaOut(el,f) variomeOutput(el,f,',',',');
/* Print out variome as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */
extern char *variomeClassList[];
extern int variomeClassCnt;
extern char *variomeCoorList[];

struct variome *findVariomeItemId(char *db, char *wikiItemId);
/* given a wikiItemId return the row from the table */

int addVariomeItem(char *db, char *chrom, int start, int end,
    char *name, int score, char *strand, char *owner, char *class,
        char *color, char *category, char *geneSymbol, char *wikiKey);
/* create new Variome row with given parameters */

void updateVariomeLastModifiedDate(char *db, int id);
/* set lastModifiedDate to now() */

void deleteVariomeItem(char *db, int id);
/* delete the item with specified id */

#endif /* VARIOME_H */

