/* pgPhenoAssoc.c was originally generated by the autoSql program, which also 
 * generated pgPhenoAssoc.h and pgPhenoAssoc.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "pgPhenoAssoc.h"


void pgPhenoAssocStaticLoad(char **row, struct pgPhenoAssoc *ret)
/* Load a row from pgPhenoAssoc table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->srcUrl = row[4];
}

struct pgPhenoAssoc *pgPhenoAssocLoad(char **row)
/* Load a pgPhenoAssoc from row fetched with select * from pgPhenoAssoc
 * from database.  Dispose of this with pgPhenoAssocFree(). */
{
struct pgPhenoAssoc *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->srcUrl = cloneString(row[4]);
return ret;
}

struct pgPhenoAssoc *pgPhenoAssocLoadAll(char *fileName) 
/* Load all pgPhenoAssoc from a whitespace-separated file.
 * Dispose of this with pgPhenoAssocFreeList(). */
{
struct pgPhenoAssoc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = pgPhenoAssocLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct pgPhenoAssoc *pgPhenoAssocLoadAllByChar(char *fileName, char chopper) 
/* Load all pgPhenoAssoc from a chopper separated file.
 * Dispose of this with pgPhenoAssocFreeList(). */
{
struct pgPhenoAssoc *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = pgPhenoAssocLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct pgPhenoAssoc *pgPhenoAssocCommaIn(char **pS, struct pgPhenoAssoc *ret)
/* Create a pgPhenoAssoc out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new pgPhenoAssoc */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->srcUrl = sqlStringComma(&s);
*pS = s;
return ret;
}

void pgPhenoAssocFree(struct pgPhenoAssoc **pEl)
/* Free a single dynamically allocated pgPhenoAssoc such as created
 * with pgPhenoAssocLoad(). */
{
struct pgPhenoAssoc *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->srcUrl);
freez(pEl);
}

void pgPhenoAssocFreeList(struct pgPhenoAssoc **pList)
/* Free a list of dynamically allocated pgPhenoAssoc's */
{
struct pgPhenoAssoc *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    pgPhenoAssocFree(&el);
    }
*pList = NULL;
}

void pgPhenoAssocOutput(struct pgPhenoAssoc *el, FILE *f, char sep, char lastSep) 
/* Print out pgPhenoAssoc.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->srcUrl);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

