/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.decoration;

import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.AbstractLineDecoration;
import org.xmind.gef.draw2d.decoration.IConnectionDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;

public abstract class AbstractConnectionDecoration
extends AbstractLineDecoration
implements IConnectionDecoration {
    private IAnchor sourceAnchor = null;
    private IAnchor targetAnchor = null;
    private PrecisionPoint sourcePos = null;
    private PrecisionPoint targetPos = null;

    protected AbstractConnectionDecoration() {
    }

    protected AbstractConnectionDecoration(String id) {
        super(id);
    }

    public IAnchor getSourceAnchor() {
        return this.sourceAnchor;
    }

    public IAnchor getTargetAnchor() {
        return this.targetAnchor;
    }

    public void setSourceAnchor(IFigure figure, IAnchor anchor) {
        if (anchor == this.sourceAnchor) {
            return;
        }
        this.sourceAnchor = anchor;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public void setTargetAnchor(IFigure figure, IAnchor anchor) {
        if (anchor == this.targetAnchor) {
            return;
        }
        this.targetAnchor = anchor;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public PrecisionPoint getSourcePosition(IFigure figure) {
        this.checkValidation(figure);
        return this.sourcePos;
    }

    public PrecisionPoint getTargetPosition(IFigure figure) {
        this.checkValidation(figure);
        return this.targetPos;
    }

    public void reroute(IFigure figure) {
        this.reroute(figure, false);
    }

    protected void reroute(IFigure figure, boolean validating) {
        PrecisionPoint oldSourcePos = this.sourcePos;
        PrecisionPoint oldTargetPos = this.targetPos;
        PrecisionPoint newSourcePos = new PrecisionPoint();
        PrecisionPoint newTargetPos = new PrecisionPoint();
        this.reroute(figure, newSourcePos, newTargetPos, validating);
        this.sourcePos = this.checkPoint(newSourcePos);
        this.targetPos = this.checkPoint(newTargetPos);
        if (!validating && figure != null) {
            boolean translational;
            boolean noMove = newSourcePos.equals(oldSourcePos) && newTargetPos.equals(oldTargetPos);
            boolean bl = translational = oldSourcePos != null && newSourcePos != null && oldTargetPos != null && newTargetPos != null && Math.abs(newTargetPos.x - oldTargetPos.x - (newSourcePos.x - oldSourcePos.x)) < 1.0 && Math.abs(newTargetPos.y - oldTargetPos.y - (newSourcePos.y - oldSourcePos.y)) < 1.0;
            if (!noMove && !translational) {
                figure.revalidate();
                this.repaint(figure);
            }
        }
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean validating) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        if (sa == null || ta == null) {
            if (sa != null) {
                sourcePos.setLocation(sa.getReferencePoint());
            }
            if (ta != null) {
                targetPos.setLocation(ta.getReferencePoint());
            }
            return;
        }
        targetPos.setLocation(ta.getLocation(sa.getReferencePoint(), 0.0));
        sourcePos.setLocation(sa.getLocation(ta.getReferencePoint(), 0.0));
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        if (!this.isPositionValid()) {
            this.reroute(figure, true);
        }
    }

    protected boolean isPositionValid() {
        return this.sourcePos != null && this.targetPos != null;
    }

    protected PrecisionPoint checkPoint(PrecisionPoint source) {
        if (Double.isNaN(source.x) || Double.isInfinite(source.x)) {
            source.x = 0.0;
        }
        if (Double.isNaN(source.y) || Double.isInfinite(source.y)) {
            source.y = 0.0;
        }
        return source;
    }
}

