/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.geometry.AbstractIntersectionSolver;
import org.xmind.gef.draw2d.geometry.HorizontalFlipper;
import org.xmind.gef.draw2d.geometry.ITransformer;
import org.xmind.gef.draw2d.geometry.Transposer;

public class SplitIntersectionSolver
extends AbstractIntersectionSolver {
    private ITransformer t = new Transposer();
    private ITransformer f;
    private Object currentKey = null;
    private Rectangle intersection = null;

    public SplitIntersectionSolver() {
        this(true);
    }

    public SplitIntersectionSolver(boolean horizontal) {
        this.t.setEnabled(!horizontal);
        this.f = new HorizontalFlipper();
    }

    public void setHorizontal(boolean horizontal) {
        this.t.setEnabled(!horizontal);
    }

    protected boolean calcIntersections() {
        for (Object key : this.getFreeKeys()) {
            Rectangle freeBounds = this.getSolvedBounds(key);
            if (freeBounds == null) continue;
            for (Object steadyKey : this.getSteadyKeys()) {
                Rectangle steadyBounds = this.getSolvedBounds(steadyKey);
                if (steadyBounds == null) continue;
                this.intersection = freeBounds.getIntersection(steadyBounds);
                if (this.intersection.isEmpty()) continue;
                this.currentKey = key;
                return true;
            }
            for (Object key2 : this.getFreeKeys()) {
                Rectangle freeBounds2;
                if (key2 == key || (freeBounds2 = this.getSolvedBounds(key2)) == null) continue;
                this.intersection = freeBounds.getIntersection(freeBounds2);
                if (this.intersection.isEmpty()) continue;
                this.currentKey = key;
                return true;
            }
        }
        return false;
    }

    public void setOrigin(int x, int y) {
        this.t.setOrigin(x, y);
        this.f.setOrigin(x, y);
        super.setOrigin(x, y);
    }

    public void setOrigin(Point origin) {
        this.t.setOrigin(origin);
        this.f.setOrigin(origin);
        super.setOrigin(origin);
    }

    protected void solveIntersections() {
        this.t.t(this.intersection);
        Point pos = this.getSolvedPosition(this.currentKey);
        this.t.t(pos);
        this.f.setEnabled(pos.x < this.getOrigin().x);
        this.f.t(pos);
        pos.x += this.intersection.width + Math.max(1, this.getSpacing());
        this.t.r(this.f.r(pos));
        this.t.r(this.intersection);
    }
}

