/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.tool;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.Request;
import org.xmind.gef.event.KeyEvent;
import org.xmind.gef.event.MouseDragEvent;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.GraphicalTool;
import org.xmind.gef.tool.IDraggingTool;
import org.xmind.gef.tool.ITool;

public abstract class DraggingTool
extends GraphicalTool
implements IDraggingTool {
    private Point startPos = null;
    private boolean scrolling = false;
    private boolean ended = false;

    public Point getStartingPosition() {
        return this.startPos;
    }

    public void setStartingPosition(Point pos) {
        this.startPos = pos;
    }

    protected void onActivated(ITool prevTool) {
        super.onActivated(prevTool);
        if (this.startPos != null) {
            this.ended = false;
            this.start();
        }
    }

    protected void onDeactivated(ITool nextTool) {
        if (!this.ended) {
            this.ended = true;
            this.end();
            this.startPos = null;
        }
        super.onDeactivated(nextTool);
    }

    protected abstract void start();

    protected abstract void end();

    protected abstract void onDragging(Point var1, MouseDragEvent var2);

    protected boolean handleMouseDown(MouseEvent me) {
        if (this.startPos == null) {
            this.startPos = me.cursorLocation;
            this.ended = false;
            this.start();
            return true;
        }
        return super.handleMouseDown(me);
    }

    protected boolean handleMouseDrag(MouseDragEvent me) {
        this.onDragging(this.getCursorPosition(), me);
        return true;
    }

    public IFigure getToolTip(IPart source, Point position) {
        return null;
    }

    protected IFigure superFindToolTip(IPart source, Point position) {
        return super.getToolTip(source, position);
    }

    protected void ensureDragPositionVisible(Point currentPos, final MouseDragEvent me) {
        Rectangle r = this.getTargetViewer().getZoomManager().getAntiScaled(this.getTargetViewer().getClientArea());
        int deltaX = 0;
        int deltaY = 0;
        if (currentPos.x < r.x) {
            deltaX = currentPos.x - r.x;
        } else if (currentPos.x > r.right()) {
            deltaX = currentPos.x - r.right();
        }
        if (currentPos.y < r.y) {
            deltaY = currentPos.y - r.y;
        } else if (currentPos.y > r.bottom()) {
            deltaY = currentPos.y - r.bottom();
        }
        if (Math.abs(deltaX) < this.getScrollingDetection() && Math.abs(deltaY) < this.getScrollingDetection()) {
            if (deltaX != 0 || deltaY != 0) {
                this.getTargetViewer().scrollDelta(deltaX, deltaY);
                this.setCursorPosition(currentPos.getTranslated(deltaX, deltaY));
                this.scrolling = true;
                this.getTargetViewer().getControl().getDisplay().timerExec(200, new Runnable(){

                    public void run() {
                        if (DraggingTool.this.scrolling) {
                            DraggingTool.this.onDragging(DraggingTool.this.getCursorPosition(), me);
                        }
                    }
                });
            } else {
                this.scrolling = false;
            }
        } else {
            this.scrolling = false;
        }
    }

    protected int getScrollingDetection() {
        return 20;
    }

    protected boolean handleMouseUp(MouseEvent me) {
        this.scrolling = false;
        this.finish();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent ke) {
        if (ke.keyCode == 27) {
            this.cancel();
            return true;
        }
        return super.handleKeyDown(ke);
    }

    public void finish() {
        if (!this.ended) {
            this.ended = true;
            this.end();
            this.startPos = null;
        }
        if (this.getDomain().getActiveTool() == this) {
            this.changeToNextTool();
        }
    }

    public void cancel() {
        if (!this.ended) {
            this.ended = true;
            this.end();
            this.startPos = null;
        }
        if (this.getDomain().getActiveTool() == this) {
            this.changeToNextTool();
        }
    }

    protected void changeToNextTool() {
        this.changeActiveTool("default tool");
    }

    protected void internalHandleRequest(Request request) {
        if (request.getTargetViewer() == null || request.getTargetViewer() != this.getTargetViewer()) {
            super.internalHandleRequest(request);
            return;
        }
        String requestType = request.getType();
        if ("finish".equals(requestType)) {
            this.finish();
        } else if ("cancel".equals(requestType)) {
            this.cancel();
        } else {
            this.cancel();
            if (!this.getStatus().isStatus(1)) {
                this.getDomain().handleRequest(request);
            } else {
                this.getDomain().getDefaultTool().handleRequest(request);
            }
        }
    }
}

