/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.command.arguments;

import java.util.Map;
import org.eclipse.core.runtime.Assert;

public class ArrayMapper {
    private Map map;
    private String prefix;
    private int index = -1;

    public ArrayMapper(Map map, String prefix) {
        Assert.isNotNull((Object)map);
        this.map = map;
        this.prefix = prefix;
    }

    public boolean hasNext() {
        return this.index + 1 < this.getSize();
    }

    public void next() {
        ++this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void set(Object value) {
        this.map.put(this.getKey(null), value);
    }

    public void set(String subkey, Object value) {
        this.map.put(this.getKey(subkey), value);
    }

    public Object get() {
        return this.map.get(this.getKey(null));
    }

    public Object get(String subkey) {
        return this.map.get(this.getKey(subkey));
    }

    private String getKey(String subkey) {
        if (this.prefix == null || "".equals(this.prefix)) {
            return subkey == null || "".equals(subkey) ? String.valueOf(this.index) : String.valueOf(String.valueOf(this.index)) + "-" + subkey;
        }
        return subkey == null || "".equals(subkey) ? String.valueOf(this.prefix) + "-" + this.index : String.valueOf(this.prefix) + "-" + this.index + "-" + subkey;
    }

    private String getSizeKey() {
        if (this.prefix == null || "".equals(this.prefix)) {
            return "size";
        }
        return String.valueOf(this.prefix) + "-size";
    }

    public void setSize() {
        this.setSize(this.index + 1);
    }

    public void setSize(int size) {
        this.map.put(this.getSizeKey(), String.valueOf(size));
    }

    public int getSize() {
        Object size = this.map.get(this.getSizeKey());
        if (size == null || !(size instanceof String)) {
            return 0;
        }
        try {
            return Integer.parseInt((String)size, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

