/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.core.style.IStyle;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.internal.styleeditor.StyleEditorPlugin;
import org.xmind.ui.internal.styleeditor.ThemeEditorDialog;
import org.xmind.ui.mindmap.ISheetPart;

public class ThemeEditorDialog2
extends ThemeEditorDialog {
    private static final String SECTION_APPLY = "org.xmind.ui.EditorDialog.apply";
    private IWorkbenchWindow window;
    private Button applyCheckbox;

    public ThemeEditorDialog2(IWorkbenchWindow window, IStyle theme) {
        super(window, theme);
        this.window = window;
    }

    public ThemeEditorDialog2(IWorkbenchWindow window, IStyle theme, Object trigger) {
        super(window, theme, trigger);
        this.window = window;
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings ds = StyleEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = ds.getSection(SECTION_APPLY);
        if (section == null) {
            section = ds.addNewSection(SECTION_APPLY);
        }
        return section;
    }

    protected Viewer createStyleViewer(Composite parent) {
        return null;
    }

    protected IStyle save() {
        IStyle styleSaved = super.save();
        VerifyUI20141031.getUsageDataCollector().increase("EditThemeCount");
        if (this.applyCheckbox != null) {
            boolean isSelected = this.applyCheckbox.getSelection();
            this.getDialogSettings().put(SECTION_APPLY, isSelected);
            if (isSelected) {
                this.applyTheme(styleSaved);
            }
        }
        this.close();
        return styleSaved;
    }

    private void applyTheme(IStyle theme) {
        IWorkbenchPage activePage = this.window.getActivePage();
        if (activePage == null) {
            return;
        }
        IEditorPart editor = activePage.getActiveEditor();
        if (!(editor instanceof IGraphicalEditor)) {
            return;
        }
        IGraphicalEditorPage page = ((IGraphicalEditor)editor).getActivePageInstance();
        if (page == null) {
            return;
        }
        IGraphicalViewer viewer = page.getViewer();
        if (viewer == null) {
            return;
        }
        ISheetPart sheetPart = (ISheetPart)viewer.getAdapter(ISheetPart.class);
        if (sheetPart == null) {
            return;
        }
        EditDomain domain = page.getEditDomain();
        if (domain == null) {
            return;
        }
        domain.handleRequest(new Request("modify_theme").setViewer((IViewer)viewer).setPrimaryTarget((IPart)sheetPart).setParameter("resource", (Object)theme));
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite leftContainer = new Composite(composite, 0);
        leftContainer.setLayout((Layout)new GridLayout());
        leftContainer.setLayoutData((Object)new GridData(1, 4, false, true));
        this.applyCheckbox = new Button(leftContainer, 32);
        this.applyCheckbox.setText(StyleEditorMessages.ThemeEditorDialog_ApplyButton_text);
        this.applyCheckbox.setSelection(this.getDialogSettings().getBoolean(SECTION_APPLY));
        Composite rightContainer = new Composite(composite, 0);
        rightContainer.setLayout((Layout)new GridLayout(0, false));
        rightContainer.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        this.createButton(rightContainer, 0, StyleEditorMessages.ThemeEditorDialog_SaveAs_text, false);
        this.createButton(rightContainer, 12, IDialogConstants.CANCEL_LABEL, false);
        return rightContainer;
    }

    protected void closePressed() {
        this.getDialogSettings().put(SECTION_APPLY, this.applyCheckbox.getSelection());
        super.closePressed();
    }
}

