/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xmind.core.ITextSpan;
import org.xmind.core.internal.dom.HtmlNotesContentImpl;
import org.xmind.core.internal.dom.SpanImplBase;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.util.DOMUtils;

public class TextSpanImpl
extends SpanImplBase
implements ITextSpan {
    private Text text;
    private Element ele;

    public TextSpanImpl(Node implementation, HtmlNotesContentImpl owner) {
        super(implementation, owner);
        if (implementation instanceof Text) {
            this.text = (Text)implementation;
            this.ele = null;
        } else if (implementation instanceof Element) {
            this.text = null;
            this.ele = (Element)implementation;
        }
    }

    public void setStyleId(String styleId) {
        if (styleId == null) {
            if (this.getImplementation() == this.text) {
                return;
            }
            if (this.text == null) {
                this.text = ((WorkbookImpl)this.getOwnedWorkbook()).getImplementation().createTextNode(this.getTextContent());
            }
            WorkbookUtilsImpl.decreaseStyleRef(this.getOwner().getRealizedWorkbook(), this);
            Node oldImpl = this.getImplementation();
            Node p = oldImpl.getParentNode();
            if (p != null) {
                p.replaceChild(oldImpl, this.text);
            }
            this.setImplementation(this.text);
            this.getOwner().updateModifiedTime();
        } else if (this.getImplementation() == this.ele) {
            super.setStyleId(styleId);
        } else {
            Node oldImpl;
            Node p;
            if (this.ele == null) {
                this.ele = ((WorkbookImpl)this.getOwnedWorkbook()).getImplementation().createElement("xhtml:span");
                this.ele.setTextContent(this.getTextContent());
            }
            if ((p = (oldImpl = this.getImplementation()).getParentNode()) != null) {
                p.replaceChild(this.ele, oldImpl);
            }
            this.setImplementation(this.ele);
            DOMUtils.setAttribute(this.ele, "style-id", styleId);
            WorkbookUtilsImpl.increaseStyleRef(this.getOwner().getRealizedWorkbook(), this);
            this.getOwner().updateModifiedTime();
        }
    }

    public String getTextContent() {
        return this.getImplementation().getTextContent();
    }

    public void setTextContent(String textContent) {
        this.getImplementation().setTextContent(textContent);
        this.getOwner().updateModifiedTime();
    }
}

