/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xmind.core.IFileEntry;
import org.xmind.core.internal.AbstractRefCounter;
import org.xmind.core.internal.dom.ManifestImpl;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.style.IStyle;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.IStyleRefCounter;
import org.xmind.core.util.Property;

public class WorkbookStyleRefCounter
extends AbstractRefCounter
implements IStyleRefCounter {
    private StyleSheetImpl sheet;
    private ManifestImpl manifest;
    private Map<String, String> groupCache = new HashMap<String, String>();

    WorkbookStyleRefCounter(StyleSheetImpl sheet, ManifestImpl manifest) {
        this.sheet = sheet;
        this.manifest = manifest;
    }

    protected Object findResource(String resourceId) {
        return this.sheet.findStyle(resourceId);
    }

    protected void postIncreaseRef(String resourceId, Object resource) {
        IStyle style = (IStyle)resource;
        if (this.sheet.equals(style.getOwnedStyleSheet())) {
            String group = this.sheet.findOwnedGroup(style);
            if (group != null) {
                this.groupCache.put(resourceId, group);
            } else {
                String cachedGroup = this.groupCache.get(resourceId);
                if (cachedGroup != null) {
                    this.addStyleToGroup(style, cachedGroup);
                }
            }
            Iterator<Property> defaultStyles = style.defaultStyles();
            while (defaultStyles.hasNext()) {
                Property ds = defaultStyles.next();
                this.increaseRef(ds.value);
            }
            IFileEntry entry = this.manifest.getFileEntry("styles.xml");
            if (entry == null) {
                entry = this.manifest.createFileEntry("styles.xml");
            }
            entry.increaseReference();
            Iterator<Property> it = style.properties();
            while (it.hasNext()) {
                String entryPath;
                Property p = it.next();
                if (!HyperlinkUtils.isAttachmentURL(p.value) || (entry = this.manifest.getFileEntry(entryPath = HyperlinkUtils.toAttachmentPath(p.value))) == null) continue;
                entry.increaseReference();
            }
        }
    }

    private void addStyleToGroup(IStyle style, String groupName) {
        this.sheet.addStyle(style, groupName);
    }

    protected void postDecreaseRef(String resourceId, Object resource) {
        IStyle style = (IStyle)resource;
        if (this.sheet.equals(style.getOwnedStyleSheet())) {
            IFileEntry entry;
            String group = this.sheet.findOwnedGroup(style);
            if (group != null && this.getRefCount(resourceId) <= 0) {
                this.sheet.removeStyle(style);
            }
            Iterator<Property> defaultStyles = style.defaultStyles();
            while (defaultStyles.hasNext()) {
                Property ds = defaultStyles.next();
                this.decreaseRef(ds.value);
            }
            if (this.sheet.isEmpty() && (entry = this.manifest.getFileEntry("styles.xml")) != null) {
                entry.decreaseReference();
            }
            Iterator<Property> it = style.properties();
            while (it.hasNext()) {
                String entryPath;
                IFileEntry entry2;
                Property p = it.next();
                if (!HyperlinkUtils.isAttachmentURL(p.value) || (entry2 = this.manifest.getFileEntry(entryPath = HyperlinkUtils.toAttachmentPath(p.value))) == null) continue;
                entry2.decreaseReference();
            }
        }
    }
}

