/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.xmind.core.CoreException;
import org.xmind.core.IFileEntryFilter;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;

public class FileUtils {
    private static Pattern FileNamePattern = null;

    public static File ensureFileParent(File f) {
        FileUtils.ensureDirectory(f.getParentFile());
        return f;
    }

    public static File ensureDirectory(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static void copy(String src, String dest) throws IOException {
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dest);
        FileUtils.transfer(is, os, true);
    }

    public static void copy(File src, File dest) throws IOException {
        FileInputStream is = new FileInputStream(src);
        FileOutputStream os = new FileOutputStream(dest);
        FileUtils.transfer(is, os, true);
    }

    public static void transfer(IStorage oldStorage, IStorage newStorage) throws IOException, CoreException {
        FileUtils.transfer(oldStorage, newStorage, null);
    }

    public static void transfer(IStorage oldStorage, IStorage newStorage, IFileEntryFilter filter) throws IOException, CoreException {
        IInputSource inSource = oldStorage.getInputSource();
        IOutputTarget outTarget = newStorage.getOutputTarget();
        FileUtils.transfer(inSource, outTarget, filter);
    }

    public static void transfer(IInputSource inputSource, IOutputTarget outputTarget) throws IOException {
        FileUtils.transfer(inputSource, outputTarget, null);
    }

    public static void transfer(IInputSource inputSource, IOutputTarget outputTarget, IFileEntryFilter filter) throws IOException {
        Iterator<String> entries = inputSource.getEntries();
        while (entries.hasNext()) {
            String entryPath = entries.next();
            if (filter != null && !filter.select(entryPath, null, false) || !inputSource.hasEntry(entryPath) || !inputSource.isEntryAvailable(entryPath)) continue;
            InputStream is = inputSource.openEntryStream(entryPath);
            try {
                OutputStream os = outputTarget.openEntryStream(entryPath);
                try {
                    FileUtils.transfer(is, os);
                }
                finally {
                    os.close();
                }
            }
            finally {
                is.close();
            }
        }
    }

    public static void transfer(IInputSource source, String sourcePath, IOutputTarget target, String targetPath) throws IOException {
        InputStream input = source.openEntryStream(sourcePath);
        try {
            OutputStream output = target.openEntryStream(targetPath);
            try {
                FileUtils.transfer(input, output, false);
            }
            finally {
                output.close();
            }
        }
        finally {
            input.close();
        }
    }

    public static void transfer(InputStream is, OutputStream os) throws IOException {
        FileUtils.transfer(is, os, true, null);
    }

    public static void transfer(InputStream is, OutputStream os, boolean closeOnFinish) throws IOException {
        FileUtils.transfer(is, os, closeOnFinish, null);
    }

    public static void transfer(InputStream is, OutputStream os, boolean closeOnFinish, String taskName) throws IOException {
        try {
            int numRead;
            byte[] buffer = new byte[4096];
            while ((numRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, numRead);
            }
        }
        finally {
            if (closeOnFinish) {
                try {
                    is.close();
                }
                finally {
                    os.close();
                }
            }
        }
    }

    public static void transfer(File source, File target) throws IOException {
        FileUtils.ensureFileParent(target);
        FileInputStream in = new FileInputStream(source);
        try {
            FileOutputStream out = new FileOutputStream(target);
            try {
                FileUtils.transfer(in, out, false);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static boolean delete(File f) {
        if (f.isFile()) {
            return f.delete();
        }
        if (f.isDirectory()) {
            boolean b = FileUtils.clearDir(f);
            return b &= f.delete();
        }
        return false;
    }

    public static boolean clearDir(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return true;
        }
        boolean cleared = true;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File sub = fileArray[n2];
            cleared &= FileUtils.delete(sub);
            ++n2;
        }
        return cleared;
    }

    public static String getMediaType(String path) {
        if (path != null) {
            String ext = FileUtils.getExtension(path);
            if (".jpg".equals(ext) || ".jpeg".equals(ext)) {
                return "image/jpeg";
            }
            if (".png".equals(ext)) {
                return "image/png";
            }
            if (".bmp".equals(ext)) {
                return "image/bmp";
            }
            if (".gif".equals(ext)) {
                return "image/gif";
            }
        }
        return "";
    }

    public static String getFileName(String fullPath) {
        Matcher m;
        if (FileNamePattern == null) {
            FileNamePattern = Pattern.compile("([^/\\\\]*)[/|\\\\]?$");
        }
        if ((m = FileNamePattern.matcher(fullPath)).find()) {
            return m.group(1);
        }
        return fullPath;
    }

    public static String getExtension(String fullPath) {
        String fileName = FileUtils.getFileName(fullPath);
        int i = fileName.lastIndexOf(46);
        if (i >= 0) {
            return fileName.substring(i);
        }
        return "";
    }

    public static String getNoExtensionFileName(String fullPath) {
        String fileName = FileUtils.getFileName(fullPath);
        int i = fileName.lastIndexOf(46);
        if (i >= 0) {
            return fileName.substring(0, i);
        }
        return fileName;
    }

    public static void extractZipFile(String filename, IOutputTarget target) throws IOException {
        FileUtils.extractZipFile(filename, target, null);
    }

    public static void extractZipFile(String filename, IOutputTarget target, IFileEntryFilter filter) throws IOException {
        FileInputStream fin = new FileInputStream(filename);
        try {
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(fin));
            try {
                FileUtils.extractZipFile(zin, target, filter);
            }
            finally {
                zin.close();
            }
        }
        finally {
            fin.close();
        }
    }

    public static void extractZipFile(File file, IOutputTarget target) throws IOException {
        FileUtils.extractZipFile(file, target, null);
    }

    public static void extractZipFile(File file, IOutputTarget target, IFileEntryFilter filter) throws IOException {
        FileInputStream fin = new FileInputStream(file);
        try {
            ZipInputStream zin = new ZipInputStream(new BufferedInputStream(fin));
            try {
                FileUtils.extractZipFile(zin, target, filter);
            }
            finally {
                zin.close();
            }
        }
        finally {
            fin.close();
        }
    }

    public static void extractZipFile(ZipInputStream zin, IOutputTarget target) throws IOException {
        FileUtils.extractZipFile(zin, target, null);
    }

    public static void extractZipFile(ZipInputStream zin, IOutputTarget target, IFileEntryFilter filter) throws IOException {
        ZipEntry entry;
        while ((entry = zin.getNextEntry()) != null) {
            String entryPath = entry.getName();
            if (entry.isDirectory() || filter != null && !filter.select(entryPath, null, false) || !target.isEntryAvaialble(entryPath)) continue;
            OutputStream out = target.openEntryStream(entryPath);
            try {
                FileUtils.transfer(zin, out, false);
            }
            catch (Throwable throwable) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void extractZipStream(InputStream stream, IOutputTarget target) throws IOException {
        FileUtils.extractZipStream(stream, target, null);
    }

    public static void extractZipStream(InputStream stream, IOutputTarget target, IFileEntryFilter filter) throws IOException {
        FileUtils.extractZipFile(new ZipInputStream(stream), target, filter);
    }
}

