/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.gallery;

import java.io.File;
import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import net.xmind.verify.ui.internal.e4models.VerifyModelPage;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryChangedListener;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryItem;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.internal.e4models.IContextRunnable;
import org.xmind.ui.internal.e4models.ModelPage;
import org.xmind.ui.internal.gallery.ClipArtResourceManagerViewer;
import org.xmind.ui.internal.gallery.Messages;
import org.xmind.ui.internal.resourcemanager.ResourceManagerDialogPage;
import org.xmind.ui.internal.resourcemanager.ResourceManagerViewer;

public class ClipArtResourceManagerPage
extends ResourceManagerDialogPage
implements IGalleryChangedListener {
    private static final int addGroupButtonID = 1025;
    private ClipArtResourceManagerViewer viewer;

    public ClipArtResourceManagerPage() {
        this.addPreviousPage((ModelPage)new VerifyModelPage(){

            protected String getFeatureKey() {
                return "ClipArtView";
            }

            protected int getRequiredFeatures() {
                return 3;
            }
        });
        GalleryCore.getInstance().addGalleryChangedlistener(this);
        GalleryCore.getInstance().load();
    }

    public ResourceManagerViewer createViewer() {
        this.viewer = new ClipArtResourceManagerViewer();
        return this.viewer;
    }

    protected void createButtonsForButtonBar(Composite buttonBar) {
        this.createButton(buttonBar, 1025, Messages.ClipArtDialog_Button, false).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File dir = new File(GalleryCore.getPath("gallery") + File.separator + Messages.GalleryView_UserClipArt_Text + ' ' + ClipArtResourceManagerPage.this.getNewGroupNo());
                FileUtils.ensureDirectory((File)dir);
                LocalGalleryGroup userGroup = new LocalGalleryGroup(dir, dir.getName());
                List<IGalleryGroup> userGroups = GalleryCore.getInstance().getUserGalleryGroups();
                userGroups.add(userGroup);
                ClipArtResourceManagerPage.this.viewer.refresh();
                ClipArtResourceManagerPage.this.viewer.activateGroup(userGroup);
                ClipArtResourceManagerPage.this.viewer.reveal(userGroup);
                ClipArtResourceManagerPage.this.viewer.renameGalleryGroup();
                VerifyUI20141031.getUsageDataCollector().increase("AddClipArtGroupCount");
            }
        });
    }

    public void galleryGroupChanged() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ClipArtResourceManagerPage.this.viewer != null && ClipArtResourceManagerPage.this.viewer.getControl() != null && !ClipArtResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    ClipArtResourceManagerPage.this.viewer.refresh();
                }
            }
        });
    }

    public void galleryStatusChanged(int oldStatus, int newStatus) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ClipArtResourceManagerPage.this.viewer != null && ClipArtResourceManagerPage.this.viewer.getControl() != null && !ClipArtResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    ClipArtResourceManagerPage.this.viewer.refresh();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        GalleryCore.getInstance().removeGalleryChangedListener(this);
    }

    protected String getContextMenuId() {
        return "org.xmind.ui.dialogPart.resourceManager.clipArt.popupMenu";
    }

    public String getModelPageId() {
        return "org.xmind.ui.dialogPart.resourceManager.clipArt";
    }

    public String getModelPageTitle() {
        return null;
    }

    private int getNewGroupNo() {
        List<IGalleryGroup> userGroups = GalleryCore.getInstance().getUserGalleryGroups();
        int i = 0;
        for (IGalleryGroup group : userGroups) {
            String groupName = group.getName();
            if (!groupName.startsWith(Messages.GalleryView_UserClipArt_Text)) continue;
            try {
                Integer toCompare = Integer.valueOf(groupName.substring(groupName.lastIndexOf(32) + 1));
                if (toCompare <= i) continue;
                i = toCompare;
            }
            catch (Exception exception) {}
        }
        return i + 1;
    }

    protected void registerRunnable(IEclipseContext eclipseContext) {
        super.registerRunnable(eclipseContext);
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.rename", (Object)new IContextRunnable(){

            public void run() {
                ClipArtResourceManagerPage.this.viewer.renameGalleryGroup();
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                if (ClipArtResourceManagerPage.this.viewer != null && ClipArtResourceManagerPage.this.viewer.getControl() != null && !ClipArtResourceManagerPage.this.viewer.getControl().isDisposed()) {
                    return ClipArtResourceManagerPage.this.viewer.isUserGalleryGroup();
                }
                return false;
            }
        });
        eclipseContext.set(String.valueOf(this.getId()) + "/" + "org.xmind.ui.modelPart.delete", (Object)new IContextRunnable(){

            public void run() {
                if (ClipArtResourceManagerPage.this.viewer != null && ClipArtResourceManagerPage.this.viewer.getControl() != null && !ClipArtResourceManagerPage.this.viewer.getControl().isDisposed() && ClipArtResourceManagerPage.this.viewer.isUserGalleryGroup()) {
                    ClipArtResourceManagerPage.this.viewer.deleteGalleryGroup();
                    return;
                }
                ISelection selection = ClipArtResourceManagerPage.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object element : ((IStructuredSelection)selection).toList()) {
                        if (!(element instanceof LocalGalleryItem)) continue;
                        LocalGalleryItem item = (LocalGalleryItem)element;
                        if (item.getFile() != null) {
                            FileUtils.delete((File)item.getFile());
                            continue;
                        }
                        ClipArtResourceManagerPage.this.viewer.refresh();
                    }
                }
                GalleryCore.getInstance().fireGalleryChanged();
            }

            public boolean canExecute(IEclipseContext context, String contextKey) {
                if (ClipArtResourceManagerPage.this.viewer != null && ClipArtResourceManagerPage.this.viewer.getControl() != null && !ClipArtResourceManagerPage.this.viewer.getControl().isDisposed() && ClipArtResourceManagerPage.this.viewer.isUserGalleryGroup()) {
                    return true;
                }
                IStructuredSelection ss = ClipArtResourceManagerPage.this.viewer.getStructuredSelection();
                if (ss.getFirstElement() instanceof LocalGalleryItem) {
                    LocalGalleryItem item = (LocalGalleryItem)ss.getFirstElement();
                    return GalleryCore.getInstance().getUserGalleryGroups().contains(item.getParent());
                }
                return false;
            }
        });
    }
}

