/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.exports.vector;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GEF;
import org.xmind.gef.util.Properties;
import org.xmind.org.freehep.graphics2d.TagString;
import org.xmind.org.freehep.graphicsio.pdf.PDFGraphics2D;
import org.xmind.ui.exports.vector.graphics.GraphicsToGraphics2DAdaptor;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt.exports.vector.GanttFigureRenderer2;
import org.xmind.ui.gantt.exports.vector.Messages;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.exports.vector.pdf.PDFMapConstants;

public class GanttPdfExporter
extends GanttFigureRenderer2 {
    private String targetPath;
    private IDialogSettings settings;
    private Display display;
    private Rectangle pageClientArea;
    private PDFGraphics2D pdfGenerator;
    private OutputStream out;

    public GanttPdfExporter(GanttViewer ganttViewer, String targetPath, IDialogSettings settings, Display display) {
        super(ganttViewer);
        this.targetPath = targetPath;
        this.settings = settings;
        this.display = display;
    }

    public void export() {
        try {
            if (!Util.isLinux()) {
                this.getProperties().set("renderTextAsPath", true);
            }
            this.start();
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(false, false, new IRunnableWithProgress(){

                    public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        GanttPdfExporter.this.display.syncExec(new Runnable(){

                            public void run() {
                                GanttPdfExporter.this.internalExport(monitor);
                            }
                        });
                    }
                });
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (!Util.isLinux()) {
                this.getProperties().set("renderTextAsPath", false);
            }
        }
    }

    private Properties getProperties() {
        if (this.getGanttViewer() != null) {
            return this.getGanttViewer().getProperties();
        }
        return null;
    }

    private void internalExport(IProgressMonitor monitor) {
        int usefulPerPageHeightByRatio;
        int lines;
        int heightByRatio;
        double scale;
        boolean fullWidth;
        GanttViewer ganttViewer = this.getGanttViewer();
        TaskTreeHeaderViewer headerViewer = ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round((int)value, (TaskTreeWidthsSupport)ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int usefulPerPageWidth = this.pageClientArea.width;
        int usefulPerPageHeight = this.pageClientArea.height;
        int widthPages = this.getInt("widthPages", 1);
        int heightPages = this.getInt("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            int heightByRatio2 = (int)((double)usefulPerPageHeight / fillHeightRatio);
            int lines2 = (heightByRatio2 - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines2 = (heightByRatio2 - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines2 : lines2 + 1;
            int usefulPerPageHeightByRatio2 = headerHeight + lines2 * ExportConstants.ITEM_HEIGHT;
            fillHeightRatio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio2;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            scale = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            heightByRatio = (int)((double)usefulPerPageHeight / scale);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            usefulHeightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
            usefulHeightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? usefulHeightPages : usefulHeightPages + 1;
            this.pageClientArea.height = (int)((double)usefulPerPageHeightByRatio * scale);
        } else {
            scale = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            heightByRatio = (int)((double)usefulPerPageHeight / scale);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            scale = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            usefulWidthPages = sourceWidth / (int)((double)usefulPerPageWidth / scale);
            usefulWidthPages = sourceWidth % (int)((double)usefulPerPageWidth / scale) == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / scale);
        monitor.beginTask(Messages.GanttExport_ExportingGantt, widthPages * heightPages);
        int j = 0;
        while (j < heightPages) {
            int y = j * (usefulPerPageHeightByRatio - headerHeight);
            int i = 0;
            while (i < widthPages) {
                int x = i * usefulPerPageWidthByRatio;
                Rectangle contentClip = new Rectangle(0, headerHeight, usefulPerPageWidthByRatio, usefulPerPageHeightByRatio - headerHeight);
                int pageNumber = j * widthPages + i + 1;
                boolean isValidPage = i < usefulWidthPages && j < usefulHeightPages;
                this.render(startTime, endTime, new Point(-x, -y), usefulPerPageWidthByRatio, usefulPerPageHeightByRatio, contentClip, pageNumber, isValidPage);
                monitor.worked(1);
                ++i;
            }
            ++j;
        }
        monitor.done();
        this.pdfGenerator.endExport();
        try {
            this.out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void render(long startTime, long endTime, Point origin, int usefulPerPageWidthByRatio, int usefulPerPageHeightByRatio, Rectangle contentClip, int pageNumber, boolean isValidPage) {
        org.eclipse.swt.graphics.Font systemFont = this.display.getSystemFont();
        Font font = new Font(systemFont.getFontData()[0].getName(), 0, systemFont.getFontData()[0].getHeight());
        this.pdfGenerator.setFooter(font, null, new TagString("- " + pageNumber + " -"), null, -1);
        Rectangle bounds = this.getBorderBounds(this.getGanttViewer(), this.settings, this.pageClientArea);
        GraphicsToGraphics2DAdaptor adaptor = null;
        try {
            try {
                this.pdfGenerator.openPage(new Dimension(bounds.width, bounds.height), "" + pageNumber);
                adaptor = new GraphicsToGraphics2DAdaptor((Graphics2D)this.pdfGenerator, bounds, this.display);
                if (isValidPage) {
                    adaptor.pushState();
                    this.render((Graphics)adaptor, startTime, endTime, origin, contentClip);
                    adaptor.popState();
                }
                adaptor.setLineWidth(1);
                adaptor.setForegroundColor(Display.getCurrent().getSystemColor(15));
                adaptor.drawRectangle(0, 0, bounds.width, bounds.height);
            }
            catch (IOException e) {
                e.printStackTrace();
                adaptor.dispose();
                try {
                    this.pdfGenerator.closePage();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            adaptor.dispose();
            try {
                this.pdfGenerator.closePage();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void start() {
        this.receiveExportInfo();
        this.out = null;
        try {
            this.out = new FileOutputStream(this.targetPath);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        Rectangle bounds = this.pageClientArea;
        this.pdfGenerator = new PDFGraphics2D(this.out, new Dimension(bounds.width, bounds.height));
        this.pdfGenerator.setMultiPage(true);
        String orientation = this.settings.get("Orientation");
        Dimension size = PDFMapConstants.getSize((String)this.settings.get("PageSize"), (String)orientation);
        this.pdfGenerator.setPageSize(size);
        this.pdfGenerator.setMargin(PDFMapConstants.getMargins((String)PDFMapConstants.PageMargins.Small.name(), (String)orientation));
        this.pdfGenerator.setProducer(this.getProducer());
        this.pdfGenerator.startExport();
    }

    private void receiveExportInfo() {
        String orientation = this.settings.get("Orientation");
        Dimension size = PDFMapConstants.getSize((String)this.settings.get("PageSize"), (String)orientation);
        Insets margins = PDFMapConstants.getMargins((String)PDFMapConstants.PageMargins.Small.name(), (String)orientation);
        this.pageClientArea = new Rectangle(margins.left, margins.top, size.width - (margins.left + margins.right), size.height - (margins.top + margins.bottom));
    }

    private String getProducer() {
        String creatorName = "XMind";
        String creatorVersion = System.getProperty("org.xmind.product.buildid");
        if (creatorVersion != null) {
            return String.valueOf(creatorName) + " " + creatorVersion;
        }
        return creatorName;
    }

    private int getInt(String key, int defaultValue) {
        try {
            return this.settings.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private Rectangle getBorderBounds(GanttViewer ganttViewer, IDialogSettings settings, Rectangle pageClientArea) {
        int usefulPerPageHeightByRatio;
        int lines;
        int heightByRatio;
        double ratio;
        boolean fullWidth;
        TaskTreeHeaderViewer headerViewer = ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round((int)value, (TaskTreeWidthsSupport)ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = ganttViewer.getEditDomain().getTimelineModel();
        long startTime = settings.getLong("startTime");
        long endTime = settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int usefulPerPageWidth = pageClientArea.width;
        int usefulPerPageHeight = pageClientArea.height;
        int widthPages = this.getInt("widthPages", 1);
        int heightPages = this.getInt("heightPages", 1);
        boolean isAspectRatio = settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            int heightByRatio2 = (int)((double)usefulPerPageHeight / fillHeightRatio);
            int lines2 = (heightByRatio2 - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines2 = (heightByRatio2 - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines2 : lines2 + 1;
            int usefulPerPageHeightByRatio2 = headerHeight + lines2 * ExportConstants.ITEM_HEIGHT;
            fillHeightRatio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio2;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            ratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            usefulHeightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
            usefulHeightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            ratio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            ratio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            usefulWidthPages = sourceWidth / (int)((double)usefulPerPageWidth / ratio);
            usefulWidthPages = sourceWidth % (int)((double)usefulPerPageWidth / ratio) == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        return new Rectangle(0, 0, usefulPerPageWidthByRatio, usefulPerPageHeightByRatio);
    }
}

