/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal;

import java.net.MalformedURLException;
import java.net.URL;
import javax.annotation.PostConstruct;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class UndoRedoActionToolControl {
    @PostConstruct
    public void createWidget(Composite parent, MToolControl toolControl, MWindow window) {
        int orientation = this.getOrientation((MUIElement)toolControl.getParent());
        int contributionItemMode = toolControl.getTags().contains("FORCE_TEXT") ? ActionContributionItem.MODE_FORCE_TEXT : 0;
        ToolBarManager toolBarManager = new ToolBarManager(orientation | 0x20000 | 0x40 | 0x800000);
        IWorkbenchWindow ww = (IWorkbenchWindow)window.getContext().get(IWorkbenchWindow.class);
        if (ww != null) {
            HandledAction undoAction = new HandledAction((IAction)ActionFactory.UNDO.create(ww));
            undoAction.setImageDescriptor(this.imageDescriptorFor("undo.png"));
            ActionContributionItem undoItem = new ActionContributionItem((IAction)undoAction);
            undoItem.setMode(contributionItemMode);
            toolBarManager.add((IContributionItem)undoItem);
            HandledAction redoAction = new HandledAction((IAction)ActionFactory.REDO.create(ww));
            redoAction.setImageDescriptor(this.imageDescriptorFor("redo.png"));
            ActionContributionItem redoItem = new ActionContributionItem((IAction)redoAction);
            redoItem.setMode(contributionItemMode);
            toolBarManager.add((IContributionItem)redoItem);
        }
        toolBarManager.createControl(parent);
    }

    private ImageDescriptor imageDescriptorFor(String iconName) {
        try {
            return ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/org.xmind.cathy/icons/toolbar/e/" + iconName));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private int getOrientation(MUIElement element) {
        SideValue side;
        MTrimBar trimContainer = this.findTrimBar(element);
        if (trimContainer != null && ((side = trimContainer.getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    private MTrimBar findTrimBar(MUIElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof MTrimBar) {
            return (MTrimBar)element;
        }
        return this.findTrimBar((MUIElement)element.getParent());
    }

    private static class HandledAction
    extends Action
    implements IPropertyChangeListener {
        private IAction handler;

        public HandledAction(IAction handler) {
            super(handler.getText(), handler.getStyle());
            this.handler = handler;
            this.setId(handler.getId());
            this.setEnabled(handler.isEnabled());
            handler.addPropertyChangeListener((IPropertyChangeListener)this);
        }

        public void runWithEvent(Event event) {
            this.handler.runWithEvent(event);
        }

        public void run() {
            this.handler.run();
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("enabled")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setEnabled(bool);
            } else if (event.getProperty().equals("checked")) {
                Boolean bool = (Boolean)event.getNewValue();
                this.setChecked(bool);
            } else if (event.getProperty().equals("toolTipText")) {
                String str = (String)event.getNewValue();
                this.setToolTipText(str);
            }
        }
    }
}

