/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.xmind.core.IAdaptable;
import org.xmind.core.ISheet;
import org.xmind.core.ISheetComponent;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.internal.presentation.AbstractPresentationWindows;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.internal.presentation.slide.PresentationSlide;
import org.xmind.ui.internal.presentation.slide.PresentationSlideModeService;
import org.xmind.ui.internal.presentation.slide.PresentationSlideViewer;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryEditDomain;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMap;

public class PresentationStoryPage
implements IPresentationPage {
    private AbstractPresentationWindows window;
    private IGraphicalEditor editor;
    private IMindMap input;
    private PresentationStory story;
    private MindMapViewer viewer;
    private PresentationSlideModeService slideModeService;
    private Map<ISheet, IGraphicalEditorPage> editorPages = new HashMap<ISheet, IGraphicalEditorPage>();

    public PresentationStoryPage(IGraphicalEditor editor, PresentationStory story) {
        this(editor, story, null, null);
    }

    public PresentationStoryPage(IGraphicalEditor editor, PresentationStory story, AbstractPresentationWindows window, Properties properties) {
        this.editor = editor;
        this.story = story;
        this.window = window;
        this.viewer = new PresentationSlideViewer();
        this.viewer.setProperties(properties);
        this.viewer.getZoomManager().setConstraints(0.1, 3.0);
        this.init();
    }

    private void init() {
        ISheet firstSlideOwnedSheet;
        IAdaptable a;
        PresentationSlideModeService slideModeService = this.story.getSlidesSize() > 0 ? new PresentationSlideModeService((IGraphicalViewer)this.viewer, this.story.getSlides().get(0)) : new PresentationSlideModeService((IGraphicalViewer)this.viewer);
        if (this.window != null) {
            slideModeService.showFirstSlideOnce(true);
        }
        slideModeService.setCentered(true);
        slideModeService.setZoomed(true);
        slideModeService.setAnimationEnabled(true);
        slideModeService.setDuration(400);
        this.viewer.installService(IRevealService.class, (IViewerService)slideModeService);
        slideModeService.setActive(true);
        this.slideModeService = slideModeService;
        this.viewer.setEditDomain((EditDomain)new PresentationStoryEditDomain());
        if (!this.story.getSlides().isEmpty() && (a = this.story.getSlides().get(0).getParent()) instanceof ISheetComponent && (firstSlideOwnedSheet = ((ISheetComponent)a).getOwnedSheet()) != null) {
            IGraphicalEditor ge = this.editor;
            IGraphicalEditorPage[] iGraphicalEditorPageArray = ge.getPages();
            int n = iGraphicalEditorPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGraphicalEditorPage p = iGraphicalEditorPageArray[n2];
                IMindMap mindMap = this.findMindMap(p);
                this.editorPages.put(mindMap.getSheet(), p);
                if (firstSlideOwnedSheet.equals(mindMap.getSheet())) {
                    this.input = this.standardizeMindMap(mindMap);
                }
                ++n2;
            }
            if (this.input == null) {
                throw new IllegalArgumentException();
            }
        }
    }

    private IMindMap findMindMap(IGraphicalEditorPage sourcePage) {
        Object o;
        Object input = sourcePage.getInput();
        if (input instanceof IMindMap) {
            return (IMindMap)input;
        }
        if (input instanceof IAdaptable && (o = ((IAdaptable)input).getAdapter(IMindMap.class)) instanceof IMindMap) {
            return (IMindMap)o;
        }
        return (IMindMap)sourcePage.getAdapter(IMindMap.class);
    }

    private IMindMap standardizeMindMap(IMindMap mindMap) {
        if (mindMap == null || mindMap.getCentralTopic() == null || mindMap.getSheet() == null || mindMap.getCentralTopic() == mindMap.getSheet().getRootTopic()) {
            return mindMap;
        }
        return new MindMap(mindMap.getSheet());
    }

    public void createControl(Composite parent) {
        this.viewer.createControl(parent);
        FigureCanvas canvas = this.viewer.getCanvas();
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        canvas.getHorizontalBar().setEnabled(false);
        canvas.getVerticalBar().setEnabled(false);
        if (this.window != null) {
            canvas.addTraverseListener(new TraverseListener(){

                public void keyTraversed(TraverseEvent e) {
                    if (e.detail == 2) {
                        e.doit = PresentationStoryPage.this.window.canHandleShellCloseEvent();
                    }
                }
            });
        }
        this.viewer.setInput((Object)this.input);
    }

    public Control getControl() {
        return this.viewer.getControl();
    }

    public IGraphicalViewer getViewer() {
        return this.viewer;
    }

    public void showSlide(PresentationSlide slide) {
        this.switchInput(slide);
        this.slideModeService.showSlide(slide);
    }

    private void switchInput(PresentationSlide slide) {
        IAdaptable a = slide.getParent();
        if (!(a instanceof ISheetComponent)) {
            throw new IllegalArgumentException();
        }
        ISheet ownedSheet = ((ISheetComponent)a).getOwnedSheet();
        if (this.input != null && ownedSheet.equals(this.input.getSheet())) {
            return;
        }
        IGraphicalEditorPage editorPage = this.editorPages.get(ownedSheet);
        if (editorPage == null) {
            IGraphicalEditor ge = this.editor;
            IGraphicalEditorPage[] iGraphicalEditorPageArray = ge.getPages();
            int n = iGraphicalEditorPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGraphicalEditorPage p = iGraphicalEditorPageArray[n2];
                if (!this.editorPages.containsValue(p)) {
                    IMindMap mindMap = this.findMindMap(p);
                    this.editorPages.put(mindMap.getSheet(), p);
                    if (ownedSheet.equals(mindMap.getSheet())) {
                        editorPage = p;
                    }
                }
                ++n2;
            }
            if (editorPage == null) {
                return;
            }
        }
        this.input = this.findMindMap(editorPage);
        this.viewer.setInput((Object)this.input);
    }

    public IMindMap getInput() {
        return this.input;
    }

    public void dispose() {
        if (this.viewer != null) {
            this.viewer.uninstallService(IRevealService.class);
            this.viewer = null;
        }
    }
}

