/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.presentation.AbstractPresentationWindows;
import org.xmind.ui.internal.presentation.IPresentationPage;
import org.xmind.ui.internal.presentation.slide.ControlWrapper;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryPage;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.viewers.SWTUtils;

public class PresentationStoryWindow
extends AbstractPresentationWindows {
    private PresentationStory story;
    private IContextActivation presentationContextActivation;
    private ControlWrapper controlWrapper;

    public PresentationStoryWindow(Shell parentShell, PresentationStory story) {
        super(parentShell);
        this.story = story;
        this.initProperties();
        IContextService service = (IContextService)PlatformUI.getWorkbench().getService(IContextService.class);
        this.presentationContextActivation = service.activateContext("org.xmind.ui.context.presentation.story.edit");
    }

    private void initProperties() {
        Properties prop = this.getProperties();
        prop.set("scrollSmooth", (Object)Boolean.TRUE);
        prop.set("ignoreScrollEvent", (Object)Boolean.TRUE);
        prop.set("centered", (Object)Boolean.TRUE);
        prop.set("cornered", (Object)Boolean.TRUE);
        prop.set("gradient", (Object)Boolean.TRUE);
        prop.set("margin", (Object)500);
    }

    protected Control createContents(Composite parent) {
        Composite contents = (Composite)super.createContents(parent);
        this.createControlWrapper(contents);
        return contents;
    }

    private void createControlWrapper(Composite parent) {
        this.controlWrapper = new ControlWrapper(this, this.story);
        this.controlWrapper.createControl(parent);
    }

    protected Layout getContentLayout() {
        return new ContentsLayout();
    }

    protected IPresentationPage createPage(IMindMap mindmap) {
        return new PresentationStoryPage(this.getSourceEditor(), this.story, this, this.getProperties());
    }

    protected void deactivateContext() {
        if (this.presentationContextActivation != null) {
            ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).deactivateContext(this.presentationContextActivation);
        }
    }

    public void handleEvent(Event event) {
        if (this.controlWrapper == null) {
            return;
        }
        if (event.type == 1 && (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000002) || SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000004))) {
            this.controlWrapper.nextPage();
        } else if (event.type == 1 && (SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000001) || SWTUtils.matchKey((int)event.stateMask, (int)event.keyCode, (int)0, (int)0x1000003))) {
            this.controlWrapper.prevPage();
        }
    }

    private class ContentsLayout
    extends Layout {
        private ContentsLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            int maxWidth = 0;
            int maxHeight = 0;
            Point size = PresentationStoryWindow.this.getPageContainer().computeSize(wHint, hHint, flushCache);
            maxWidth = Math.max(size.x, maxWidth);
            maxHeight = Math.max(size.y, maxHeight);
            int width = maxWidth;
            int height = maxHeight;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            PresentationStoryWindow.this.getPageContainer().setBounds(area);
            Control control = PresentationStoryWindow.this.controlWrapper.getControl();
            Point size = control.computeSize(-1, -1);
            control.setBounds(area.x + area.width - size.x - 20, 20, size.x, size.y);
        }
    }
}

