/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.evernote;

import com.evernote.auth.EvernoteAuth;
import com.evernote.auth.EvernoteService;
import com.evernote.clients.ClientFactory;
import com.evernote.clients.NoteStoreClient;
import com.evernote.clients.UserStoreClient;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.thrift.TException;
import com.evernote.thrift.transport.TTransportException;
import org.eclipse.core.runtime.Assert;
import org.xmind.ui.evernote.signin.IEvernoteAccount;

public class EvernoteStore {
    private ClientFactory clientFactory;
    private NoteStoreClient noteStore;
    private UserStoreClient userStore;
    private EvernoteService evernoteService;
    private IEvernoteAccount account;

    public EvernoteStore(IEvernoteAccount account) {
        this.account = account;
        Assert.isNotNull((Object)account);
        this.clientFactory = new ClientFactory(new EvernoteAuth(this.getEvernoteService(), account.getAuthToken()));
    }

    public NoteStoreClient getNoteStore() throws EDAMUserException, EDAMSystemException, TException {
        if (this.noteStore == null) {
            this.noteStore = this.clientFactory.createNoteStoreClient();
        }
        return this.noteStore;
    }

    public UserStoreClient getUserStore() throws TTransportException {
        if (this.userStore == null) {
            this.userStore = this.clientFactory.createUserStoreClient();
        }
        return this.userStore;
    }

    public EvernoteService getEvernoteService() {
        if (this.evernoteService == null) {
            this.evernoteService = EvernoteService.YINXIANG.name().equals(this.account.getServiceType()) ? EvernoteService.YINXIANG : EvernoteService.PRODUCTION;
        }
        return this.evernoteService;
    }
}

