/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote.signin;

import com.evernote.auth.EvernoteAuth;
import com.evernote.auth.EvernoteService;
import com.evernote.clients.ClientFactory;
import com.evernote.edam.type.User;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.xmind.ui.evernote.EvernotePlugin;
import org.xmind.ui.internal.evernote.EvernoteMessages;
import org.xmind.ui.internal.evernote.signin.SignInDialog;

public class SignInJob
extends Job {
    private static final String PREF_BROWSER_CREATE_TIMESTAMP = "CreateBrowserTimestamp";
    private Properties data;
    private SignInDialog dialog;

    public SignInJob() {
        super("Sign In to Evernote.com");
    }

    protected IStatus run(final IProgressMonitor monitor) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return new Status(4, "org.xmind.ui.evernote", "No workbench is running.");
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return new Status(4, "org.xmind.ui.evernote", "No workbench is available.");
        }
        final Display display = workbench.getDisplay();
        if (display == null || display.isDisposed()) {
            return new Status(4, "org.xmind.ui.evernote", "No display is available.");
        }
        this.dialog = null;
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Properties prop;
                Shell shell;
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                Shell shell2 = shell = window == null ? display.getActiveShell() : window.getShell();
                if (shell != null) {
                    shell.setActive();
                }
                if ((prop = SignInJob.this.loadLocalData()) != null && !MessageDialog.openConfirm((Shell)shell, (String)EvernoteMessages.EvernoteExportDialog_title, (String)EvernoteMessages.EvernoteSignInDialog_BrowserCrash_label)) {
                    return;
                }
                SignInJob.this.writeBrowserCreateTimestamp();
                SignInJob.this.dialog = new SignInDialog(shell);
                int code = SignInJob.this.dialog.open();
                if (monitor.isCanceled()) {
                    return;
                }
                if (code == 0) {
                    SignInJob.this.data = SignInJob.this.dialog.getData();
                } else {
                    int returnCode = SignInJob.this.dialog.getCode();
                    if (returnCode == 0) {
                        SignInJob.this.data = SignInJob.this.dialog.getData();
                    } else {
                        SignInJob.this.data = new Properties();
                    }
                }
            }
        });
        while (this.data == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
            if (this.dialog == null || this.dialog.getReturnCode() != 1) continue;
            this.clearBrowserCreateTimestamp();
            return Status.CANCEL_STATUS;
        }
        this.loadUsername();
        this.clearBrowserCreateTimestamp();
        return Status.OK_STATUS;
    }

    public Properties getData() {
        return this.data;
    }

    private void loadUsername() {
        ClientFactory factory = this.createEvernoteFactory();
        if (factory == null) {
            return;
        }
        User user = this.getEvernoteUser(factory);
        if (user == null) {
            return;
        }
        this.data.put("username", user.getUsername());
    }

    private ClientFactory createEvernoteFactory() {
        String token = this.data.getProperty("token");
        EvernoteService evernoteService = this.getEvernoteService();
        if (token == null || evernoteService == null) {
            return null;
        }
        return new ClientFactory(new EvernoteAuth(this.getEvernoteService(), token));
    }

    private EvernoteService getEvernoteService() {
        String serviceType = this.data.getProperty("serviceType");
        if (EvernoteService.YINXIANG.name().equals(serviceType)) {
            return EvernoteService.YINXIANG;
        }
        if (EvernoteService.PRODUCTION.name().equals(serviceType)) {
            return EvernoteService.PRODUCTION;
        }
        return null;
    }

    private User getEvernoteUser(ClientFactory factory) {
        try {
            return factory.createUserStoreClient().getUser();
        }
        catch (Exception e) {
            EvernotePlugin.log("Failed to get the evernote user when sign in.", e);
            return null;
        }
    }

    private void clearBrowserCreateTimestamp() {
        File stateFile = this.getBrowserFatalFile();
        if (stateFile == null) {
            return;
        }
        stateFile.delete();
    }

    private void writeBrowserCreateTimestamp() {
        File stateFile = this.getBrowserFatalFile();
        if (stateFile == null) {
            return;
        }
        Properties store = new Properties();
        SignInJob.saveState(store, PREF_BROWSER_CREATE_TIMESTAMP, String.valueOf(System.currentTimeMillis()));
        try {
            FileOutputStream stream = new FileOutputStream(stateFile);
            try {
                store.store(stream, "Awakening Gatha, Deena Metzger");
            }
            finally {
                stream.close();
            }
        }
        catch (IOException iOException) {}
    }

    private Properties loadLocalData() {
        File stateFile = this.getBrowserFatalFile();
        if (stateFile != null && stateFile.exists() && stateFile.isFile()) {
            Properties store = new Properties();
            try {
                BufferedInputStream stream = new BufferedInputStream(new FileInputStream(stateFile), 1024);
                try {
                    store.load(stream);
                }
                finally {
                    ((InputStream)stream).close();
                }
                return store;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static void saveState(Properties store, String name, String value) {
        if (value != null && !"".equals(value)) {
            store.setProperty(name, value);
        } else {
            store.remove(name);
        }
    }

    private File getBrowserFatalFile() {
        Bundle bundle = Platform.getBundle((String)"org.xmind.ui.evernote");
        if (bundle != null) {
            File root = Platform.getStateLocation((Bundle)bundle).toFile();
            return new File(root, ".BrowserFatal");
        }
        return null;
    }
}

