/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IIdentifiable;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableProvider;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.IPropertiesProvider;
import org.xmind.ui.internal.taskinfo.AssigneeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssigneeSheet
implements INodeAdaptableFactory,
IAdaptable,
IPropertiesProvider {
    private Document implementation;
    private ICoreEventSupport coreEventSupport;
    private ElementRegistry registry = null;
    private NodeAdaptableProvider provider = null;
    private AssigneeSheet parent = null;
    private Properties properties = null;

    public AssigneeSheet(Document implementation) {
        this.implementation = implementation;
        this.init();
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement((Node)this.implementation, (String)"assignee-sheet");
        NS.setNS((NS)NS.Assignee, (Element)m, (NS[])new NS[0]);
        InternalDOMUtils.addVersion((Document)this.implementation);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    public Element getSheetElement() {
        return this.implementation.getDocumentElement();
    }

    public AssigneeSheet getParent() {
        return this.parent;
    }

    public void setParent(AssigneeSheet parent) {
        this.parent = parent;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ICoreEventSource.class) {
            return this;
        }
        if (adapter == ICoreEventSupport.class) {
            return this.getCoreEventSupport();
        }
        if (adapter == Properties.class) {
            return this.getProperties();
        }
        if (adapter == IPropertiesProvider.class) {
            return this;
        }
        if (adapter == ElementRegistry.class) {
            return this.getElementRegistry();
        }
        if (adapter == INodeAdaptableFactory.class) {
            return this;
        }
        if (adapter == INodeAdaptableProvider.class) {
            return this.getElementAdapterProvider();
        }
        if (adapter == Document.class || adapter == Node.class) {
            return this.implementation;
        }
        return null;
    }

    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport != null) {
            return this.coreEventSupport;
        }
        this.coreEventSupport = new CoreEventSupport();
        return this.coreEventSupport;
    }

    public AssigneeItem createAssignee() {
        Element element = this.implementation.createElement("assignee");
        element.setAttribute("singleton", Boolean.toString(true));
        AssigneeItem item = new AssigneeItem(element, this);
        this.getElementRegistry().register((IIdentifiable)item);
        return item;
    }

    public AssigneeItem getAssignee(String assigneeId) {
        Object element = this.getElementById(assigneeId);
        if (element != null && element instanceof AssigneeItem) {
            return (AssigneeItem)element;
        }
        return null;
    }

    public TreeSet<AssigneeItem> getAssignees() {
        TreeSet<AssigneeItem> treeSet = new TreeSet<AssigneeItem>();
        List childList = DOMUtils.getChildList((Element)this.getSheetElement(), (String)"assignee", (INodeAdaptableProvider)this.getElementAdapterProvider());
        treeSet.addAll(childList);
        return treeSet;
    }

    public void addAssigneeItem(AssigneeItem item) {
        Element g = item.getImplementation();
        Element s = this.getSheetElement();
        s.appendChild(g);
    }

    public void removeAssigneeItem(AssigneeItem item) {
        int index;
        Element g = item.getImplementation();
        Element s = this.getSheetElement();
        if (g.getParentNode() == s && (index = DOMUtils.getElementIndex((Node)s, (String)"assignee", (Element)g)) >= 0) {
            s.removeChild(g);
        }
    }

    public AssigneeItem findAssignee(String itemId) {
        AssigneeItem item = this.getAssignee(itemId);
        if (item != null) {
            return item;
        }
        if (this.parent != null) {
            return this.parent.findAssignee(itemId);
        }
        return null;
    }

    public boolean isEmpty() {
        return !this.getSheetElement().hasChildNodes();
    }

    public Object getElementById(String id) {
        Element elementById;
        Object element = this.getElementRegistry().getElement((Object)id);
        if (element == null && (elementById = this.implementation.getElementById(id)) != null) {
            element = this.getElementAdapter(elementById);
        }
        return element;
    }

    public NodeAdaptableProvider getElementAdapterProvider() {
        if (this.provider == null) {
            this.provider = new NodeAdaptableProvider(this.getElementRegistry(), (INodeAdaptableFactory)this, this.implementation);
        }
        return this.provider;
    }

    public IAdaptable getElementAdapter(Node node) {
        return this.getElementAdapterProvider().getAdaptable(node);
    }

    public ElementRegistry getElementRegistry() {
        if (this.registry == null) {
            this.registry = new ElementRegistry();
        }
        return this.registry;
    }

    public IAdaptable createAdaptable(Node node) {
        Element e;
        String tagName;
        if (node instanceof Element && "assignee".equals(tagName = (e = (Element)node).getTagName())) {
            return new AssigneeItem(e, this);
        }
        return null;
    }

    public void save(OutputStream output) throws IOException, CoreException {
        DOMUtils.save((Node)this.implementation, (OutputStream)output, (boolean)false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof AssigneeSheet)) {
            return false;
        }
        return this.implementation == ((AssigneeSheet)obj).implementation;
    }

    public String toString() {
        return DOMUtils.toString((Node)this.implementation);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

