/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal.device;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.xmind.core.audio.IAudioChannel;
import org.xmind.core.audio.IAudioSource;
import org.xmind.core.audio.IAudioTarget;
import org.xmind.core.audio.device.AudioDeviceBase;
import org.xmind.core.audio.internal.device.RawDataChannel;

public class RawDataRecorder
extends AudioDeviceBase {
    public static boolean DEBUG = false;
    protected static final int[] PRESET_SAMPLE_RATES = new int[]{8000, 11025, 12000, 16000, 22050, 32000, 44100, 48000, 64000, 96000};
    protected static final int STANDARD_SAMPLE_RATE = 44100;
    public static final int BITS_PER_SAMPLE = 16;
    public static boolean MONO = true;
    private static int[] availableSampleRates = null;
    private static AudioFormat format = null;
    private static boolean availabilityChecked = false;
    private RawDataChannel runningChannel = null;

    protected RawDataChannel getRunningChannel() {
        return this.runningChannel;
    }

    public boolean isAvailable() {
        return super.isAvailable() && RawDataRecorder.isDeviceAvailable() && !this.isChannelRunning();
    }

    public boolean isRunning() {
        return RawDataRecorder.isDeviceAvailable() && this.isChannelRunning();
    }

    private boolean isChannelRunning() {
        return this.runningChannel != null && this.runningChannel.isRunning();
    }

    public IAudioChannel openChannel(IAudioSource source, IAudioTarget target) throws Exception {
        if (!this.isAvailable() || this.isRunning()) {
            throw new IllegalStateException("recorder not available");
        }
        if (target == null) {
            throw new IllegalArgumentException("audio target is null");
        }
        OutputStream output = target.openOutputStream();
        if (output == null) {
            throw new IllegalArgumentException("audio target can't open an output stream");
        }
        if (DEBUG) {
            System.out.println("Try obtain a target data line from Java AudioSystem");
        }
        TargetDataLine line = AudioSystem.getTargetDataLine(RawDataRecorder.getFormat());
        if (DEBUG) {
            System.out.println("Target data line obtained");
        }
        if (DEBUG) {
            System.out.println("Try open the data line");
        }
        try {
            line.open(RawDataRecorder.getFormat());
        }
        catch (LineUnavailableException e) {
            line.close();
            throw e;
        }
        if (DEBUG) {
            System.out.println("Try create a RawDataChannel");
        }
        RawDataChannel channel = this.createChannel(source, target, output, line);
        if (DEBUG) {
            System.out.println("Open the channel");
        }
        this.runningChannel = null;
        channel.open();
        this.runningChannel = channel;
        return this.runningChannel;
    }

    protected RawDataChannel createChannel(IAudioSource source, IAudioTarget target, OutputStream output, TargetDataLine line) throws IOException {
        return new RawDataChannel(this, source, target, line, new BufferedOutputStream(output));
    }

    void channelClosed(RawDataChannel channel) {
        if (channel == this.runningChannel) {
            this.runningChannel = null;
        }
    }

    public void dispose() {
        if (this.runningChannel != null) {
            this.runningChannel.dispose();
            this.runningChannel = null;
        }
        super.dispose();
    }

    protected static boolean isDeviceAvailable() {
        return RawDataRecorder.getFormat() != null;
    }

    public static AudioFormat getFormat() {
        if (format == null && !availabilityChecked) {
            format = RawDataRecorder.makeAudioFormat(44100);
            availabilityChecked = true;
        }
        return format;
    }

    protected static int[] getAvailableSampleRates() {
        if (availableSampleRates == null && !availabilityChecked) {
            RawDataRecorder.findAvailableSampleRates();
            availabilityChecked = true;
        }
        return availableSampleRates;
    }

    private static void findAvailableSampleRates() {
        int lowestIndex = RawDataRecorder.findLowestAvailableSampleRateIndex();
        if (lowestIndex < 0) {
            return;
        }
        int standardIndex = RawDataRecorder.findStandardSampleRateIndex();
        int mediumIndex = Math.min(Math.max((lowestIndex + standardIndex) / 2, lowestIndex + 1), PRESET_SAMPLE_RATES.length - 1);
        int highestIndex = Math.min(mediumIndex < standardIndex ? standardIndex : mediumIndex + 1, PRESET_SAMPLE_RATES.length - 1);
        availableSampleRates = new int[]{PRESET_SAMPLE_RATES[lowestIndex], PRESET_SAMPLE_RATES[mediumIndex], PRESET_SAMPLE_RATES[highestIndex]};
    }

    private static int findLowestAvailableSampleRateIndex() {
        int i = 0;
        while (i < PRESET_SAMPLE_RATES.length) {
            int sr = PRESET_SAMPLE_RATES[i];
            DataLine.Info info = RawDataRecorder.makeLineInfo(RawDataRecorder.makeAudioFormat(sr));
            if (AudioSystem.isLineSupported(info)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int findStandardSampleRateIndex() {
        int i = 0;
        while (i < PRESET_SAMPLE_RATES.length) {
            if (PRESET_SAMPLE_RATES[i] == 44100) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected static DataLine.Info makeLineInfo(AudioFormat format) {
        return new DataLine.Info(TargetDataLine.class, format);
    }

    protected static AudioFormat makeAudioFormat(int sampleRate) {
        return new AudioFormat(sampleRate, 16, MONO ? 1 : 2, true, true);
    }
}

