/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.clients;

import com.evernote.clients.LinkedNoteStoreClient;
import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BusinessNoteStoreClient
extends LinkedNoteStoreClient {
    BusinessNoteStoreClient(NoteStoreClient mainNoteStoreClient, NoteStoreClient linkedNoteStoreClient, AuthenticationResult authenticationResult) {
        super(mainNoteStoreClient, linkedNoteStoreClient, authenticationResult);
    }

    public LinkedNotebook createNotebook(Notebook notebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        Notebook originalNotebook = this.getClient().createNotebook(notebook);
        SharedNotebook sharedNotebook = originalNotebook.getSharedNotebooks().get(0);
        LinkedNotebook linkedNotebook = new LinkedNotebook();
        linkedNotebook.setShareKey(sharedNotebook.getShareKey());
        linkedNotebook.setShareName(originalNotebook.getName());
        linkedNotebook.setUsername(this.getAuthenticationResult().getUser().getUsername());
        linkedNotebook.setShardId(this.getAuthenticationResult().getUser().getShardId());
        return this.getPersonalClient().createLinkedNotebook(linkedNotebook);
    }

    @Override
    public List<LinkedNotebook> listNotebooks() throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        ArrayList<LinkedNotebook> linkedNotebooks = new ArrayList<LinkedNotebook>();
        for (LinkedNotebook notebook : super.listNotebooks()) {
            if (!notebook.isSetBusinessId()) continue;
            linkedNotebooks.add(notebook);
        }
        return linkedNotebooks;
    }
}

