/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.edam.userstore;

import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.PremiumInfo;
import com.evernote.edam.type.User;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.edam.userstore.BootstrapInfo;
import com.evernote.edam.userstore.PublicUserInfo;
import com.evernote.edam.userstore.UserStoreIface;
import com.evernote.thrift.TApplicationException;
import com.evernote.thrift.TBase;
import com.evernote.thrift.TBaseHelper;
import com.evernote.thrift.TException;
import com.evernote.thrift.TServiceClient;
import com.evernote.thrift.protocol.TField;
import com.evernote.thrift.protocol.TMessage;
import com.evernote.thrift.protocol.TProtocol;
import com.evernote.thrift.protocol.TProtocolUtil;
import com.evernote.thrift.protocol.TStruct;
import java.io.Serializable;

public class UserStore {

    public static class Client
    implements TServiceClient,
    Iface {
        protected TProtocol iprot_;
        protected TProtocol oprot_;
        protected int seqid_;

        public Client(TProtocol prot) {
            this(prot, prot);
        }

        public Client(TProtocol iprot, TProtocol oprot) {
            this.iprot_ = iprot;
            this.oprot_ = oprot;
        }

        public TProtocol getInputProtocol() {
            return this.iprot_;
        }

        public TProtocol getOutputProtocol() {
            return this.oprot_;
        }

        public boolean checkVersion(String clientName, short edamVersionMajor, short edamVersionMinor) throws TException {
            this.send_checkVersion(clientName, edamVersionMajor, edamVersionMinor);
            return this.recv_checkVersion();
        }

        public void send_checkVersion(String clientName, short edamVersionMajor, short edamVersionMinor) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("checkVersion", 1, ++this.seqid_));
            checkVersion_args args = new checkVersion_args();
            args.setClientName(clientName);
            args.setEdamVersionMajor(edamVersionMajor);
            args.setEdamVersionMinor(edamVersionMinor);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public boolean recv_checkVersion() throws TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "checkVersion failed: out of sequence response");
            }
            checkVersion_result result = new checkVersion_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            throw new TApplicationException(5, "checkVersion failed: unknown result");
        }

        public BootstrapInfo getBootstrapInfo(String locale) throws TException {
            this.send_getBootstrapInfo(locale);
            return this.recv_getBootstrapInfo();
        }

        public void send_getBootstrapInfo(String locale) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getBootstrapInfo", 1, ++this.seqid_));
            getBootstrapInfo_args args = new getBootstrapInfo_args();
            args.setLocale(locale);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public BootstrapInfo recv_getBootstrapInfo() throws TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getBootstrapInfo failed: out of sequence response");
            }
            getBootstrapInfo_result result = new getBootstrapInfo_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            throw new TApplicationException(5, "getBootstrapInfo failed: unknown result");
        }

        public AuthenticationResult authenticate(String username, String password, String consumerKey, String consumerSecret, boolean supportsTwoFactor) throws EDAMUserException, EDAMSystemException, TException {
            this.send_authenticate(username, password, consumerKey, consumerSecret, supportsTwoFactor);
            return this.recv_authenticate();
        }

        public void send_authenticate(String username, String password, String consumerKey, String consumerSecret, boolean supportsTwoFactor) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("authenticate", 1, ++this.seqid_));
            authenticate_args args = new authenticate_args();
            args.setUsername(username);
            args.setPassword(password);
            args.setConsumerKey(consumerKey);
            args.setConsumerSecret(consumerSecret);
            args.setSupportsTwoFactor(supportsTwoFactor);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_authenticate() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "authenticate failed: out of sequence response");
            }
            authenticate_result result = new authenticate_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "authenticate failed: unknown result");
        }

        public AuthenticationResult authenticateLongSession(String username, String password, String consumerKey, String consumerSecret, String deviceIdentifier, String deviceDescription, boolean supportsTwoFactor) throws EDAMUserException, EDAMSystemException, TException {
            this.send_authenticateLongSession(username, password, consumerKey, consumerSecret, deviceIdentifier, deviceDescription, supportsTwoFactor);
            return this.recv_authenticateLongSession();
        }

        public void send_authenticateLongSession(String username, String password, String consumerKey, String consumerSecret, String deviceIdentifier, String deviceDescription, boolean supportsTwoFactor) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("authenticateLongSession", 1, ++this.seqid_));
            authenticateLongSession_args args = new authenticateLongSession_args();
            args.setUsername(username);
            args.setPassword(password);
            args.setConsumerKey(consumerKey);
            args.setConsumerSecret(consumerSecret);
            args.setDeviceIdentifier(deviceIdentifier);
            args.setDeviceDescription(deviceDescription);
            args.setSupportsTwoFactor(supportsTwoFactor);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_authenticateLongSession() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "authenticateLongSession failed: out of sequence response");
            }
            authenticateLongSession_result result = new authenticateLongSession_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "authenticateLongSession failed: unknown result");
        }

        public AuthenticationResult completeTwoFactorAuthentication(String authenticationToken, String oneTimeCode, String deviceIdentifier, String deviceDescription) throws EDAMUserException, EDAMSystemException, TException {
            this.send_completeTwoFactorAuthentication(authenticationToken, oneTimeCode, deviceIdentifier, deviceDescription);
            return this.recv_completeTwoFactorAuthentication();
        }

        public void send_completeTwoFactorAuthentication(String authenticationToken, String oneTimeCode, String deviceIdentifier, String deviceDescription) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("completeTwoFactorAuthentication", 1, ++this.seqid_));
            completeTwoFactorAuthentication_args args = new completeTwoFactorAuthentication_args();
            args.setAuthenticationToken(authenticationToken);
            args.setOneTimeCode(oneTimeCode);
            args.setDeviceIdentifier(deviceIdentifier);
            args.setDeviceDescription(deviceDescription);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_completeTwoFactorAuthentication() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "completeTwoFactorAuthentication failed: out of sequence response");
            }
            completeTwoFactorAuthentication_result result = new completeTwoFactorAuthentication_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "completeTwoFactorAuthentication failed: unknown result");
        }

        public void revokeLongSession(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_revokeLongSession(authenticationToken);
            this.recv_revokeLongSession();
        }

        public void send_revokeLongSession(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("revokeLongSession", 1, ++this.seqid_));
            revokeLongSession_args args = new revokeLongSession_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public void recv_revokeLongSession() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "revokeLongSession failed: out of sequence response");
            }
            revokeLongSession_result result = new revokeLongSession_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
        }

        public AuthenticationResult authenticateToBusiness(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_authenticateToBusiness(authenticationToken);
            return this.recv_authenticateToBusiness();
        }

        public void send_authenticateToBusiness(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("authenticateToBusiness", 1, ++this.seqid_));
            authenticateToBusiness_args args = new authenticateToBusiness_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_authenticateToBusiness() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "authenticateToBusiness failed: out of sequence response");
            }
            authenticateToBusiness_result result = new authenticateToBusiness_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "authenticateToBusiness failed: unknown result");
        }

        public AuthenticationResult refreshAuthentication(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_refreshAuthentication(authenticationToken);
            return this.recv_refreshAuthentication();
        }

        public void send_refreshAuthentication(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("refreshAuthentication", 1, ++this.seqid_));
            refreshAuthentication_args args = new refreshAuthentication_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public AuthenticationResult recv_refreshAuthentication() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "refreshAuthentication failed: out of sequence response");
            }
            refreshAuthentication_result result = new refreshAuthentication_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "refreshAuthentication failed: unknown result");
        }

        public User getUser(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getUser(authenticationToken);
            return this.recv_getUser();
        }

        public void send_getUser(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getUser", 1, ++this.seqid_));
            getUser_args args = new getUser_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public User recv_getUser() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getUser failed: out of sequence response");
            }
            getUser_result result = new getUser_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getUser failed: unknown result");
        }

        public PublicUserInfo getPublicUserInfo(String username) throws EDAMNotFoundException, EDAMSystemException, EDAMUserException, TException {
            this.send_getPublicUserInfo(username);
            return this.recv_getPublicUserInfo();
        }

        public void send_getPublicUserInfo(String username) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getPublicUserInfo", 1, ++this.seqid_));
            getPublicUserInfo_args args = new getPublicUserInfo_args();
            args.setUsername(username);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public PublicUserInfo recv_getPublicUserInfo() throws EDAMNotFoundException, EDAMSystemException, EDAMUserException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getPublicUserInfo failed: out of sequence response");
            }
            getPublicUserInfo_result result = new getPublicUserInfo_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.notFoundException != null) {
                throw result.notFoundException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            throw new TApplicationException(5, "getPublicUserInfo failed: unknown result");
        }

        public PremiumInfo getPremiumInfo(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getPremiumInfo(authenticationToken);
            return this.recv_getPremiumInfo();
        }

        public void send_getPremiumInfo(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getPremiumInfo", 1, ++this.seqid_));
            getPremiumInfo_args args = new getPremiumInfo_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public PremiumInfo recv_getPremiumInfo() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getPremiumInfo failed: out of sequence response");
            }
            getPremiumInfo_result result = new getPremiumInfo_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getPremiumInfo failed: unknown result");
        }

        public String getNoteStoreUrl(String authenticationToken) throws EDAMUserException, EDAMSystemException, TException {
            this.send_getNoteStoreUrl(authenticationToken);
            return this.recv_getNoteStoreUrl();
        }

        public void send_getNoteStoreUrl(String authenticationToken) throws TException {
            this.oprot_.writeMessageBegin(new TMessage("getNoteStoreUrl", 1, ++this.seqid_));
            getNoteStoreUrl_args args = new getNoteStoreUrl_args();
            args.setAuthenticationToken(authenticationToken);
            args.write(this.oprot_);
            this.oprot_.writeMessageEnd();
            this.oprot_.getTransport().flush();
        }

        public String recv_getNoteStoreUrl() throws EDAMUserException, EDAMSystemException, TException {
            TMessage msg = this.iprot_.readMessageBegin();
            if (msg.type == 3) {
                TApplicationException x = TApplicationException.read(this.iprot_);
                this.iprot_.readMessageEnd();
                throw x;
            }
            if (msg.seqid != this.seqid_) {
                throw new TApplicationException(4, "getNoteStoreUrl failed: out of sequence response");
            }
            getNoteStoreUrl_result result = new getNoteStoreUrl_result();
            result.read(this.iprot_);
            this.iprot_.readMessageEnd();
            if (result.isSetSuccess()) {
                return result.success;
            }
            if (result.userException != null) {
                throw result.userException;
            }
            if (result.systemException != null) {
                throw result.systemException;
            }
            throw new TApplicationException(5, "getNoteStoreUrl failed: unknown result");
        }
    }

    public static interface Iface
    extends UserStoreIface {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateLongSession_args
    implements TBase<authenticateLongSession_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateLongSession_args");
        private static final TField USERNAME_FIELD_DESC = new TField("username", 11, 1);
        private static final TField PASSWORD_FIELD_DESC = new TField("password", 11, 2);
        private static final TField CONSUMER_KEY_FIELD_DESC = new TField("consumerKey", 11, 3);
        private static final TField CONSUMER_SECRET_FIELD_DESC = new TField("consumerSecret", 11, 4);
        private static final TField DEVICE_IDENTIFIER_FIELD_DESC = new TField("deviceIdentifier", 11, 5);
        private static final TField DEVICE_DESCRIPTION_FIELD_DESC = new TField("deviceDescription", 11, 6);
        private static final TField SUPPORTS_TWO_FACTOR_FIELD_DESC = new TField("supportsTwoFactor", 2, 7);
        private String username;
        private String password;
        private String consumerKey;
        private String consumerSecret;
        private String deviceIdentifier;
        private String deviceDescription;
        private boolean supportsTwoFactor;
        private static final int __SUPPORTSTWOFACTOR_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public authenticateLongSession_args() {
        }

        public authenticateLongSession_args(authenticateLongSession_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetUsername()) {
                this.username = other.username;
            }
            if (other.isSetPassword()) {
                this.password = other.password;
            }
            if (other.isSetConsumerKey()) {
                this.consumerKey = other.consumerKey;
            }
            if (other.isSetConsumerSecret()) {
                this.consumerSecret = other.consumerSecret;
            }
            if (other.isSetDeviceIdentifier()) {
                this.deviceIdentifier = other.deviceIdentifier;
            }
            if (other.isSetDeviceDescription()) {
                this.deviceDescription = other.deviceDescription;
            }
            this.supportsTwoFactor = other.supportsTwoFactor;
        }

        public authenticateLongSession_args deepCopy() {
            return new authenticateLongSession_args(this);
        }

        @Override
        public void clear() {
            this.username = null;
            this.password = null;
            this.consumerKey = null;
            this.consumerSecret = null;
            this.deviceIdentifier = null;
            this.deviceDescription = null;
            this.setSupportsTwoFactorIsSet(false);
            this.supportsTwoFactor = false;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean isSetUsername() {
            return this.username != null;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isSetPassword() {
            return this.password != null;
        }

        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }

        public boolean isSetConsumerKey() {
            return this.consumerKey != null;
        }

        public void setConsumerSecret(String consumerSecret) {
            this.consumerSecret = consumerSecret;
        }

        public boolean isSetConsumerSecret() {
            return this.consumerSecret != null;
        }

        public void setDeviceIdentifier(String deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier;
        }

        public boolean isSetDeviceIdentifier() {
            return this.deviceIdentifier != null;
        }

        public void setDeviceDescription(String deviceDescription) {
            this.deviceDescription = deviceDescription;
        }

        public boolean isSetDeviceDescription() {
            return this.deviceDescription != null;
        }

        public void setSupportsTwoFactor(boolean supportsTwoFactor) {
            this.supportsTwoFactor = supportsTwoFactor;
            this.setSupportsTwoFactorIsSet(true);
        }

        public boolean isSetSupportsTwoFactor() {
            return this.__isset_vector[0];
        }

        public void setSupportsTwoFactorIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        @Override
        public int compareTo(authenticateLongSession_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateLongSession_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetUsername()).compareTo(typedOther.isSetUsername());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUsername() && (lastComparison = TBaseHelper.compareTo(this.username, typedOther.username)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetPassword()).compareTo(typedOther.isSetPassword());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetPassword() && (lastComparison = TBaseHelper.compareTo(this.password, typedOther.password)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetConsumerKey()).compareTo(typedOther.isSetConsumerKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetConsumerKey() && (lastComparison = TBaseHelper.compareTo(this.consumerKey, typedOther.consumerKey)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetConsumerSecret()).compareTo(typedOther.isSetConsumerSecret());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetConsumerSecret() && (lastComparison = TBaseHelper.compareTo(this.consumerSecret, typedOther.consumerSecret)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetDeviceIdentifier()).compareTo(typedOther.isSetDeviceIdentifier());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetDeviceIdentifier() && (lastComparison = TBaseHelper.compareTo(this.deviceIdentifier, typedOther.deviceIdentifier)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetDeviceDescription()).compareTo(typedOther.isSetDeviceDescription());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetDeviceDescription() && (lastComparison = TBaseHelper.compareTo(this.deviceDescription, typedOther.deviceDescription)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSupportsTwoFactor()).compareTo(typedOther.isSetSupportsTwoFactor());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSupportsTwoFactor() && (lastComparison = TBaseHelper.compareTo(this.supportsTwoFactor, typedOther.supportsTwoFactor)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.username = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.password = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.consumerKey = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 11) {
                            this.consumerSecret = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 11) {
                            this.deviceIdentifier = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 6: {
                        if (field.type == 11) {
                            this.deviceDescription = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 7: {
                        if (field.type == 2) {
                            this.supportsTwoFactor = iprot.readBool();
                            this.setSupportsTwoFactorIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.username != null) {
                oprot.writeFieldBegin(USERNAME_FIELD_DESC);
                oprot.writeString(this.username);
                oprot.writeFieldEnd();
            }
            if (this.password != null) {
                oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
                oprot.writeString(this.password);
                oprot.writeFieldEnd();
            }
            if (this.consumerKey != null) {
                oprot.writeFieldBegin(CONSUMER_KEY_FIELD_DESC);
                oprot.writeString(this.consumerKey);
                oprot.writeFieldEnd();
            }
            if (this.consumerSecret != null) {
                oprot.writeFieldBegin(CONSUMER_SECRET_FIELD_DESC);
                oprot.writeString(this.consumerSecret);
                oprot.writeFieldEnd();
            }
            if (this.deviceIdentifier != null) {
                oprot.writeFieldBegin(DEVICE_IDENTIFIER_FIELD_DESC);
                oprot.writeString(this.deviceIdentifier);
                oprot.writeFieldEnd();
            }
            if (this.deviceDescription != null) {
                oprot.writeFieldBegin(DEVICE_DESCRIPTION_FIELD_DESC);
                oprot.writeString(this.deviceDescription);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(SUPPORTS_TWO_FACTOR_FIELD_DESC);
            oprot.writeBool(this.supportsTwoFactor);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateLongSession_result
    implements TBase<authenticateLongSession_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateLongSession_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public authenticateLongSession_result() {
        }

        public authenticateLongSession_result(authenticateLongSession_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public authenticateLongSession_result deepCopy() {
            return new authenticateLongSession_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(authenticateLongSession_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateLongSession_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateToBusiness_args
    implements TBase<authenticateToBusiness_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateToBusiness_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public authenticateToBusiness_args() {
        }

        public authenticateToBusiness_args(authenticateToBusiness_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public authenticateToBusiness_args deepCopy() {
            return new authenticateToBusiness_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(authenticateToBusiness_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateToBusiness_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticateToBusiness_result
    implements TBase<authenticateToBusiness_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticateToBusiness_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public authenticateToBusiness_result() {
        }

        public authenticateToBusiness_result(authenticateToBusiness_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public authenticateToBusiness_result deepCopy() {
            return new authenticateToBusiness_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(authenticateToBusiness_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticateToBusiness_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticate_args
    implements TBase<authenticate_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticate_args");
        private static final TField USERNAME_FIELD_DESC = new TField("username", 11, 1);
        private static final TField PASSWORD_FIELD_DESC = new TField("password", 11, 2);
        private static final TField CONSUMER_KEY_FIELD_DESC = new TField("consumerKey", 11, 3);
        private static final TField CONSUMER_SECRET_FIELD_DESC = new TField("consumerSecret", 11, 4);
        private static final TField SUPPORTS_TWO_FACTOR_FIELD_DESC = new TField("supportsTwoFactor", 2, 5);
        private String username;
        private String password;
        private String consumerKey;
        private String consumerSecret;
        private boolean supportsTwoFactor;
        private static final int __SUPPORTSTWOFACTOR_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public authenticate_args() {
        }

        public authenticate_args(authenticate_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetUsername()) {
                this.username = other.username;
            }
            if (other.isSetPassword()) {
                this.password = other.password;
            }
            if (other.isSetConsumerKey()) {
                this.consumerKey = other.consumerKey;
            }
            if (other.isSetConsumerSecret()) {
                this.consumerSecret = other.consumerSecret;
            }
            this.supportsTwoFactor = other.supportsTwoFactor;
        }

        public authenticate_args deepCopy() {
            return new authenticate_args(this);
        }

        @Override
        public void clear() {
            this.username = null;
            this.password = null;
            this.consumerKey = null;
            this.consumerSecret = null;
            this.setSupportsTwoFactorIsSet(false);
            this.supportsTwoFactor = false;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean isSetUsername() {
            return this.username != null;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isSetPassword() {
            return this.password != null;
        }

        public void setConsumerKey(String consumerKey) {
            this.consumerKey = consumerKey;
        }

        public boolean isSetConsumerKey() {
            return this.consumerKey != null;
        }

        public void setConsumerSecret(String consumerSecret) {
            this.consumerSecret = consumerSecret;
        }

        public boolean isSetConsumerSecret() {
            return this.consumerSecret != null;
        }

        public void setSupportsTwoFactor(boolean supportsTwoFactor) {
            this.supportsTwoFactor = supportsTwoFactor;
            this.setSupportsTwoFactorIsSet(true);
        }

        public boolean isSetSupportsTwoFactor() {
            return this.__isset_vector[0];
        }

        public void setSupportsTwoFactorIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        @Override
        public int compareTo(authenticate_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticate_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetUsername()).compareTo(typedOther.isSetUsername());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUsername() && (lastComparison = TBaseHelper.compareTo(this.username, typedOther.username)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetPassword()).compareTo(typedOther.isSetPassword());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetPassword() && (lastComparison = TBaseHelper.compareTo(this.password, typedOther.password)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetConsumerKey()).compareTo(typedOther.isSetConsumerKey());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetConsumerKey() && (lastComparison = TBaseHelper.compareTo(this.consumerKey, typedOther.consumerKey)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetConsumerSecret()).compareTo(typedOther.isSetConsumerSecret());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetConsumerSecret() && (lastComparison = TBaseHelper.compareTo(this.consumerSecret, typedOther.consumerSecret)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSupportsTwoFactor()).compareTo(typedOther.isSetSupportsTwoFactor());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSupportsTwoFactor() && (lastComparison = TBaseHelper.compareTo(this.supportsTwoFactor, typedOther.supportsTwoFactor)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.username = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.password = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.consumerKey = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 11) {
                            this.consumerSecret = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 5: {
                        if (field.type == 2) {
                            this.supportsTwoFactor = iprot.readBool();
                            this.setSupportsTwoFactorIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.username != null) {
                oprot.writeFieldBegin(USERNAME_FIELD_DESC);
                oprot.writeString(this.username);
                oprot.writeFieldEnd();
            }
            if (this.password != null) {
                oprot.writeFieldBegin(PASSWORD_FIELD_DESC);
                oprot.writeString(this.password);
                oprot.writeFieldEnd();
            }
            if (this.consumerKey != null) {
                oprot.writeFieldBegin(CONSUMER_KEY_FIELD_DESC);
                oprot.writeString(this.consumerKey);
                oprot.writeFieldEnd();
            }
            if (this.consumerSecret != null) {
                oprot.writeFieldBegin(CONSUMER_SECRET_FIELD_DESC);
                oprot.writeString(this.consumerSecret);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(SUPPORTS_TWO_FACTOR_FIELD_DESC);
            oprot.writeBool(this.supportsTwoFactor);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class authenticate_result
    implements TBase<authenticate_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("authenticate_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public authenticate_result() {
        }

        public authenticate_result(authenticate_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public authenticate_result deepCopy() {
            return new authenticate_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(authenticate_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            authenticate_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class checkVersion_args
    implements TBase<checkVersion_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("checkVersion_args");
        private static final TField CLIENT_NAME_FIELD_DESC = new TField("clientName", 11, 1);
        private static final TField EDAM_VERSION_MAJOR_FIELD_DESC = new TField("edamVersionMajor", 6, 2);
        private static final TField EDAM_VERSION_MINOR_FIELD_DESC = new TField("edamVersionMinor", 6, 3);
        private String clientName;
        private short edamVersionMajor;
        private short edamVersionMinor;
        private static final int __EDAMVERSIONMAJOR_ISSET_ID = 0;
        private static final int __EDAMVERSIONMINOR_ISSET_ID = 1;
        private boolean[] __isset_vector = new boolean[2];

        public checkVersion_args() {
            this.edamVersionMajor = 1;
            this.edamVersionMinor = (short)25;
        }

        public checkVersion_args(checkVersion_args other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            if (other.isSetClientName()) {
                this.clientName = other.clientName;
            }
            this.edamVersionMajor = other.edamVersionMajor;
            this.edamVersionMinor = other.edamVersionMinor;
        }

        public checkVersion_args deepCopy() {
            return new checkVersion_args(this);
        }

        @Override
        public void clear() {
            this.clientName = null;
            this.edamVersionMajor = 1;
            this.edamVersionMinor = (short)25;
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        public boolean isSetClientName() {
            return this.clientName != null;
        }

        public void setEdamVersionMajor(short edamVersionMajor) {
            this.edamVersionMajor = edamVersionMajor;
            this.setEdamVersionMajorIsSet(true);
        }

        public boolean isSetEdamVersionMajor() {
            return this.__isset_vector[0];
        }

        public void setEdamVersionMajorIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        public void setEdamVersionMinor(short edamVersionMinor) {
            this.edamVersionMinor = edamVersionMinor;
            this.setEdamVersionMinorIsSet(true);
        }

        public boolean isSetEdamVersionMinor() {
            return this.__isset_vector[1];
        }

        public void setEdamVersionMinorIsSet(boolean value) {
            this.__isset_vector[1] = value;
        }

        @Override
        public int compareTo(checkVersion_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            checkVersion_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetClientName()).compareTo(typedOther.isSetClientName());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetClientName() && (lastComparison = TBaseHelper.compareTo(this.clientName, typedOther.clientName)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetEdamVersionMajor()).compareTo(typedOther.isSetEdamVersionMajor());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetEdamVersionMajor() && (lastComparison = TBaseHelper.compareTo(this.edamVersionMajor, typedOther.edamVersionMajor)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetEdamVersionMinor()).compareTo(typedOther.isSetEdamVersionMinor());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetEdamVersionMinor() && (lastComparison = TBaseHelper.compareTo(this.edamVersionMinor, typedOther.edamVersionMinor)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.clientName = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 6) {
                            this.edamVersionMajor = iprot.readI16();
                            this.setEdamVersionMajorIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 6) {
                            this.edamVersionMinor = iprot.readI16();
                            this.setEdamVersionMinorIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.clientName != null) {
                oprot.writeFieldBegin(CLIENT_NAME_FIELD_DESC);
                oprot.writeString(this.clientName);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(EDAM_VERSION_MAJOR_FIELD_DESC);
            oprot.writeI16(this.edamVersionMajor);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(EDAM_VERSION_MINOR_FIELD_DESC);
            oprot.writeI16(this.edamVersionMinor);
            oprot.writeFieldEnd();
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class checkVersion_result
    implements TBase<checkVersion_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("checkVersion_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 2, 0);
        private boolean success;
        private static final int __SUCCESS_ISSET_ID = 0;
        private boolean[] __isset_vector = new boolean[1];

        public checkVersion_result() {
        }

        public checkVersion_result(checkVersion_result other) {
            System.arraycopy(other.__isset_vector, 0, this.__isset_vector, 0, other.__isset_vector.length);
            this.success = other.success;
        }

        public checkVersion_result deepCopy() {
            return new checkVersion_result(this);
        }

        @Override
        public void clear() {
            this.setSuccessIsSet(false);
            this.success = false;
        }

        public boolean isSetSuccess() {
            return this.__isset_vector[0];
        }

        public void setSuccessIsSet(boolean value) {
            this.__isset_vector[0] = value;
        }

        @Override
        public int compareTo(checkVersion_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            checkVersion_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 2) {
                            this.success = iprot.readBool();
                            this.setSuccessIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeBool(this.success);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class completeTwoFactorAuthentication_args
    implements TBase<completeTwoFactorAuthentication_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("completeTwoFactorAuthentication_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private static final TField ONE_TIME_CODE_FIELD_DESC = new TField("oneTimeCode", 11, 2);
        private static final TField DEVICE_IDENTIFIER_FIELD_DESC = new TField("deviceIdentifier", 11, 3);
        private static final TField DEVICE_DESCRIPTION_FIELD_DESC = new TField("deviceDescription", 11, 4);
        private String authenticationToken;
        private String oneTimeCode;
        private String deviceIdentifier;
        private String deviceDescription;

        public completeTwoFactorAuthentication_args() {
        }

        public completeTwoFactorAuthentication_args(completeTwoFactorAuthentication_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
            if (other.isSetOneTimeCode()) {
                this.oneTimeCode = other.oneTimeCode;
            }
            if (other.isSetDeviceIdentifier()) {
                this.deviceIdentifier = other.deviceIdentifier;
            }
            if (other.isSetDeviceDescription()) {
                this.deviceDescription = other.deviceDescription;
            }
        }

        public completeTwoFactorAuthentication_args deepCopy() {
            return new completeTwoFactorAuthentication_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
            this.oneTimeCode = null;
            this.deviceIdentifier = null;
            this.deviceDescription = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        public void setOneTimeCode(String oneTimeCode) {
            this.oneTimeCode = oneTimeCode;
        }

        public boolean isSetOneTimeCode() {
            return this.oneTimeCode != null;
        }

        public void setDeviceIdentifier(String deviceIdentifier) {
            this.deviceIdentifier = deviceIdentifier;
        }

        public boolean isSetDeviceIdentifier() {
            return this.deviceIdentifier != null;
        }

        public void setDeviceDescription(String deviceDescription) {
            this.deviceDescription = deviceDescription;
        }

        public boolean isSetDeviceDescription() {
            return this.deviceDescription != null;
        }

        @Override
        public int compareTo(completeTwoFactorAuthentication_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            completeTwoFactorAuthentication_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetOneTimeCode()).compareTo(typedOther.isSetOneTimeCode());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetOneTimeCode() && (lastComparison = TBaseHelper.compareTo(this.oneTimeCode, typedOther.oneTimeCode)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetDeviceIdentifier()).compareTo(typedOther.isSetDeviceIdentifier());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetDeviceIdentifier() && (lastComparison = TBaseHelper.compareTo(this.deviceIdentifier, typedOther.deviceIdentifier)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetDeviceDescription()).compareTo(typedOther.isSetDeviceDescription());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetDeviceDescription() && (lastComparison = TBaseHelper.compareTo(this.deviceDescription, typedOther.deviceDescription)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 11) {
                            this.oneTimeCode = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 11) {
                            this.deviceIdentifier = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 4: {
                        if (field.type == 11) {
                            this.deviceDescription = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            if (this.oneTimeCode != null) {
                oprot.writeFieldBegin(ONE_TIME_CODE_FIELD_DESC);
                oprot.writeString(this.oneTimeCode);
                oprot.writeFieldEnd();
            }
            if (this.deviceIdentifier != null) {
                oprot.writeFieldBegin(DEVICE_IDENTIFIER_FIELD_DESC);
                oprot.writeString(this.deviceIdentifier);
                oprot.writeFieldEnd();
            }
            if (this.deviceDescription != null) {
                oprot.writeFieldBegin(DEVICE_DESCRIPTION_FIELD_DESC);
                oprot.writeString(this.deviceDescription);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class completeTwoFactorAuthentication_result
    implements TBase<completeTwoFactorAuthentication_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("completeTwoFactorAuthentication_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public completeTwoFactorAuthentication_result() {
        }

        public completeTwoFactorAuthentication_result(completeTwoFactorAuthentication_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public completeTwoFactorAuthentication_result deepCopy() {
            return new completeTwoFactorAuthentication_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(completeTwoFactorAuthentication_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            completeTwoFactorAuthentication_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getBootstrapInfo_args
    implements TBase<getBootstrapInfo_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getBootstrapInfo_args");
        private static final TField LOCALE_FIELD_DESC = new TField("locale", 11, 1);
        private String locale;

        public getBootstrapInfo_args() {
        }

        public getBootstrapInfo_args(getBootstrapInfo_args other) {
            if (other.isSetLocale()) {
                this.locale = other.locale;
            }
        }

        public getBootstrapInfo_args deepCopy() {
            return new getBootstrapInfo_args(this);
        }

        @Override
        public void clear() {
            this.locale = null;
        }

        public void setLocale(String locale) {
            this.locale = locale;
        }

        public boolean isSetLocale() {
            return this.locale != null;
        }

        @Override
        public int compareTo(getBootstrapInfo_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getBootstrapInfo_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetLocale()).compareTo(typedOther.isSetLocale());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetLocale() && (lastComparison = TBaseHelper.compareTo(this.locale, typedOther.locale)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.locale = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.locale != null) {
                oprot.writeFieldBegin(LOCALE_FIELD_DESC);
                oprot.writeString(this.locale);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getBootstrapInfo_result
    implements TBase<getBootstrapInfo_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getBootstrapInfo_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private BootstrapInfo success;

        public getBootstrapInfo_result() {
        }

        public getBootstrapInfo_result(getBootstrapInfo_result other) {
            if (other.isSetSuccess()) {
                this.success = new BootstrapInfo(other.success);
            }
        }

        public getBootstrapInfo_result deepCopy() {
            return new getBootstrapInfo_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        @Override
        public int compareTo(getBootstrapInfo_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getBootstrapInfo_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new BootstrapInfo();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteStoreUrl_args
    implements TBase<getNoteStoreUrl_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteStoreUrl_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public getNoteStoreUrl_args() {
        }

        public getNoteStoreUrl_args(getNoteStoreUrl_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public getNoteStoreUrl_args deepCopy() {
            return new getNoteStoreUrl_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(getNoteStoreUrl_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteStoreUrl_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getNoteStoreUrl_result
    implements TBase<getNoteStoreUrl_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getNoteStoreUrl_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 11, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private String success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getNoteStoreUrl_result() {
        }

        public getNoteStoreUrl_result(getNoteStoreUrl_result other) {
            if (other.isSetSuccess()) {
                this.success = other.success;
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getNoteStoreUrl_result deepCopy() {
            return new getNoteStoreUrl_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getNoteStoreUrl_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getNoteStoreUrl_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 11) {
                            this.success = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                oprot.writeString(this.success);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getPremiumInfo_args
    implements TBase<getPremiumInfo_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getPremiumInfo_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public getPremiumInfo_args() {
        }

        public getPremiumInfo_args(getPremiumInfo_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public getPremiumInfo_args deepCopy() {
            return new getPremiumInfo_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(getPremiumInfo_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getPremiumInfo_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getPremiumInfo_result
    implements TBase<getPremiumInfo_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getPremiumInfo_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private PremiumInfo success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getPremiumInfo_result() {
        }

        public getPremiumInfo_result(getPremiumInfo_result other) {
            if (other.isSetSuccess()) {
                this.success = new PremiumInfo(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getPremiumInfo_result deepCopy() {
            return new getPremiumInfo_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getPremiumInfo_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getPremiumInfo_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new PremiumInfo();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getPublicUserInfo_args
    implements TBase<getPublicUserInfo_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getPublicUserInfo_args");
        private static final TField USERNAME_FIELD_DESC = new TField("username", 11, 1);
        private String username;

        public getPublicUserInfo_args() {
        }

        public getPublicUserInfo_args(getPublicUserInfo_args other) {
            if (other.isSetUsername()) {
                this.username = other.username;
            }
        }

        public getPublicUserInfo_args deepCopy() {
            return new getPublicUserInfo_args(this);
        }

        @Override
        public void clear() {
            this.username = null;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean isSetUsername() {
            return this.username != null;
        }

        @Override
        public int compareTo(getPublicUserInfo_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getPublicUserInfo_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetUsername()).compareTo(typedOther.isSetUsername());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUsername() && (lastComparison = TBaseHelper.compareTo(this.username, typedOther.username)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.username = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.username != null) {
                oprot.writeFieldBegin(USERNAME_FIELD_DESC);
                oprot.writeString(this.username);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getPublicUserInfo_result
    implements TBase<getPublicUserInfo_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getPublicUserInfo_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField NOT_FOUND_EXCEPTION_FIELD_DESC = new TField("notFoundException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 3);
        private PublicUserInfo success;
        private EDAMNotFoundException notFoundException;
        private EDAMSystemException systemException;
        private EDAMUserException userException;

        public getPublicUserInfo_result() {
        }

        public getPublicUserInfo_result(getPublicUserInfo_result other) {
            if (other.isSetSuccess()) {
                this.success = new PublicUserInfo(other.success);
            }
            if (other.isSetNotFoundException()) {
                this.notFoundException = new EDAMNotFoundException(other.notFoundException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
        }

        public getPublicUserInfo_result deepCopy() {
            return new getPublicUserInfo_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.notFoundException = null;
            this.systemException = null;
            this.userException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetNotFoundException() {
            return this.notFoundException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        @Override
        public int compareTo(getPublicUserInfo_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getPublicUserInfo_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetNotFoundException()).compareTo(typedOther.isSetNotFoundException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetNotFoundException() && (lastComparison = TBaseHelper.compareTo(this.notFoundException, typedOther.notFoundException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new PublicUserInfo();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.notFoundException = new EDAMNotFoundException();
                            this.notFoundException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 3: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetNotFoundException()) {
                oprot.writeFieldBegin(NOT_FOUND_EXCEPTION_FIELD_DESC);
                this.notFoundException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getUser_args
    implements TBase<getUser_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getUser_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public getUser_args() {
        }

        public getUser_args(getUser_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public getUser_args deepCopy() {
            return new getUser_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(getUser_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getUser_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class getUser_result
    implements TBase<getUser_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("getUser_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private User success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public getUser_result() {
        }

        public getUser_result(getUser_result other) {
            if (other.isSetSuccess()) {
                this.success = new User(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public getUser_result deepCopy() {
            return new getUser_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(getUser_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            getUser_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new User();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class refreshAuthentication_args
    implements TBase<refreshAuthentication_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("refreshAuthentication_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public refreshAuthentication_args() {
        }

        public refreshAuthentication_args(refreshAuthentication_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public refreshAuthentication_args deepCopy() {
            return new refreshAuthentication_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(refreshAuthentication_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            refreshAuthentication_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class refreshAuthentication_result
    implements TBase<refreshAuthentication_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("refreshAuthentication_result");
        private static final TField SUCCESS_FIELD_DESC = new TField("success", 12, 0);
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private AuthenticationResult success;
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public refreshAuthentication_result() {
        }

        public refreshAuthentication_result(refreshAuthentication_result other) {
            if (other.isSetSuccess()) {
                this.success = new AuthenticationResult(other.success);
            }
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public refreshAuthentication_result deepCopy() {
            return new refreshAuthentication_result(this);
        }

        @Override
        public void clear() {
            this.success = null;
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetSuccess() {
            return this.success != null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(refreshAuthentication_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            refreshAuthentication_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetSuccess()).compareTo(typedOther.isSetSuccess());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSuccess() && (lastComparison = TBaseHelper.compareTo(this.success, typedOther.success)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 0: {
                        if (field.type == 12) {
                            this.success = new AuthenticationResult();
                            this.success.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetSuccess()) {
                oprot.writeFieldBegin(SUCCESS_FIELD_DESC);
                this.success.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class revokeLongSession_args
    implements TBase<revokeLongSession_args>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("revokeLongSession_args");
        private static final TField AUTHENTICATION_TOKEN_FIELD_DESC = new TField("authenticationToken", 11, 1);
        private String authenticationToken;

        public revokeLongSession_args() {
        }

        public revokeLongSession_args(revokeLongSession_args other) {
            if (other.isSetAuthenticationToken()) {
                this.authenticationToken = other.authenticationToken;
            }
        }

        public revokeLongSession_args deepCopy() {
            return new revokeLongSession_args(this);
        }

        @Override
        public void clear() {
            this.authenticationToken = null;
        }

        public void setAuthenticationToken(String authenticationToken) {
            this.authenticationToken = authenticationToken;
        }

        public boolean isSetAuthenticationToken() {
            return this.authenticationToken != null;
        }

        @Override
        public int compareTo(revokeLongSession_args other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            revokeLongSession_args typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetAuthenticationToken()).compareTo(typedOther.isSetAuthenticationToken());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetAuthenticationToken() && (lastComparison = TBaseHelper.compareTo(this.authenticationToken, typedOther.authenticationToken)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 11) {
                            this.authenticationToken = iprot.readString();
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            this.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.authenticationToken != null) {
                oprot.writeFieldBegin(AUTHENTICATION_TOKEN_FIELD_DESC);
                oprot.writeString(this.authenticationToken);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class revokeLongSession_result
    implements TBase<revokeLongSession_result>,
    Serializable,
    Cloneable {
        private static final TStruct STRUCT_DESC = new TStruct("revokeLongSession_result");
        private static final TField USER_EXCEPTION_FIELD_DESC = new TField("userException", 12, 1);
        private static final TField SYSTEM_EXCEPTION_FIELD_DESC = new TField("systemException", 12, 2);
        private EDAMUserException userException;
        private EDAMSystemException systemException;

        public revokeLongSession_result() {
        }

        public revokeLongSession_result(revokeLongSession_result other) {
            if (other.isSetUserException()) {
                this.userException = new EDAMUserException(other.userException);
            }
            if (other.isSetSystemException()) {
                this.systemException = new EDAMSystemException(other.systemException);
            }
        }

        public revokeLongSession_result deepCopy() {
            return new revokeLongSession_result(this);
        }

        @Override
        public void clear() {
            this.userException = null;
            this.systemException = null;
        }

        public boolean isSetUserException() {
            return this.userException != null;
        }

        public boolean isSetSystemException() {
            return this.systemException != null;
        }

        @Override
        public int compareTo(revokeLongSession_result other) {
            if (!this.getClass().equals(other.getClass())) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            int lastComparison = 0;
            revokeLongSession_result typedOther = other;
            lastComparison = Boolean.valueOf(this.isSetUserException()).compareTo(typedOther.isSetUserException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetUserException() && (lastComparison = TBaseHelper.compareTo(this.userException, typedOther.userException)) != 0) {
                return lastComparison;
            }
            lastComparison = Boolean.valueOf(this.isSetSystemException()).compareTo(typedOther.isSetSystemException());
            if (lastComparison != 0) {
                return lastComparison;
            }
            if (this.isSetSystemException() && (lastComparison = TBaseHelper.compareTo(this.systemException, typedOther.systemException)) != 0) {
                return lastComparison;
            }
            return 0;
        }

        @Override
        public void read(TProtocol iprot) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField field = iprot.readFieldBegin();
                if (field.type == 0) break;
                switch (field.id) {
                    case 1: {
                        if (field.type == 12) {
                            this.userException = new EDAMUserException();
                            this.userException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    case 2: {
                        if (field.type == 12) {
                            this.systemException = new EDAMSystemException();
                            this.systemException.read(iprot);
                            break;
                        }
                        TProtocolUtil.skip(iprot, field.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, field.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            this.validate();
        }

        @Override
        public void write(TProtocol oprot) throws TException {
            oprot.writeStructBegin(STRUCT_DESC);
            if (this.isSetUserException()) {
                oprot.writeFieldBegin(USER_EXCEPTION_FIELD_DESC);
                this.userException.write(oprot);
                oprot.writeFieldEnd();
            } else if (this.isSetSystemException()) {
                oprot.writeFieldBegin(SYSTEM_EXCEPTION_FIELD_DESC);
                this.systemException.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }

        public void validate() throws TException {
        }
    }
}

