/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.GC;
import org.xmind.gef.GEF;
import org.xmind.gef.GraphicalViewer;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskBarViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.gantt2.viewer.TimelineViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttFigureRenderer {
    private static int MISSING_WIDTH = 0;
    private GanttViewer ganttViewer;
    private Rectangle bounds;
    private double scale = 1.0;

    public GanttFigureRenderer(GanttViewer ganttViewer) {
        this.ganttViewer = ganttViewer;
    }

    public void render(GC gc, long startTime, long endTime, Point origin, Rectangle contentClip) {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int width0 = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        int start = timelineModel.getPixelsFromMillis(startTime - timelineModel.getOriginDate().getTimeInMillis()) - 50;
        int width1 = startTime != endTime ? timelineModel.getPixelsFromMillis(endTime - startTime) + 100 : 0;
        int end = start + width1;
        this.render(gc, origin, 0, width0, start, end, contentClip);
    }

    private void render(GC gc, Point origin, int leftStart, int leftEnd, int rightStart, int rightEnd, Rectangle contentClip) {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        int width0 = leftEnd - leftStart;
        int height0 = headerViewer.getCanvas().getSize().y;
        this.renderTaskTreeHeaderViewer(gc, new Point(origin.x, 0), leftStart, leftEnd);
        this.renderTimelineViewer(gc, new Point(origin.x + width0, 0), rightStart, rightEnd);
        this.renderTaskTreeViewer(gc, new Point(origin.x, origin.y + height0), leftStart, leftEnd, contentClip);
        this.renderTaskBarViewer(gc, new Point(origin.x + width0, origin.y + height0), rightStart, rightEnd, contentClip);
    }

    /*
     * Unable to fully structure code
     */
    public void renderTaskTreeHeaderViewer(GC gc, Point origin, int start, int end) {
        graphicsStack = new Stack<Graphics>();
        baseGraphics = new SWTGraphics(gc);
        graphicsStack.push((Graphics)baseGraphics);
        this.createGraphics((Graphics)baseGraphics, graphicsStack);
        graphics = graphicsStack.peek();
        try {
            graphics.translate(origin.x, origin.y);
            headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
            height = headerViewer.getCanvas().getSize().y;
            graphics.clipRect(new Rectangle(0, 0, end - start + 1, height));
            graphics.setBackgroundColor(headerViewer.getCanvas().getBackground());
            graphics.fillRectangle(new Rectangle(0, 0, end - start + 1, height));
            graphics.translate(-start, 0);
            headerViewer.getViewport().paint(graphics);
            graphics.setLineWidth(1);
            graphics.setForegroundColor(Colors.split());
            widthSupport = this.ganttViewer.getWidthsSupport();
            i = 0;
            while (i < widthSupport.getSize()) {
                x = widthSupport.sum(i);
                graphics.drawLine(x, 0, x, height);
                ++i;
            }
            graphics.setForegroundColor(Colors.header());
            graphics.drawLine(end - 2, 0, end - 2, height);
            graphics.setForegroundColor(Colors.splitBar());
            graphics.drawLine(end - 1, 0, end - 1, height);
            if (true) ** GOTO lbl37
        }
        catch (Throwable var13_13) {
            ** while (!graphicsStack.isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            graphicsStack.pop().dispose();
            continue;
        }
lbl34:
        // 1 sources

        throw var13_13;
        do {
            graphicsStack.pop().dispose();
lbl37:
            // 2 sources

        } while (!graphicsStack.isEmpty());
    }

    /*
     * Unable to fully structure code
     */
    public void renderTimelineViewer(GC gc, Point origin, int start, int end) {
        timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        timelineModel.setExportMode(true);
        timelineModel.setExportStart(start);
        timelineModel.setExportEnd(end);
        timelineViewer = this.ganttViewer.getTimelineViewer();
        taskBarViewer = this.ganttViewer.getTaskBarViewer();
        rangeModel = taskBarViewer.getCanvas().getViewport().getHorizontalRangeModel();
        value = rangeModel.getValue();
        graphicsStack = new Stack<Graphics>();
        baseGraphics = new SWTGraphics(gc);
        graphicsStack.push((Graphics)baseGraphics);
        this.createGraphics((Graphics)baseGraphics, graphicsStack);
        graphics = graphicsStack.peek();
        try {
            start0 = start;
            rangeModel.setValue(start);
            timelineViewer.getCanvas().getViewport().getUpdateManager().performUpdate();
            if (rangeModel.getValue() != start) {
                this.doRenderTimelineViewer(graphics, origin, start, end, rangeModel.getValue() - start0);
            }
            while (start0 + rangeModel.getExtent() - GanttFigureRenderer.MISSING_WIDTH < end) {
                this.doRenderTimelineViewer(graphics, new Point(origin.x + start0 - start, origin.y), start0, start0 + rangeModel.getExtent(), 0);
                rangeModel.setValue(start0 += rangeModel.getExtent() - GanttFigureRenderer.MISSING_WIDTH);
                timelineViewer.getCanvas().getViewport().getUpdateManager().performUpdate();
            }
            if (rangeModel.getValue() == start0) {
                this.doRenderTimelineViewer(graphics, new Point(origin.x + start0 - start, origin.y), start0, end, 0);
            }
            this.doRenderTimelineViewer(graphics, new Point(origin.x + start0 - start, origin.y), rangeModel.getValue() - start, end, rangeModel.getValue() - start0);
        }
        finally {
            timelineModel.setExportMode(false);
            rangeModel.setValue(value);
            ** while (!graphicsStack.isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            graphicsStack.pop().dispose();
            continue;
        }
lbl38:
        // 1 sources

    }

    private void doRenderTimelineViewer(Graphics graphics, Point origin, int start, int end, int translateX) {
        graphics.pushState();
        try {
            graphics.translate(origin.x, origin.y);
            TimelineViewer timelineViewer = this.ganttViewer.getTimelineViewer();
            int height = timelineViewer.getCanvas().getSize().y;
            graphics.clipRect(new Rectangle(0, 0, end - start, height));
            graphics.setBackgroundColor(Colors.timeline());
            graphics.fillRectangle(new Rectangle(0, 0, end - start, height));
            graphics.translate(translateX, 0);
            List<IFigure> contents = this.getUsefulLayers(timelineViewer);
            for (IFigure content : contents) {
                content.paint(graphics);
            }
        }
        finally {
            graphics.popState();
        }
    }

    public void renderTaskTreeViewer(GC gc, Point origin, int start, int end) {
        this.renderTaskTreeViewer(gc, origin, start, end, null);
    }

    /*
     * Unable to fully structure code
     */
    private void renderTaskTreeViewer(GC gc, Point origin, int start, int end, Rectangle contentClip) {
        graphicsStack = new Stack<Graphics>();
        baseGraphics = new SWTGraphics(gc);
        graphicsStack.push((Graphics)baseGraphics);
        this.createGraphics((Graphics)baseGraphics, graphicsStack);
        graphics = graphicsStack.peek();
        try {
            if (contentClip != null) {
                graphics.clipRect(contentClip);
            }
            graphics.translate(origin.x, origin.y);
            taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            height = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            graphics.clipRect(new Rectangle(0, 0, end - start, height));
            graphics.translate(-start, 0);
            contents = this.getUsefulLayers(taskTreeViewer);
            for (IFigure content : contents) {
                content.paint(graphics);
            }
            graphics.setForegroundColor(Colors.split());
            widthSupport = this.ganttViewer.getWidthsSupport();
            i = 0;
            while (i < widthSupport.getSize()) {
                x = widthSupport.sum(i);
                graphics.drawLine(x, 0, x, height);
                ++i;
            }
            graphics.setForegroundColor(Colors.header());
            graphics.drawLine(end - 2, 0, end - 2, height);
            graphics.setForegroundColor(Colors.splitBar());
            graphics.drawLine(end - 1, 0, end - 1, height);
            if (true) ** GOTO lbl39
        }
        catch (Throwable var15_16) {
            ** while (!graphicsStack.isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            graphicsStack.pop().dispose();
            continue;
        }
lbl36:
        // 1 sources

        throw var15_16;
        do {
            graphicsStack.pop().dispose();
lbl39:
            // 2 sources

        } while (!graphicsStack.isEmpty());
    }

    public void renderTaskBarViewer(GC gc, Point origin, int start, int end) {
        this.renderTaskBarViewer(gc, origin, start, end, null);
    }

    /*
     * Unable to fully structure code
     */
    private void renderTaskBarViewer(GC gc, Point origin, int start, int end, Rectangle contentClip) {
        graphicsStack = new Stack<Graphics>();
        baseGraphics = new SWTGraphics(gc);
        graphicsStack.push((Graphics)baseGraphics);
        this.createGraphics((Graphics)baseGraphics, graphicsStack);
        graphics = graphicsStack.peek();
        try {
            if (contentClip != null) {
                graphics.clipRect(contentClip);
            }
            graphics.translate(origin.x, origin.y);
            taskBarViewer = this.ganttViewer.getTaskBarViewer();
            taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
            height = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
            graphics.clipRect(new Rectangle(0, 0, end - start, height));
            graphics.translate(-start, 0);
            contents = this.getUsefulLayers(taskBarViewer);
            for (IFigure content : contents) {
                content.paint(graphics);
            }
            if (true) ** GOTO lbl28
        }
        catch (Throwable var15_15) {
            ** while (!graphicsStack.isEmpty())
        }
lbl-1000:
        // 1 sources

        {
            graphicsStack.pop().dispose();
            continue;
        }
lbl25:
        // 1 sources

        throw var15_15;
        do {
            graphicsStack.pop().dispose();
lbl28:
            // 2 sources

        } while (!graphicsStack.isEmpty());
    }

    private List<IFigure> getUsefulLayers(GraphicalViewer viewer) {
        ArrayList<IFigure> figures = new ArrayList<IFigure>();
        if (viewer instanceof TimelineViewer) {
            figures.add((IFigure)viewer.getLayer(GEF.LAYER_CONTENTS));
        } else if (viewer instanceof TaskTreeViewer) {
            figures.add((IFigure)viewer.getLayer(TaskTreeViewer.LAYER_BACKGROUND_LINE));
            figures.add((IFigure)viewer.getLayer(GEF.LAYER_CONTENTS));
        } else if (viewer instanceof TaskBarViewer) {
            figures.add((IFigure)viewer.getLayer(TaskBarViewer.LAYER_BACKGROUND_SHADOW));
            figures.add((IFigure)viewer.getLayer(GEF.LAYER_CONTENTS));
            figures.add((IFigure)viewer.getLayer(TaskBarViewer.LAYER_DEPENDENCIES));
            figures.add((IFigure)viewer.getLayer(TaskBarViewer.LAYER_TIMELINE));
        }
        return figures;
    }

    protected void createGraphics(Graphics graphics, Stack<Graphics> stack) {
        if (this.bounds != null) {
            graphics.translate(-this.bounds.x, -this.bounds.y);
        }
        if (this.scale != 1.0) {
            graphics.scale(this.scale);
        }
    }

    protected void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected void setScale(double scale) {
        this.scale = scale;
    }

    protected double getScale() {
        return this.scale;
    }

    protected GanttViewer getGanttViewer() {
        return this.ganttViewer;
    }
}

