/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthEntry;

public class TaskTreeWidthsSupport {
    public static final String PreferenceStore_taskTreeWidths = "org.xmind.ui.gantt.taskTree.widths";
    public static final String Title_key = "Task";
    public static final String Start_key = "Start";
    public static final String End_key = "End";
    public static final String Assignee_key = "Assignee";
    public static final String Priority_key = "Priority";
    public static final String Progress_key = "Progress";
    private static final TaskTreeWidthEntry[] initEntrys = new TaskTreeWidthEntry[]{new TaskTreeWidthEntry("Task", 200), new TaskTreeWidthEntry("Start", 80), new TaskTreeWidthEntry("End", 80), new TaskTreeWidthEntry("Assignee", 80), new TaskTreeWidthEntry("Priority", 60), new TaskTreeWidthEntry("Progress", 60)};
    private List<TaskTreeWidthEntry> widths = new ArrayList<TaskTreeWidthEntry>();
    private List<PropertyChangeListener> propertyListeners;
    private List<PropertyChangeListener> itemsListeners;

    public TaskTreeWidthsSupport() {
        this.widths.clear();
        Collections.addAll(this.widths, this.getWidthEntries());
        this.refreshWidthEntries();
    }

    public TaskTreeWidthsSupport(TaskTreeWidthEntry[] entries) {
        this.widths.clear();
        Collections.addAll(this.widths, entries);
        this.refreshWidthEntries();
    }

    public void setWidth(int index, int value) {
        if (index < 0 || index >= this.widths.size()) {
            return;
        }
        TaskTreeWidthEntry entry = this.widths.get(index);
        if (entry.getWidth() != value) {
            int oldValue = entry.getWidth();
            entry.setWidth(value);
            this.refreshWidthEntries();
            this.firePropertyChange(index, oldValue, value);
        }
    }

    public int getWidth(int index) {
        if (index < 0 || index >= this.widths.size()) {
            return 0;
        }
        return this.widths.get(index).getWidth();
    }

    public String getKey(int index) {
        return this.widths.get(index).getKey();
    }

    public String getText(int index) {
        return TextEntry.getText(this.widths.get(index).getKey());
    }

    public int indexOf(String key) {
        int i = 0;
        while (i < this.widths.size()) {
            if (key == null && this.widths.get(i).getKey() == null || key != null && key.equals(this.widths.get(i).getKey())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int sum() {
        return this.sum(this.widths.size() - 1);
    }

    public int sum(int toIndex) {
        if (toIndex < 0) {
            return 0;
        }
        if (toIndex >= this.widths.size()) {
            toIndex = this.widths.size() - 1;
        }
        int sum = 0;
        int i = 0;
        while (i <= toIndex) {
            sum += this.widths.get(i).getWidth();
            ++i;
        }
        return sum;
    }

    public int getSize() {
        return this.widths.size();
    }

    public void setEntries(TaskTreeWidthEntry[] entries) {
        this.widths.clear();
        Collections.addAll(this.widths, entries);
        this.refreshWidthEntries();
        this.fireItemsChange();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList<PropertyChangeListener>();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    private void firePropertyChange(int index, int oldValue, int newValue) {
        if (oldValue != newValue && this.propertyListeners != null) {
            for (PropertyChangeListener listener : this.propertyListeners) {
                listener.propertyChange(new PropertyChangeEvent(this, new Integer(index).toString(), oldValue, newValue));
            }
        }
    }

    public void addItemsChangeListener(PropertyChangeListener listener) {
        if (this.itemsListeners == null) {
            this.itemsListeners = new ArrayList<PropertyChangeListener>();
        }
        this.itemsListeners.add(listener);
    }

    public void removeItemsChangeListener(PropertyChangeListener listener) {
        if (this.itemsListeners != null) {
            this.itemsListeners.remove(listener);
        }
    }

    private void fireItemsChange() {
        if (this.itemsListeners != null) {
            for (PropertyChangeListener listener : this.itemsListeners) {
                listener.propertyChange(new PropertyChangeEvent(this, null, null, null));
            }
        }
    }

    private void refreshWidthEntries() {
        if (this.widths == null || this.widths.size() == 0) {
            this.putWidthEntries(initEntrys);
        } else {
            this.putWidthEntries(this.widths.toArray(new TaskTreeWidthEntry[0]));
        }
    }

    private void putWidthEntries(TaskTreeWidthEntry[] entries) {
        String widthEntries = "";
        int i = 0;
        while (i < entries.length - 1) {
            TaskTreeWidthEntry entry = entries[i];
            widthEntries = String.valueOf(widthEntries) + entry.getKey() + "," + entry.getWidth() + ";";
            ++i;
        }
        TaskTreeWidthEntry entry = entries[entries.length - 1];
        widthEntries = String.valueOf(widthEntries) + entry.getKey() + "," + entry.getWidth();
        GanttPlugin.getDefault().getPreferenceStore().putValue(PreferenceStore_taskTreeWidths, widthEntries);
    }

    public TaskTreeWidthEntry[] getWidthEntries() {
        String[] parts;
        String widthEntries = GanttPlugin.getDefault().getPreferenceStore().getString(PreferenceStore_taskTreeWidths);
        if (widthEntries == null || "".equals(widthEntries)) {
            return initEntrys;
        }
        ArrayList<TaskTreeWidthEntry> entries = new ArrayList<TaskTreeWidthEntry>();
        String[] stringArray = parts = widthEntries.split(";");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            String[] entryStr = part.split(",");
            TaskTreeWidthEntry entry = new TaskTreeWidthEntry(entryStr[0], Integer.parseInt(entryStr[1]));
            entries.add(entry);
            ++n2;
        }
        return entries.toArray(new TaskTreeWidthEntry[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TextEntry {
        Title("Task", GanttMessages.TaskTree_Task),
        Start("Start", GanttMessages.TaskTree_Start),
        End("End", GanttMessages.TaskTree_End),
        Assignee("Assignee", GanttMessages.TaskTree_Assignee),
        Priority("Priority", GanttMessages.TaskTree_Priority),
        Progress("Progress", GanttMessages.TaskTree_Progress);

        private String key;
        private String text;

        private TextEntry(String key, String text) {
            this.key = key;
            this.text = text;
        }

        public String getText() {
            return this.text;
        }

        public static String getText(String key) {
            TextEntry[] textEntryArray = TextEntry.values();
            int n = textEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                TextEntry entry = textEntryArray[n2];
                if (entry.key.equals(key)) {
                    return entry.getText();
                }
                ++n2;
            }
            return "";
        }
    }
}

