/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.commands;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.ui.internal.InfoItemContributorManager;
import org.xmind.ui.mindmap.IInfoItemContributor;

public class ModifyInfoItemVisibilityCommand
extends ModifyCommand {
    private Map<String, String> defaultModes;
    private String type;

    public ModifyInfoItemVisibilityCommand(ISheet sheet, boolean visible, String type) {
        super((Object)sheet, (Object)visible);
        this.type = type;
        this.init();
    }

    private void init() {
        this.defaultModes = new HashMap<String, String>();
        List<IInfoItemContributor> cs = InfoItemContributorManager.getInstance().getBothContributors();
        for (IInfoItemContributor c : cs) {
            this.defaultModes.put(c.getId(), c.getDefaultMode());
        }
    }

    protected Object getValue(Object source) {
        if (source instanceof ISheet) {
            return this.isVisible((ISheet)source, this.type);
        }
        return null;
    }

    protected void setValue(Object source, Object value) {
        if (source instanceof ISheet && value instanceof Boolean) {
            this.setVisible((ISheet)source, (Boolean)value, this.type);
        }
    }

    private void setVisible(ISheet sheet, boolean visible, String type) {
        if (type == null || "".equals(type)) {
            return;
        }
        ISettingEntry entry = this.findEntry(sheet, type);
        if (visible != this.isVisible(entry, type)) {
            String modeValue;
            String string = modeValue = visible ? "card" : "icon";
            if (entry == null) {
                entry = sheet.getSettings().createEntry("info-items/info-item");
                entry.setAttribute("type", type);
                sheet.getSettings().addEntry(entry);
            }
            entry.setAttribute("mode", modeValue);
        }
    }

    private boolean isVisible(ISheet sheet, String type) {
        ISettingEntry entry = this.findEntry(sheet, type);
        return this.isVisible(entry, type);
    }

    private boolean isVisible(ISettingEntry entry, String type) {
        if (entry != null) {
            return "card".equals(entry.getAttribute("mode"));
        }
        return "card".equals(this.defaultModes.get(type));
    }

    private ISettingEntry findEntry(ISheet sheet, String type) {
        List entries = sheet.getSettings().getEntries("info-items/info-item");
        for (ISettingEntry entry : entries) {
            String t = entry.getAttribute("type");
            if (!type.equals(t)) continue;
            return entry;
        }
        return null;
    }
}

