/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.decoration.PathConnectionDecoration;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.ui.decorations.ISummaryDecoration;

public abstract class AbstractSummaryDecoration
extends PathConnectionDecoration
implements ISummaryDecoration,
IShadowedDecoration {
    private int direction = 16;
    private IAnchor conclusionAnchor = null;
    private PrecisionPoint conclusionPoint = null;

    protected AbstractSummaryDecoration() {
    }

    protected AbstractSummaryDecoration(String id) {
        super(id);
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(IFigure figure, int direction) {
        if (direction == this.direction) {
            return;
        }
        this.direction = direction;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    protected boolean isHorizontal() {
        return (this.getDirection() & 0x18) != 0;
    }

    @Override
    public IAnchor getNodeAnchor() {
        return this.conclusionAnchor;
    }

    @Override
    public void setNodeAnchor(IFigure figure, IAnchor anchor) {
        if (anchor == this.conclusionAnchor) {
            return;
        }
        this.conclusionAnchor = anchor;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
        this.invalidate();
    }

    public void invalidate() {
        super.invalidate();
        this.conclusionPoint = null;
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean validating) {
        PrecisionPoint oldConclusionPoint = this.conclusionPoint;
        PrecisionPoint newConclusionPoint = new PrecisionPoint();
        this.reroute(figure, sourcePos, targetPos, newConclusionPoint);
        this.conclusionPoint = newConclusionPoint;
        if (!validating && figure != null && !newConclusionPoint.equals((Object)oldConclusionPoint)) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, PrecisionPoint conclusionPoint) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        IAnchor ca = this.getNodeAnchor();
        if (sa != null) {
            sourcePos.setLocation(sa.getLocation(this.getDirection(), (double)this.getSpacing()));
        }
        if (ta != null) {
            targetPos.setLocation(ta.getLocation(this.getDirection(), (double)this.getSpacing()));
        }
        if (ca != null) {
            conclusionPoint.setLocation(ca.getLocation(AbstractSummaryDecoration.invertDirection(this.getDirection()), (double)this.getSpacing()));
        } else {
            double cx = (sourcePos.x + targetPos.x) / 2.0;
            double cy = (sourcePos.y + targetPos.y) / 2.0;
            switch (this.getDirection()) {
                case 1: {
                    conclusionPoint.setLocation(cx, cy - (double)this.getWidth());
                    break;
                }
                case 4: {
                    conclusionPoint.setLocation(cx, cy + (double)this.getWidth());
                    break;
                }
                case 16: {
                    conclusionPoint.setLocation(cx + (double)this.getWidth(), cy);
                    break;
                }
                case 8: {
                    conclusionPoint.setLocation(cx - (double)this.getWidth(), cy);
                }
            }
        }
    }

    protected static int invertDirection(int dir) {
        switch (dir) {
            case 1: {
                return 4;
            }
            case 4: {
                return 1;
            }
            case 16: {
                return 8;
            }
            case 8: {
                return 16;
            }
        }
        return dir;
    }

    protected int getSpacing() {
        return 5;
    }

    protected int getWidth() {
        return 20;
    }

    @Override
    public int getPreferredWidth(IFigure figure) {
        this.checkValidation(figure);
        int s = this.getSpacing();
        return this.getWidth() + s + s;
    }

    protected int getLineWidthForChecking() {
        return super.getLineWidthForChecking() * 2 + 10;
    }

    public PrecisionPoint getConclusionPoint(IFigure figure) {
        this.checkValidation(figure);
        return this.conclusionPoint;
    }

    protected boolean isPositionValid() {
        return super.isPositionValid() && this.conclusionPoint != null;
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        graphics.setAlpha(this.getAlpha());
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setLineWidth(this.getLineWidth());
        graphics.setLineStyle(this.getLineStyle());
        this.drawLine(figure, graphics);
    }
}

