/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.internal.expressions.Expressions;
import org.xmind.core.ITopic;
import org.xmind.ui.internal.CategoryAnalyzation;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.mindmap.ICategoryAnalyzation;
import org.xmind.ui.mindmap.ICategoryManager;

public class CategoryManager
implements ICategoryManager {
    private List<Category> categories = null;
    private String[] categoryIds = null;

    CategoryManager() {
    }

    @Override
    public ICategoryAnalyzation analyze(Object[] elements) {
        return new CategoryAnalyzation(elements, this);
    }

    @Override
    public String[] getAllCategories() {
        if (this.categoryIds == null) {
            this.ensureLoaded();
            int size = this.categories.size();
            this.categoryIds = new String[size];
            int i = 0;
            while (i < size) {
                this.categoryIds[i] = this.categories.get(i).getId();
                ++i;
            }
        }
        return this.categoryIds;
    }

    private void ensureLoaded() {
        if (this.categories != null) {
            return;
        }
        this.lazyLoad();
        if (this.categories == null) {
            this.categories = Collections.emptyList();
        }
    }

    private void lazyLoad() {
        this.register(new Category("org.xmind.ui.callout", "org.xmind.core.ITopic", "callout", MindMapMessages.Category_Callout));
        this.register(new Category("org.xmind.ui.summary", "org.xmind.core.ITopic", "summary", MindMapMessages.Category_Summary));
        this.register(new Category("org.xmind.ui.topic", "org.xmind.core.ITopic", "DEFAULTELEMENTTYPE", MindMapMessages.Category_Topic));
        this.register(new Category("org.xmind.ui.sheet", "org.xmind.core.ISheet", "DEFAULTELEMENTTYPE", MindMapMessages.Category_Sheet));
        this.register(new Category("org.xmind.ui.boundary", "org.xmind.core.IBoundary", "DEFAULTELEMENTTYPE", MindMapMessages.Category_Boundary));
        this.register(new Category("org.xmind.ui.relationship", "org.xmind.core.IRelationship", "DEFAULTELEMENTTYPE", MindMapMessages.Category_Relationship));
        this.register(new Category("org.xmind.ui.marker", "org.xmind.core.marker.IMarkerRef", "DEFAULTELEMENTTYPE", MindMapMessages.Category_Marker));
        this.register(new Category("org.xmind.ui.image", "org.xmind.core.IImage", "DEFAULTELEMENTTYPE", MindMapMessages.Category_Image));
    }

    private void register(Category category) {
        if (this.categories == null) {
            this.categories = new ArrayList<Category>();
        }
        this.categories.add(category);
    }

    @Override
    public String getCategoryName(String categoryId) {
        this.ensureLoaded();
        Category category = this.getCategory(categoryId);
        if (category != null) {
            return category.getName();
        }
        if ("multiple categories".equals(categoryId)) {
            return MindMapMessages.MultipleObjects;
        }
        if ("no category".equals(categoryId)) {
            return MindMapMessages.NoObject;
        }
        if ("unknown category".equals(categoryId)) {
            return MindMapMessages.UnknownObjects;
        }
        return "";
    }

    @Override
    public boolean belongsToCategory(Object element, String categoryId) {
        Category category = this.getCategory(categoryId);
        if (category != null) {
            return category.belongsToThisCategory(element);
        }
        return false;
    }

    private Category getCategory(String categoryId) {
        if (categoryId == null) {
            return null;
        }
        this.ensureLoaded();
        for (Category type : this.categories) {
            if (!categoryId.equals(type.getId())) continue;
            return type;
        }
        return null;
    }

    protected static class Category {
        static final String DEFAULT_TYPE = "DEFAULTELEMENTTYPE";
        private String id;
        private String objectClass;
        private String elementType;
        private String name;

        Category(String id, String objectClass, String elementType, String name) {
            this.id = id;
            this.objectClass = objectClass;
            this.name = name;
            this.elementType = elementType;
        }

        public String getElementType() {
            return this.elementType;
        }

        public String getId() {
            return this.id;
        }

        public String getObjectClazz() {
            return this.objectClass;
        }

        public boolean belongsToThisCategory(Object o) {
            boolean belongs = Expressions.isInstanceOf((Object)o, (String)this.objectClass);
            if (belongs && o instanceof ITopic) {
                belongs = belongs && ((ITopic)o).getType() != null && (((ITopic)o).getType().equals(this.elementType) || DEFAULT_TYPE.equals(this.elementType));
            }
            return belongs;
        }

        public String getName() {
            return this.name;
        }
    }
}

