/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.ZipOutputStream;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.internal.dom.MarkerResourceProvider;
import org.xmind.core.internal.zip.ZipStreamOutputTarget;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.util.ImageFormat;

public class MarkerImpExpUtils {
    private MarkerImpExpUtils() {
    }

    public static void exportMarkerPackage(List<IMarkerGroup> sourceGroups, String targetPath, boolean fileOrDirectory) throws IOException {
        Object target = fileOrDirectory ? new ZipStreamOutputTarget(new ZipOutputStream(new FileOutputStream(targetPath)), true) : new DirectoryOutputTarget(targetPath);
        IMarkerSheet targetSheet = Core.getMarkerSheetBuilder().createMarkerSheet((IMarkerResourceProvider)new MarkerResourceProvider(null, (IOutputTarget)target));
        for (IMarkerGroup group : sourceGroups) {
            targetSheet.importGroup(group);
        }
        try {
            try {
                targetSheet.save(target.getEntryStream("markerSheet.xml"));
            }
            catch (CoreException coreException) {
                throw new IOException();
            }
        }
        finally {
            if (target instanceof ZipStreamOutputTarget) {
                ((ZipStreamOutputTarget)target).close();
            }
        }
    }

    public static void importMarkerPackage(String sourcePath) throws IOException {
        try {
            if (new File(sourcePath).isDirectory()) {
                MindMapUI.getResourceManager().getUserMarkerSheet().importFrom(MarkerImpExpUtils.createImageFilesInputSource(sourcePath), new File(sourcePath).getName());
            } else {
                MindMapUI.getResourceManager().getUserMarkerSheet().importFrom(sourcePath);
            }
            MindMapUI.getResourceManager().saveUserMarkerSheet();
        }
        catch (CoreException coreException) {
            throw new IOException();
        }
    }

    private static IInputSource createImageFilesInputSource(String sourcePath) {
        DirectoryInputSource source = new DirectoryInputSource(sourcePath);
        source.setFilter((FileFilter)new ImageFileFilter());
        return source;
    }

    private static class ImageFileFilter
    implements FileFilter {
        private ImageFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            if (ImageFormat.findByExtension((String)FileUtils.getExtension((String)pathname.getAbsolutePath()), null) == null) {
                return false;
            }
            try {
                new Image((Device)Display.getCurrent(), pathname.getAbsolutePath()).dispose();
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
    }
}

