/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.HashMap;
import java.util.Map;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.graphicalpolicy.IStyleValueProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.branch.IBranchStyleSelector;
import org.xmind.ui.internal.branch.ParentValueProvider;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.style.MindMapStyleSelectorBase;
import org.xmind.ui.style.StyleUtils;

public abstract class AbstractBranchStyleSelector
extends MindMapStyleSelectorBase
implements IBranchStyleSelector {
    private Map<String, String> inheritedStyleKeys;

    protected void registerInheritedStyleKey(String key, String layer) {
        if (key == null) {
            return;
        }
        if (this.inheritedStyleKeys == null) {
            this.inheritedStyleKeys = new HashMap<String, String>();
        }
        this.inheritedStyleKeys.put(key, layer);
    }

    @Override
    public String getAutoValue(IGraphicalPart part, String key, IStyleValueProvider defaultValueProvider) {
        String familyName = this.getFamilyName(part);
        if (("line-color".equals(key) || "line-width".equals(key)) && ("mainTopic".equals(familyName) || "subTopic".equals(familyName) || "summaryTopic".equals(familyName)) && part instanceof IBranchPart) {
            String multiColor = "line-color".equals(key) ? StyleUtils.getIndexedBranchLineColor((IBranchPart)part) : null;
            String[] ancestorUserValueAndBranchType = this.getAncestorUserValueAndBranchType(part, key);
            String ancestorUserValue = ancestorUserValueAndBranchType[0];
            String ancestorBranchType = ancestorUserValueAndBranchType[1];
            if (this.isValidValue(part, key, multiColor) && "centralBranch".equals(ancestorBranchType)) {
                return multiColor;
            }
            if (this.isValidValue(part, key, ancestorUserValue)) {
                return ancestorUserValue;
            }
            if (this.isValidValue(part, key, multiColor)) {
                return multiColor;
            }
        }
        return super.getAutoValue(part, key, defaultValueProvider);
    }

    private String[] getAncestorUserValueAndBranchType(IGraphicalPart part, String key) {
        String[] ancestorUserValueAndBranchType = new String[2];
        if (!(part instanceof IBranchPart)) {
            return ancestorUserValueAndBranchType;
        }
        IBranchPart parentBranchPart = ((IBranchPart)part).getParentBranch();
        if (parentBranchPart == null) {
            return ancestorUserValueAndBranchType;
        }
        IStyleSelector styleSelector = parentBranchPart.getBranchPolicy().getStyleSelector(parentBranchPart);
        if (styleSelector == null) {
            return ancestorUserValueAndBranchType;
        }
        String parentUserValue = styleSelector.getUserValue((IGraphicalPart)parentBranchPart, key);
        if (this.isValidValue(parentBranchPart, key, parentUserValue)) {
            ancestorUserValueAndBranchType[0] = parentUserValue;
            ancestorUserValueAndBranchType[1] = parentBranchPart.getBranchType();
            return ancestorUserValueAndBranchType;
        }
        return this.getAncestorUserValueAndBranchType(parentBranchPart, key);
    }

    @Override
    protected String getThemeStyleValue(IGraphicalPart part, String familyName, String key) {
        String value;
        if (("line-color".equals(key) || "line-width".equals(key)) && ("mainTopic".equals(familyName) || "subTopic".equals(familyName) || "summaryTopic".equals(familyName)) && part instanceof IBranchPart && this.isValidValue(part, key, value = super.getThemeStyleValue(part, familyName, key))) {
            return value;
        }
        if (this.inheritedStyleKeys != null && this.inheritedStyleKeys.containsKey(key) && part instanceof IBranchPart && (value = ParentValueProvider.getValueProvider((IBranchPart)part).getParentValue(key)) != null) {
            return value;
        }
        return super.getThemeStyleValue(part, familyName, key);
    }

    @Override
    protected String getLayeredProperty(IGraphicalPart part, String layerName, String familyName, String key) {
        if (part instanceof IBranchPart && this.inheritedStyleKeys != null && layerName.equals(this.inheritedStyleKeys.get(key))) {
            String value = this.getLayeredProperty(part, "beforeParentValue", familyName, key);
            if (this.isValidValue(part, key, value)) {
                return this.getCheckedValue(value);
            }
            value = ParentValueProvider.getValueProvider((IBranchPart)part).getParentValue(key);
            if (this.isValidValue(part, key, value)) {
                return this.getCheckedValue(value);
            }
        }
        return null;
    }

    @Override
    public String getFamilyName(IGraphicalPart part) {
        if (part instanceof IBranchPart) {
            IBranchPart branch = (IBranchPart)part;
            String branchType = branch.getBranchType();
            if ("centralBranch".equals(branchType)) {
                return "centralTopic";
            }
            if ("mainBranch".equals(branchType)) {
                return "mainTopic";
            }
            if ("calloutBranch".equals(branchType)) {
                return "calloutTopic";
            }
            if ("floatingBranch".equals(branchType)) {
                return "floatingTopic";
            }
            if ("summaryBranch".equals(branchType)) {
                return "summaryTopic";
            }
        }
        return "subTopic";
    }

    @Override
    public void flushStyleCaches(IBranchPart branch) {
        ParentValueProvider.flush(branch);
    }
}

