/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.comments;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.TextViewerUndoManager;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CaretEvent;
import org.eclipse.swt.custom.CaretListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.xmind.core.IComment;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.commands.AddCommentCommand;
import org.xmind.ui.commands.DeleteCommentCommand;
import org.xmind.ui.commands.ModifyCommentCommand;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.comments.CommentsPopup;
import org.xmind.ui.internal.comments.CommentsSelectionProvider;
import org.xmind.ui.internal.comments.CommentsUtils;
import org.xmind.ui.internal.comments.ICommentTextViewerContainer;
import org.xmind.ui.internal.comments.ICommentsActionBarContributor;
import org.xmind.ui.internal.e4models.CommentsPart;
import org.xmind.ui.internal.spelling.SpellingPlugin;
import org.xmind.ui.internal.spellsupport.SpellingSupport;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.richtext.RichTextDamagerRepairer;
import org.xmind.ui.richtext.RichTextScanner;
import org.xmind.ui.texteditor.ISpellingActivation;
import org.xmind.ui.util.TextFormatter;

public class CommentTextViewer {
    private static final int EXTRA_WIDTH = 22;
    private static int DEFAULT_STYLE = 82;
    private Color originalColor;
    private Color hoverColor;
    private Color selectColor;
    private IComment comment;
    private String objectId;
    private IWorkbook workbook;
    private ICommentsActionBarContributor contributor;
    private ISelectionProvider selectionProvider;
    private ICommentTextViewerContainer container;
    private ISpellingActivation spellingActivation;
    private IPreferenceStore spellingPreferences;
    private boolean editable = (DEFAULT_STYLE & 8) == 0;
    private Composite control;
    private TextViewer textViewer;
    private MenuManager textContextMenuManager;
    private Menu textContextMenu;
    private IDocument document;
    private int textHeight = 17;
    private ICoreEventRegistration saveCommentReg;
    private MouseListener mouseListener;
    private ISelectionChangedListener selectionChangedListener;
    private FocusListener textFocusListener;
    private CaretListener caretListener;
    private ISelectionChangedListener postSelectionChangedListener;
    private IPropertyChangeListener propertyChangeListener;
    private ControlListener controlListener;
    private ITextListener textListener;
    private ModifyListener modifyListener;
    private IGraphicalEditor targetEditor;
    private StyleRange styleRange;
    private Label timeLabel;
    private Control modifyCommentActionBar;
    private boolean isLinkHovering;
    private Listener listener;
    private Menu contextMenu;
    private ResourceManager resources;

    public CommentTextViewer(IComment comment, String objectId, IWorkbook workbook, ICommentsActionBarContributor contributor, ISelectionProvider selectionProvider, ICommentTextViewerContainer container, IGraphicalEditor targetEditor) {
        this.comment = comment;
        this.objectId = objectId;
        this.workbook = workbook;
        this.contributor = contributor;
        this.selectionProvider = selectionProvider;
        this.container = container;
        this.targetEditor = targetEditor;
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)container.getContentComposite());
        this.initColors();
    }

    private void initColors() {
        if (this.container instanceof CommentsPopup) {
            this.originalColor = CommentsPopup.BG_COLOR;
            this.hoverColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f0f0f0"));
            this.selectColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#eaeaea"));
        } else if (this.container instanceof CommentsPart) {
            this.originalColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff"));
            this.hoverColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f9f9f9"));
            this.selectColor = (Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#f5f5f5"));
        }
    }

    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setBackground(parent.getBackground());
        this.control.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 7;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        this.control.setLayout((Layout)layout);
        this.createContentArea(this.control);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                CommentTextViewer.this.handleControlDispose(e);
            }
        });
        if (this.comment != null && this.comment == this.container.getEditingComment()) {
            this.startEditing();
            this.container.setModified(false);
            this.container.setEditingComment(null);
        }
        return this.control;
    }

    private void createContentArea(Composite parent) {
        if (this.comment == null) {
            this.createNullContentArea(parent);
        } else {
            this.createNotNullContentArea(parent);
        }
    }

    private void createNullContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        Composite marginComposite = new Composite(composite, 0);
        marginComposite.setBackground(parent.getBackground());
        marginComposite.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        marginComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 1;
        layout2.marginHeight = 1;
        marginComposite.setLayout((Layout)layout2);
        this.createNullTextControl(marginComposite);
        this.createAddCommentActionBar(composite);
        marginComposite.setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#298fca")));
    }

    private void createNullTextControl(Composite parent) {
        this.textViewer = this.createTextViewer(parent, DEFAULT_STYLE);
        this.initTextViewer(this.textViewer);
        this.setEditable(true);
        StyledText text = this.textViewer.getTextWidget();
        text.setBackground(parent.getDisplay().getSystemColor(1));
        text.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#000000")));
        text.setFont(JFaceResources.getDefaultFont());
        GridData gridData = new GridData(4, 128, true, true);
        gridData.horizontalIndent = 0;
        gridData.verticalIndent = 0;
        gridData.minimumHeight = 110;
        Document contentDocument = new Document(null);
        this.setDocument((IDocument)contentDocument);
        ScrolledComposite sc = this.container.getScrolledComposite();
        if (sc.getClientArea().width != 0) {
            gridData.widthHint = sc.getClientArea().width - 22;
        }
        text.setLayoutData((Object)gridData);
        sc.addControlListener(this.getControlListener());
        text.addModifyListener(this.getModifyListener());
        text.addFocusListener(this.getFocusListener());
        text.setFocus();
    }

    private void createAddCommentActionBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Action cancelAddCommentAction = new Action(){

            public void run() {
                CommentTextViewer.this.resetModified();
                CommentTextViewer.this.isLinkHovering = false;
                CommentTextViewer.this.container.cancelCreateComment();
            }
        };
        Hyperlink cancelLink = this.createLink(composite, MindMapMessages.Comment_Cancel_text, MindMapMessages.Comment_Cancel_tooltip, (IAction)cancelAddCommentAction);
        cancelLink.setLayoutData((Object)new GridData(16384, 128, true, false));
        Action addCommentAction = new Action(){

            public void run() {
                CommentTextViewer.this.addComment();
                MindMapUIPlugin.getDefault().getUsageDataCollector().increase("AddCommentCount");
            }
        };
        Hyperlink addLink = this.createLink(composite, MindMapMessages.AddCommentLink_text, MindMapMessages.AddCommentLink_tooltip, (IAction)addCommentAction);
        addLink.setLayoutData((Object)new GridData(131072, 128, true, false));
    }

    private Hyperlink createLink(Composite parent, String text, String toolTip, final IAction action) {
        final Hyperlink link = new Hyperlink(parent, 0);
        link.setBackground(link.getParent().getBackground());
        link.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#0082F9")));
        link.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().increaseHeight(1)));
        link.setText(text);
        link.setToolTipText(toolTip);
        link.setUnderlined(false);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                link.setUnderlined(true);
                CommentTextViewer.this.isLinkHovering = true;
            }

            public void linkExited(HyperlinkEvent e) {
                link.setUnderlined(false);
                CommentTextViewer.this.isLinkHovering = false;
            }

            public void linkActivated(HyperlinkEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            action.run();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        return link;
    }

    private void createNotNullContentArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 7;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        Composite composite2 = new Composite(composite, 0);
        composite2.setBackground(parent.getBackground());
        composite2.setLayoutData((Object)new GridData(768));
        GridLayout layout4 = new GridLayout(1, false);
        layout4.marginWidth = 10 - layout.marginWidth;
        layout4.marginHeight = 0;
        composite2.setLayout((Layout)layout4);
        Composite marginComposite = new Composite(composite2, 0);
        marginComposite.setBackground(parent.getBackground());
        marginComposite.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#ffffff")));
        marginComposite.setLayoutData((Object)new GridData(768));
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginWidth = 1;
        layout2.marginHeight = 1;
        marginComposite.setLayout((Layout)layout2);
        this.createNotNullTextControl(marginComposite);
        Composite composite3 = new Composite(parent, 0);
        composite3.setBackground(parent.getBackground());
        composite3.setLayoutData((Object)new GridData(768));
        GridLayout layout3 = new GridLayout(1, false);
        layout3.marginWidth = 10;
        layout3.marginHeight = 0;
        composite3.setLayout((Layout)layout3);
        this.createTimeLabel(composite3);
        this.createModifyCommentActionBar(composite3);
        this.modifyCommentActionBar.setVisible(false);
        ((GridData)this.modifyCommentActionBar.getLayoutData()).exclude = true;
        this.addMouseFilter();
        CommentsUtils.addRecursiveMouseListener((Control)this.control, this.getMouseListener(), null);
        this.addContextMenu();
        this.selectionProvider.addSelectionChangedListener(this.getSelectionChangedListener());
    }

    private void createNotNullTextControl(Composite parent) {
        this.textViewer = this.createTextViewer(parent, DEFAULT_STYLE);
        this.initTextViewer(this.textViewer);
        this.setEditable(false);
        StyledText text = this.textViewer.getTextWidget();
        text.setBackground(parent.getBackground());
        text.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#45464a")));
        text.setFont(JFaceResources.getDefaultFont());
        GridData gridData = new GridData(4, 128, true, true);
        gridData.minimumHeight = 22;
        String author = String.valueOf(this.comment.getAuthor()) + " : ";
        String commentContent = this.comment.getContent();
        Document contentDocument = new Document(String.valueOf(author) + commentContent);
        this.setDocument((IDocument)contentDocument);
        this.styleRange = new StyleRange();
        this.styleRange.start = 0;
        this.styleRange.length = author.lastIndexOf(58);
        this.styleRange.foreground = null;
        this.styleRange.background = null;
        this.styleRange.fontStyle = 1;
        text.setStyleRange(this.styleRange);
        ScrolledComposite sc = this.container.getScrolledComposite();
        if (sc.getClientArea().width != 0) {
            gridData.widthHint = sc.getClientArea().width - 22;
        }
        text.setLayoutData((Object)gridData);
        sc.addControlListener(this.getControlListener());
        text.addModifyListener(this.getModifyListener());
        text.addFocusListener(this.getFocusListener());
    }

    private void createTimeLabel(Composite parent) {
        this.timeLabel = new Label(parent, 0);
        this.timeLabel.setAlignment(16384);
        this.timeLabel.setBackground(parent.getBackground());
        this.timeLabel.setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#999999")));
        this.timeLabel.setFont((Font)this.resources.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().increaseHeight(-1)));
        GridData layoutData = new GridData(4, 128, true, false);
        layoutData.horizontalIndent = 3;
        layoutData.verticalIndent = 0;
        this.timeLabel.setLayoutData((Object)layoutData);
        if (this.comment != this.container.getLatestCreatedComment()) {
            long timeMillisString = this.comment.getTime();
            String dateString = TextFormatter.formatTimeMillis((long)timeMillisString, (String)"yyyy-MM-dd");
            String timeString = TextFormatter.formatTimeMillis((long)timeMillisString, (String)"HH:mm");
            this.timeLabel.setText(String.valueOf(dateString) + " at " + timeString);
        } else {
            this.container.setLatestCreatedComment(null);
            this.timeLabel.setText(MindMapMessages.Comment_JustNow_text);
        }
    }

    private void createModifyCommentActionBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(768);
        layoutData.verticalIndent = 5;
        composite.setLayoutData((Object)layoutData);
        composite.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Action cancelModifyAction = new Action(){

            public void run() {
                CommentTextViewer.this.cancelEditing();
            }
        };
        Hyperlink cancelLink = this.createLink(composite, MindMapMessages.Comment_Cancel_text, MindMapMessages.Comment_Cancel_tooltip, (IAction)cancelModifyAction);
        cancelLink.setLayoutData((Object)new GridData(16384, 128, true, false));
        Action modifyCommentAction = new Action(){

            public void run() {
                CommentTextViewer.this.saveComment();
            }
        };
        Hyperlink addLink = this.createLink(composite, MindMapMessages.ModifyComment_text, MindMapMessages.ModifyComment_tooltip, (IAction)modifyCommentAction);
        addLink.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.modifyCommentActionBar = composite;
    }

    private void addContextMenu() {
        this.setRecursionContextMenu((Control)this.control, this.getContextMenu());
    }

    private void removeContextMenu() {
        this.setRecursionContextMenu((Control)this.control, null);
    }

    private void setRecursionContextMenu(Control control, Menu contextMenu) {
        if (control != null && !control.isDisposed()) {
            control.setMenu(contextMenu);
        }
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setRecursionContextMenu(child, contextMenu);
                ++n2;
            }
        }
    }

    private Menu getContextMenu() {
        if (this.contextMenu == null || this.contextMenu.isDisposed()) {
            MenuManager menuManager = new MenuManager();
            menuManager.add((IAction)new Action(MindMapMessages.Comment_Edit_label){

                public void run() {
                    CommentTextViewer.this.startEditing();
                }
            });
            menuManager.add((IAction)new Action(MindMapMessages.Comment_Delete_label){

                public void run() {
                    DeleteCommentCommand cmd = new DeleteCommentCommand(CommentTextViewer.this.comment.getOwnedWorkbook().getElementById(CommentTextViewer.this.comment.getObjectId()), CommentTextViewer.this.comment);
                    ICommandStack cs = CommentTextViewer.this.targetEditor.getCommandStack();
                    cs.execute((Command)cmd);
                }
            });
            menuManager.add((IAction)new Action(MindMapMessages.Comment_Reply_label){

                public void run() {
                    CommentTextViewer.this.container.createComment(CommentTextViewer.this.comment.getObjectId());
                }
            });
            this.contextMenu = menuManager.createContextMenu((Control)this.control.getShell());
        }
        return this.contextMenu;
    }

    private TextViewer createTextViewer(Composite parent, int style) {
        return new LessLatencyTextViewer(parent, style);
    }

    private void initTextViewer(TextViewer textViewer) {
        StyledText control = textViewer.getTextWidget();
        this.createContentPopupMenu((Control)control);
        textViewer.setTextDoubleClickStrategy((ITextDoubleClickStrategy)new DefaultTextDoubleClickStrategy(), "__dftl_partition_content_type");
        textViewer.setUndoManager((IUndoManager)new TextViewerUndoManager(25));
        textViewer.activatePlugins();
        this.addHyperlinkListener(textViewer);
    }

    private void createContentPopupMenu(Control control) {
        this.textContextMenuManager = new MenuManager();
        this.textContextMenuManager.setRemoveAllWhenShown(true);
        this.textContextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CommentTextViewer.this.fillContextMenu(manager);
            }
        });
        this.textContextMenu = this.textContextMenuManager.createContextMenu(control);
        control.setMenu(this.textContextMenu);
    }

    private void fillContextMenu(IMenuManager menu) {
        if (this.contributor != null) {
            this.contributor.fillContextMenu(menu);
        }
    }

    private void addHyperlinkListener(TextViewer viewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        RichTextDamagerRepairer dr = new RichTextDamagerRepairer((ITokenScanner)new RichTextScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDocumentPartitioning("__dftl_partitioning");
        reconciler.install((ITextViewer)viewer);
    }

    private void addMouseFilter() {
        Display.getCurrent().addFilter(6, this.getListener());
        Display.getCurrent().addFilter(7, this.getListener());
    }

    private void removeMouseFilter() {
        Display.getCurrent().removeFilter(6, this.getListener());
        Display.getCurrent().removeFilter(7, this.getListener());
    }

    private Listener getListener() {
        if (this.listener == null) {
            this.listener = new Listener(){

                public void handleEvent(Event event) {
                    if (CommentTextViewer.this.control.isDisposed()) {
                        CommentTextViewer.this.removeMouseFilter();
                        return;
                    }
                    if (event.widget instanceof Control) {
                        boolean isAncestor = CommentTextViewer.this.isAncestorOf((Control)CommentTextViewer.this.control, (Control)event.widget);
                        switch (event.type) {
                            case 6: {
                                if (!isAncestor) break;
                                CommentTextViewer.this.setRecursiveBackgroundColor((Control)CommentTextViewer.this.control, CommentTextViewer.this.hoverColor, null);
                                CommentTextViewer.this.control.layout();
                                break;
                            }
                            case 7: {
                                if (isAncestor) break;
                                if (CommentTextViewer.this.textViewer.getTextWidget().isFocusControl()) {
                                    CommentTextViewer.this.setRecursiveBackgroundColor((Control)CommentTextViewer.this.control, CommentTextViewer.this.originalColor, (Control)CommentTextViewer.this.getTextWidget());
                                } else {
                                    CommentTextViewer.this.setRecursiveBackgroundColor((Control)CommentTextViewer.this.control, CommentTextViewer.this.originalColor, null);
                                }
                                CommentTextViewer.this.control.layout();
                            }
                        }
                    }
                }
            };
        }
        return this.listener;
    }

    private boolean isAncestorOf(Control composite, Control control) {
        if (control == composite) {
            return true;
        }
        Composite parent = control.getParent();
        while (parent != null && parent != composite && !(parent instanceof Shell)) {
            parent = parent.getParent();
        }
        return parent == composite;
    }

    private void setRecursiveBackgroundColor(Control control, Color background, Control excludeControl) {
        if (control == excludeControl) {
            return;
        }
        control.setBackground(background);
        if (control instanceof Composite) {
            Control[] children;
            Control[] controlArray = children = ((Composite)control).getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setRecursiveBackgroundColor(child, background, excludeControl);
                ++n2;
            }
        }
    }

    private MouseListener getMouseListener() {
        if (this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (CommentTextViewer.this.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)CommentTextViewer.this.getSelection()).getFirstElement() == CommentTextViewer.this) {
                        if (e.button == 1) {
                            CommentTextViewer.this.selectionProvider.removeSelectionChangedListener(CommentTextViewer.this.getSelectionChangedListener());
                            CommentTextViewer.this.setSelection(null);
                            CommentTextViewer.this.selectionProvider.addSelectionChangedListener(CommentTextViewer.this.getSelectionChangedListener());
                            CommentTextViewer.this.startEditing();
                        }
                    } else {
                        CommentTextViewer.this.setSelection((ISelection)new StructuredSelection((Object)CommentTextViewer.this));
                    }
                }
            };
        }
        return this.mouseListener;
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        if (this.selectionChangedListener == null) {
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Object obj;
                    ISelection selection;
                    Object obj2;
                    ISelection oldSelection = ((CommentsSelectionProvider)CommentTextViewer.this.selectionProvider).getOldSelection();
                    if (oldSelection instanceof IStructuredSelection && (obj2 = ((IStructuredSelection)oldSelection).getFirstElement()) == CommentTextViewer.this && !CommentTextViewer.this.getTextWidget().isFocusControl()) {
                        ((CommentTextViewer)obj2).commentDeselected();
                    }
                    if ((selection = event.getSelection()) instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) == CommentTextViewer.this) {
                        CommentTextViewer.this.commentSelected();
                    }
                }
            };
        }
        return this.selectionChangedListener;
    }

    private void commentSelected() {
        this.removeMouseFilter();
        this.setRecursiveBackgroundColor((Control)this.control, this.selectColor, null);
        this.container.getContentComposite().pack();
        this.container.getContentComposite().layout(true, true);
    }

    private void commentDeselected() {
        this.addMouseFilter();
        if (this.textViewer.getTextWidget().isFocusControl()) {
            this.setRecursiveBackgroundColor((Control)this.control, this.originalColor, (Control)this.getTextWidget());
        } else {
            this.setRecursiveBackgroundColor((Control)this.control, this.originalColor, null);
        }
        this.container.getContentComposite().pack();
        this.container.getContentComposite().layout(true, true);
    }

    private FocusListener getFocusListener() {
        if (this.textFocusListener == null) {
            this.textFocusListener = new FocusListener(){

                public void focusGained(FocusEvent e) {
                    CommentTextViewer.this.textViewer.getTextWidget().setBackground(e.display.getSystemColor(1));
                    CommentTextViewer.this.getTextWidget().addCaretListener(CommentTextViewer.this.getCaretListener());
                    CommentTextViewer.this.getTextViewer().addTextListener(CommentTextViewer.this.getTextListener());
                    CommentTextViewer.this.getTextViewer().addPostSelectionChangedListener(CommentTextViewer.this.getPostSelectionChangedListener());
                    CommentTextViewer.this.addSpellChecker((ITextViewer)CommentTextViewer.this.textViewer);
                    CommentTextViewer.this.showControl();
                    CommentTextViewer.this.updateActions();
                    CommentTextViewer.this.container.setSelectedComment(CommentTextViewer.this.comment);
                }

                public void focusLost(FocusEvent e) {
                    CommentTextViewer.this.textViewer.getTextWidget().setBackground(CommentTextViewer.this.originalColor);
                    CommentTextViewer.this.getTextWidget().removeCaretListener(CommentTextViewer.this.getCaretListener());
                    CommentTextViewer.this.getTextViewer().removePostSelectionChangedListener(CommentTextViewer.this.getPostSelectionChangedListener());
                    CommentTextViewer.this.setEditable(false);
                    CommentTextViewer.this.removeSpellChecker();
                    CommentTextViewer.this.container.setSelectedComment(null);
                    if (!CommentTextViewer.this.isLinkHovering) {
                        if (CommentTextViewer.this.comment == null) {
                            CommentTextViewer.this.addComment();
                            CommentTextViewer.this.container.setModified(true);
                        } else {
                            boolean modified = CommentTextViewer.this.saveComment();
                            CommentTextViewer.this.container.setModified(modified);
                        }
                    }
                }
            };
        }
        return this.textFocusListener;
    }

    private void startEditing() {
        this.container.getContentComposite().forceFocus();
        if (this.container.isModified()) {
            this.container.setModified(false);
            this.container.setEditingComment(this.comment);
            return;
        }
        if (this.control.isDisposed()) {
            return;
        }
        this.removeMouseFilter();
        this.setRecursiveBackgroundColor((Control)this.control, this.originalColor, null);
        this.getTextWidget().setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#000000")));
        this.getTextWidget().getParent().setBackground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#298fca")));
        CommentsUtils.removeRecursiveMouseListener((Control)this.control, this.getMouseListener(), null);
        this.removeContextMenu();
        this.textViewer.getControl().setMenu(this.textContextMenu);
        this.textViewer.getTextWidget().setStyleRange(null);
        String commentContent = this.comment.getContent();
        Document contentDocument = new Document(commentContent);
        this.setDocument((IDocument)contentDocument);
        this.timeLabel.setVisible(false);
        ((GridData)this.timeLabel.getLayoutData()).exclude = true;
        this.modifyCommentActionBar.setVisible(true);
        ((GridData)this.modifyCommentActionBar.getLayoutData()).exclude = false;
        ((GridData)this.textViewer.getControl().getLayoutData()).minimumHeight = 110;
        this.setEditable(true);
        this.textViewer.getControl().setFocus();
        this.container.getContentComposite().pack();
        this.container.getContentComposite().layout(true, true);
    }

    private void cancelEditing() {
        this.setRecursiveBackgroundColor((Control)this.control, this.originalColor, null);
        this.getTextWidget().setForeground((Color)this.resources.get((DeviceResourceDescriptor)ColorUtils.toDescriptor((String)"#45464a")));
        CommentsUtils.addRecursiveMouseListener((Control)this.control, this.getMouseListener(), null);
        this.addContextMenu();
        String author = String.valueOf(this.comment.getAuthor()) + " : ";
        String commentContent = this.comment.getContent();
        Document contentDocument = new Document(String.valueOf(author) + commentContent);
        this.setDocument((IDocument)contentDocument);
        this.textViewer.getTextWidget().setStyleRange(this.styleRange);
        this.resetModified();
        this.timeLabel.setVisible(true);
        ((GridData)this.timeLabel.getLayoutData()).exclude = false;
        this.modifyCommentActionBar.setVisible(false);
        ((GridData)this.modifyCommentActionBar.getLayoutData()).exclude = true;
        ((GridData)this.textViewer.getControl().getLayoutData()).minimumHeight = 22;
        this.setEditable(false);
        this.addMouseFilter();
        if (this.container != null && this.container.getContentComposite() != null && !this.container.getContentComposite().isDisposed()) {
            this.container.getContentComposite().pack();
            this.container.getContentComposite().layout(true, true);
        }
    }

    private void showControl() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!CommentTextViewer.this.container.getScrolledComposite().isDisposed() && !CommentTextViewer.this.control.isDisposed()) {
                    CommentTextViewer.this.container.getScrolledComposite().showControl((Control)CommentTextViewer.this.control);
                }
            }
        });
    }

    private void updateActions() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (CommentTextViewer.this.control.isDisposed() || CommentTextViewer.this.getTextWidget().isDisposed()) {
                    return;
                }
                IComment selectedComment = CommentTextViewer.this.control.isFocusControl() || CommentTextViewer.this.getTextWidget().isFocusControl() ? CommentTextViewer.this.comment : null;
                CommentTextViewer.this.contributor.selectedCommentChanged(selectedComment);
            }
        });
    }

    private void addSpellChecker(ITextViewer textViewer) {
        this.spellingActivation = SpellingSupport.getInstance().activateSpelling(textViewer);
        this.spellingPreferences = SpellingPlugin.getDefault().getPreferenceStore();
        if (this.spellingPreferences != null) {
            this.spellingPreferences.addPropertyChangeListener(this.getPropertyChangeListener());
        }
        this.contributor.setSpellingActivation(this.spellingActivation);
    }

    private void removeSpellChecker() {
        if (this.spellingPreferences != null) {
            this.spellingPreferences.removePropertyChangeListener(this.getPropertyChangeListener());
            this.spellingPreferences = null;
        }
        if (this.spellingActivation != null) {
            this.spellingActivation.getSpellingSupport().deactivateSpelling(this.spellingActivation);
            this.spellingActivation = null;
        }
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("SPELLING_CHECK_ENABLED".equals(event.getProperty())) {
                        if (CommentTextViewer.this.spellingActivation != null) {
                            CommentTextViewer.this.spellingActivation.getSpellingSupport().deactivateSpelling(CommentTextViewer.this.spellingActivation);
                            CommentTextViewer.this.spellingActivation = null;
                        }
                        if (CommentTextViewer.this.spellingPreferences.getBoolean("SPELLING_CHECK_ENABLED")) {
                            CommentTextViewer.this.spellingActivation = SpellingSupport.getInstance().activateSpelling((ITextViewer)CommentTextViewer.this.textViewer);
                        }
                    }
                }
            };
        }
        return this.propertyChangeListener;
    }

    private CaretListener getCaretListener() {
        if (this.caretListener == null) {
            this.caretListener = new CaretListener(){

                public void caretMoved(CaretEvent event) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (CommentTextViewer.this.getTextWidget() == null || CommentTextViewer.this.getTextWidget().isDisposed()) {
                                return;
                            }
                            Caret caret = CommentTextViewer.this.getTextWidget().getCaret();
                            ScrolledComposite sc = CommentTextViewer.this.container.getScrolledComposite();
                            Rectangle caretBounds = caret.getBounds();
                            Rectangle scClientArea = sc.getClientArea();
                            int caretToDisplayY = ((CommentTextViewer)(this).CommentTextViewer.this).getTextWidget().toDisplay((Point)caret.getLocation()).y;
                            Point scToDisplayPoint = sc.getParent().toDisplay(sc.getLocation());
                            int scToDisplayY = scToDisplayPoint.y;
                            Point scOrigin = sc.getOrigin();
                            if (caretToDisplayY + caretBounds.height > scToDisplayY + scClientArea.height) {
                                scOrigin.y += caretToDisplayY + caretBounds.height - (scToDisplayY + scClientArea.height);
                                sc.setOrigin(scOrigin);
                            } else if (caretToDisplayY < scToDisplayY) {
                                scOrigin.y -= scToDisplayY - caretToDisplayY;
                                sc.setOrigin(scOrigin);
                            }
                        }
                    });
                }
            };
        }
        return this.caretListener;
    }

    private ISelectionChangedListener getPostSelectionChangedListener() {
        if (this.postSelectionChangedListener == null) {
            this.postSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CommentTextViewer.this.contributor.update(CommentTextViewer.this.textViewer);
                }
            };
        }
        return this.postSelectionChangedListener;
    }

    private ControlListener getControlListener() {
        if (this.controlListener == null) {
            this.controlListener = new ControlListener(){

                public void controlMoved(ControlEvent e) {
                }

                public void controlResized(ControlEvent e) {
                    if (CommentTextViewer.this.container == null || CommentTextViewer.this.container.getContentComposite().isDisposed()) {
                        return;
                    }
                    Composite contentComposite = CommentTextViewer.this.container.getContentComposite();
                    StyledText text = CommentTextViewer.this.getTextWidget();
                    if (text != null && !text.isDisposed()) {
                        ((GridData)text.getLayoutData()).widthHint = contentComposite.getParent().getClientArea().width - 22;
                    }
                }
            };
        }
        return this.controlListener;
    }

    private ITextListener getTextListener() {
        if (this.textListener == null) {
            this.textListener = new ITextListener(){

                public void textChanged(TextEvent event) {
                    CommentTextViewer.this.activateJob();
                }
            };
        }
        return this.textListener;
    }

    private ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent event) {
                    Composite contentComposite = CommentTextViewer.this.container.getContentComposite();
                    int realTextlHeight = contentComposite.computeSize((int)-1, (int)-1).y;
                    if (CommentTextViewer.this.textHeight != realTextlHeight) {
                        CommentTextViewer.this.textHeight = realTextlHeight;
                        contentComposite.pack();
                    }
                }
            };
        }
        return this.modifyListener;
    }

    private void activateJob() {
        if (this.saveCommentReg != null && this.saveCommentReg.isValid()) {
            return;
        }
        this.saveCommentReg = null;
        if (this.workbook instanceof ICoreEventSource2) {
            this.saveCommentReg = ((ICoreEventSource2)this.workbook).registerOnceCoreEventListener("workbookPreSaveOnce", ICoreEventListener.NULL);
        }
    }

    private void deactivateJob() {
        if (this.saveCommentReg != null) {
            this.saveCommentReg.unregister();
            this.saveCommentReg = null;
        }
    }

    private void resetModified() {
        this.deactivateJob();
        this.getTextViewer().removeTextListener(this.getTextListener());
    }

    private void handleControlDispose(DisposeEvent e) {
        if (this.textContextMenuManager != null) {
            this.textContextMenuManager.dispose();
            this.textContextMenuManager = null;
        }
        if (this.textContextMenu != null) {
            this.textContextMenu.dispose();
            this.textContextMenu = null;
        }
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.document != null) {
            this.document = null;
        }
        this.removeMouseFilter();
        this.getTextWidget().removeFocusListener(this.getFocusListener());
        ScrolledComposite sc = this.container.getScrolledComposite();
        if (sc != null && !sc.isDisposed()) {
            sc.removeControlListener(this.getControlListener());
        }
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener(this.getSelectionChangedListener());
        }
        this.getTextWidget().removeModifyListener(this.getModifyListener());
    }

    private boolean addComment() {
        this.resetModified();
        this.isLinkHovering = false;
        IDocument document = (IDocument)this.textViewer.getInput();
        if (document == null || document.get() == null || document.get().equals("")) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CommentTextViewer.this.container.cancelCreateComment();
                }
            });
            return false;
        }
        String author = System.getProperty("org.xmind.author.name");
        author = author != null ? author : System.getProperty("user.name");
        long time = System.currentTimeMillis();
        IComment comment = this.workbook.getCommentManager().createComment(author, time, this.objectId);
        final AddCommentCommand cmd = new AddCommentCommand(author, time, this.objectId, document.get(), this.workbook, comment);
        this.container.setLatestCreatedComment(comment);
        final ICommandStack cs = this.targetEditor.getCommandStack();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                cs.execute((Command)cmd);
            }
        });
        return true;
    }

    private boolean saveComment() {
        MindMapUIPlugin.getDefault().getUsageDataCollector().increase("AddCommentCount");
        this.resetModified();
        this.isLinkHovering = false;
        String oldContent = this.comment == null ? null : this.comment.getContent();
        IDocument document = this.textViewer.getDocument();
        String newContent = document.get();
        if (newContent != null && newContent.equals(oldContent)) {
            this.cancelEditing();
            return false;
        }
        final ICommandStack cs = this.targetEditor.getCommandStack();
        Object command = null;
        command = document == null || document.get() == null || document.get().equals("") ? new DeleteCommentCommand(this.comment.getOwnedWorkbook().getElementById(this.comment.getObjectId()), this.comment) : new ModifyCommentCommand(this.comment.getOwnedWorkbook().getElementById(this.comment.getObjectId()), this.comment, document.get());
        DeleteCommentCommand command_0 = command;
        Display.getCurrent().asyncExec(new Runnable((Command)command_0){
            private final /* synthetic */ Command val$command_0;
            {
                this.val$command_0 = command;
            }

            @Override
            public void run() {
                cs.execute(this.val$command_0);
            }
        });
        return true;
    }

    private void setEditable(boolean editable) {
        if (editable == this.editable) {
            return;
        }
        this.editable = editable;
        this.updateTextControl();
    }

    private void setDocument(IDocument document) {
        this.document = document;
        this.textViewer.setDocument((IDocument)(document == null ? new Document() : document));
        this.updateTextControl();
        if (document != null) {
            this.textViewer.setSelectedRange(document.getLength(), 0);
        }
    }

    private void updateTextControl() {
        this.textViewer.setEditable(this.editable);
        if (this.textViewer.getTextWidget() != null && !this.textViewer.getTextWidget().isDisposed()) {
            this.textViewer.getTextWidget().setEnabled(this.editable);
        }
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    private StyledText getTextWidget() {
        return this.textViewer.getTextWidget();
    }

    private ISelection getSelection() {
        return this.selectionProvider.getSelection();
    }

    private void setSelection(ISelection selection) {
        this.selectionProvider.setSelection(selection);
    }

    public void setTargetEditor(IGraphicalEditor targetEditor) {
        this.targetEditor = targetEditor;
    }

    private static class LessLatencyTextViewer
    extends TextViewer {
        private LessLatencyTextViewer(Composite parent, int styles) {
            super(parent, styles);
        }

        protected int getEmptySelectionChangedEventDelay() {
            return 100;
        }
    }
}

