/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.dnd;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.dnd.TransferData;
import org.xmind.core.IBoundary;
import org.xmind.core.IImage;
import org.xmind.core.IRange;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.ITopicRange;
import org.xmind.core.IWorkbook;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ModifyCommand;
import org.xmind.gef.dnd.IDndClient;
import org.xmind.gef.part.IPart;
import org.xmind.ui.commands.AddBoundaryCommand;
import org.xmind.ui.commands.AddMarkerCommand;
import org.xmind.ui.commands.AddRelationshipCommand;
import org.xmind.ui.commands.AddTopicCommand;
import org.xmind.ui.commands.DeleteMarkerCommand;
import org.xmind.ui.commands.ModifyFoldedCommand;
import org.xmind.ui.commands.ModifyImageAlignmentCommand;
import org.xmind.ui.commands.ModifyImageSizeCommand;
import org.xmind.ui.commands.ModifyImageSourceCommand;
import org.xmind.ui.commands.ModifyRangeCommand;
import org.xmind.ui.commands.ModifyRightNumberOfUnbalancedStructureCommand;
import org.xmind.ui.commands.ModifyTopicHyperlinkCommand;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.util.MindMapUtils;

public abstract class MindMapDNDClientBase
implements IDndClient {
    public final Object[] toViewerElements(Object transferData, IViewer viewer, Object target) {
        return null;
    }

    public Command makeDNDCommand(Object transferredData, Request request) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return null;
        }
        ISheet sheet = (ISheet)viewer.getAdapter(ISheet.class);
        if (sheet == null) {
            return null;
        }
        IWorkbook workbook = sheet.getOwnedWorkbook();
        IPart parent = (IPart)request.getParameter("parent");
        if (parent != null || request.getTargets().size() == 1) {
            boolean dropInParent = request.getTargets().contains(parent);
            if (parent == null) {
                parent = request.getPrimaryTarget();
            }
            ITopic targetParent = this.findTargetParentTopic(viewer, parent);
            return this.makeDNDCommand(transferredData, request, workbook, targetParent, dropInParent, request.getParameter("parent") == null);
        }
        if (!request.getTargets().isEmpty()) {
            ArrayList<Command> commands = new ArrayList<Command>();
            for (IPart target : request.getTargets()) {
                ITopic targetParent = this.findTargetParentTopic(viewer, target);
                if (targetParent == null) continue;
                commands.add(this.makeDNDCommand(transferredData, request, workbook, targetParent, false, false));
            }
            return new CompoundCommand(commands);
        }
        return null;
    }

    private ITopic findTargetParentTopic(IViewer viewer, IPart parent) {
        Object targetParentModel = MindMapUtils.getRealModel(parent);
        ITopic targetParent = targetParentModel == null || !(targetParentModel instanceof ITopic) ? (ITopic)viewer.getAdapter(ITopic.class) : (ITopic)targetParentModel;
        return targetParent;
    }

    protected Command makeDNDCommand(Object transferData, Request request, IWorkbook workbook, ITopic targetParent, boolean dropInParent, boolean floating) {
        Object[] elements = this.toViewerElements(transferData, request, workbook, targetParent, dropInParent);
        if (elements == null || elements.length == 0) {
            return null;
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        this.makeDNDCommands(request, workbook, targetParent, elements, commands, floating, dropInParent);
        return new CompoundCommand(commands);
    }

    protected void makeDNDCommands(Request request, IWorkbook workbook, ITopic targetParent, Object[] elements, List<Command> commands, boolean floating, boolean dropInParent) {
        int index;
        ISheet sheet = (ISheet)request.getTargetViewer().getAdapter(ISheet.class);
        int sourceIndex = index = request.getIntParameter("index", -1);
        Point position = (Point)request.getParameter("position");
        int countForUnbalacedStructure = 0;
        this.preAdded(targetParent, commands);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Command) {
                commands.add((Command)element);
            } else if (element instanceof ITopic) {
                if (targetParent != null) {
                    ITopic topic = (ITopic)element;
                    if (floating && position != null) {
                        topic.setPosition(position.x, position.y);
                        commands.add((Command)new AddTopicCommand(topic, targetParent, -1, "detached"));
                    } else {
                        countForUnbalacedStructure = this.modifyRightNumeberForUnbalancedStructure(request, targetParent, countForUnbalacedStructure);
                        topic.setPosition(null);
                        commands.add((Command)new AddTopicCommand(topic, targetParent, index, "attached"));
                        if (index >= 0) {
                            ++index;
                        }
                    }
                }
            } else if (element instanceof IRelationship) {
                if (sheet != null) {
                    IRelationship relationship = (IRelationship)element;
                    commands.add((Command)new AddRelationshipCommand(relationship, sheet));
                }
            } else if (element instanceof IBoundary) {
                if (targetParent != null) {
                    IBoundary boundary = (IBoundary)element;
                    commands.add((Command)new AddBoundaryCommand(boundary, targetParent));
                }
            } else if (element instanceof IMarkerRef || element instanceof IMarker) {
                if (targetParent != null) {
                    IMarker marker;
                    IMarker iMarker = marker = element instanceof IMarker ? (IMarker)element : ((IMarkerRef)element).getMarker();
                    if (marker != null) {
                        ITopic topic;
                        String markerId;
                        String string = markerId = element instanceof IMarker ? ((IMarker)element).getId() : ((IMarkerRef)element).getMarkerId();
                        if (floating && position != null) {
                            topic = workbook.createTopic();
                            topic.setPosition(position.x, position.y);
                            commands.add((Command)new AddTopicCommand(topic, targetParent, -1, "detached"));
                            commands.add((Command)new AddMarkerCommand(topic, markerId));
                            return;
                        }
                        if (!dropInParent) {
                            topic = workbook.createTopic();
                            commands.add((Command)new AddTopicCommand(topic, targetParent, index, "attached"));
                            commands.add((Command)new AddMarkerCommand(topic, markerId));
                            return;
                        }
                        IMarkerGroup group = marker.getParent();
                        if (group.isSingleton()) {
                            for (IMarker m : group.getMarkers()) {
                                if (!targetParent.hasMarker(m.getId())) continue;
                                commands.add((Command)new DeleteMarkerCommand(targetParent, m.getId()));
                            }
                        }
                        commands.add((Command)new AddMarkerCommand(targetParent, markerId));
                    }
                }
            } else if (element instanceof IImage) {
                IImage image = (IImage)element;
                if (targetParent != null) {
                    commands.add((Command)new ModifyImageSourceCommand(targetParent, image.getSource()));
                    commands.add((Command)new ModifyImageSizeCommand(targetParent, image.getWidth(), image.getHeight()));
                    commands.add((Command)new ModifyImageAlignmentCommand(targetParent, image.getAlignment()));
                }
            } else if (element instanceof URI) {
                URI uri = (URI)element;
                if (targetParent != null) {
                    commands.add((Command)new ModifyTopicHyperlinkCommand(targetParent, uri.toString()));
                }
            }
            ++n2;
        }
        if (countForUnbalacedStructure != 0) {
            IViewer viewer = request.getTargetViewer();
            ITopic centralTopic = (ITopic)viewer.getAdapter(ITopic.class);
            ITopicExtension extension = centralTopic.createExtension("org.xmind.ui.map.unbalanced");
            ITopicExtensionElement element = (ITopicExtensionElement)extension.getContent().getCreatedChild("right-number");
            String preDndRightNum = element.getTextContent();
            if (preDndRightNum == null) {
                preDndRightNum = String.valueOf(0);
            }
            int postDndRightNum = Integer.valueOf(preDndRightNum);
            commands.add((Command)new ModifyRightNumberOfUnbalancedStructureCommand(centralTopic, preDndRightNum, postDndRightNum + countForUnbalacedStructure));
        }
        this.postAdded(elements, targetParent, sourceIndex, floating, commands);
    }

    private void preAdded(ITopic targetParent, List<Command> commands) {
        this.ensureParentUnfolded(targetParent, commands);
    }

    private void ensureParentUnfolded(ITopic targetParent, List<Command> commands) {
        if (targetParent.isFolded()) {
            commands.add((Command)new ModifyFoldedCommand(targetParent, false));
        }
    }

    private void postAdded(Object[] elements, ITopic targetParent, int sourceIndex, boolean floating, List<Command> commands) {
        boolean containsTopic = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ITopic) {
                containsTopic = true;
                break;
            }
            ++n2;
        }
        if (containsTopic && !floating && sourceIndex >= 0) {
            this.modifyRanges(targetParent, sourceIndex, commands);
        }
    }

    private void modifyRanges(ITopic targetParent, int sourceIndex, List<Command> commands) {
        this.modifyRanges(targetParent.getBoundaries(), sourceIndex, commands);
        this.modifyRanges(targetParent.getSummaries(), sourceIndex, commands);
    }

    private void modifyRanges(Collection<? extends ITopicRange> ranges, int sourceIndex, List<Command> commands) {
        for (ITopicRange iTopicRange : ranges) {
            int startIndex = iTopicRange.getStartIndex();
            int endIndex = iTopicRange.getEndIndex();
            if (startIndex < 0 || endIndex < 0) continue;
            if (startIndex >= sourceIndex) {
                commands.add((Command)new ModifyRangeCommand((IRange)iTopicRange, startIndex + 1, true));
            }
            if (endIndex < sourceIndex) continue;
            commands.add((Command)new ModifyRangeCommand((IRange)iTopicRange, endIndex + 1, false));
        }
    }

    private int modifyRightNumeberForUnbalancedStructure(Request request, ITopic targetParent, int count) {
        IViewer viewer = request.getTargetViewer();
        if (viewer == null) {
            return count;
        }
        ITopic centralTopic = (ITopic)viewer.getAdapter(ITopic.class);
        if (centralTopic == targetParent) {
            boolean isUnbalancedStructure;
            String centralTopicStructure = centralTopic.getStructureClass();
            boolean bl = isUnbalancedStructure = centralTopicStructure == null || "org.xmind.ui.map.unbalanced".equalsIgnoreCase(centralTopicStructure);
            if (isUnbalancedStructure) {
                ITopicExtension extension = centralTopic.createExtension("org.xmind.ui.map.unbalanced");
                ITopicExtensionElement element = (ITopicExtensionElement)extension.getContent().getCreatedChild("right-number");
                String preDndRightNum = element.getTextContent();
                if (preDndRightNum == null) {
                    preDndRightNum = String.valueOf(0);
                }
                int postDndRightNum = Integer.valueOf(preDndRightNum);
                ITopicPart parentPart = (ITopicPart)request.getParameter("parent");
                if (parentPart != null || postDndRightNum <= 2) {
                    if (parentPart != null) {
                        Rectangle bounds = parentPart.getFigure().getBounds();
                        if (bounds.getCenter().getDifference((Point)((Point)request.getParameter((String)"positionAbsolute"))).width < 0) {
                            ++count;
                        }
                    } else if (postDndRightNum <= 2) {
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    protected Command createModifyImageCommand(ITopic target, String source, int width, int height, String alignment) {
        ArrayList<ModifyCommand> commands = new ArrayList<ModifyCommand>(3);
        commands.add(new ModifyImageSourceCommand(target, source));
        commands.add(new ModifyImageSizeCommand(target, width, height));
        commands.add(new ModifyImageAlignmentCommand(target, alignment));
        return new CompoundCommand(commands);
    }

    protected abstract Object[] toViewerElements(Object var1, Request var2, IWorkbook var3, ITopic var4, boolean var5);

    public boolean canCopy(TransferData transferData, IViewer viewer, Point location, IPart target) {
        return true;
    }

    public boolean canLink(TransferData data, IViewer viewer, Point location, IPart target) {
        return false;
    }

    public boolean canMove(TransferData data, IViewer viewer, Point location, IPart target) {
        return true;
    }
}

