/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.DialogPane;
import org.xmind.ui.internal.statushandlers.StatusDetails;
import org.xmind.ui.internal.statushandlers.StatusHandlerMessages;

public class ErrorDialogPane2
extends DialogPane {
    private final StatusDetails details;
    private final ErrorSupportProvider supportProvider;
    private Composite composite;
    private Runnable closeCallback;

    public ErrorDialogPane2(StatusAdapter error, ErrorSupportProvider supportProvider) {
        this.details = new StatusDetails(error);
        this.supportProvider = supportProvider;
        this.closeCallback = null;
    }

    @Override
    protected Control createDialogContents(Composite parent) {
        this.composite = (Composite)super.createDialogContents(parent);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 20;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        this.composite.setBackground(parent.getBackground());
        Control titleArea = this.createTitleArea(this.composite);
        titleArea.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)titleArea.getLayoutData()).widthHint = 280;
        Control detailsArea = this.createDetailsArea(this.composite);
        detailsArea.setLayoutData((Object)new GridData(4, 4, true, false));
        ((GridData)detailsArea.getLayoutData()).widthHint = 300;
        ((GridData)detailsArea.getLayoutData()).heightHint = 80;
        return this.composite;
    }

    @Override
    protected int getPreferredWidth() {
        return 500;
    }

    private Control createTitleArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        area.setLayout((Layout)layout);
        area.setBackground(parent.getBackground());
        Label titleImageLabel = new Label(area, 0);
        titleImageLabel.setImage(this.details.getImage());
        titleImageLabel.setLayoutData((Object)new GridData(1, 1, false, false));
        titleImageLabel.setBackground(parent.getBackground());
        Composite messageParent = new Composite(area, 0);
        messageParent.setLayout((Layout)new GridLayout());
        messageParent.setBackground(parent.getBackground());
        Label messageLabel = new Label(messageParent, 64);
        messageLabel.setText(this.details.getMessage());
        messageLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        messageLabel.setBackground(parent.getBackground());
        if (this.supportProvider != null) {
            if (this.supportProvider instanceof AbstractStatusAreaProvider && ((AbstractStatusAreaProvider)this.supportProvider).validFor(this.details.getStatusAdapter())) {
                ((AbstractStatusAreaProvider)this.supportProvider).createSupportArea(messageParent, this.details.getStatusAdapter());
            } else if (this.supportProvider.validFor(this.details.getStatusAdapter().getStatus())) {
                this.supportProvider.createSupportArea(messageParent, this.details.getStatusAdapter().getStatus());
            }
        }
        return area;
    }

    private Control createDetailsArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        area.setLayout((Layout)layout);
        Text detailsText = new Text(area, 2818);
        detailsText.setEditable(false);
        detailsText.setText(this.details.getFullText());
        detailsText.setLayoutData((Object)new GridData(4, 4, true, true));
        return area;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, StatusHandlerMessages.RuntimeErrorDialog_CloseButton_Text, true);
    }

    @Override
    protected void createBlankArea(Composite buttonBar) {
        Composite composite = new Composite(buttonBar, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setBackground(buttonBar.getBackground());
        Hyperlink report = new Hyperlink(composite, 16384);
        report.setText(StatusHandlerMessages.RuntimeErrorDialog_ReportHyperlink_Text);
        report.setUnderlined(true);
        report.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ErrorDialogPane2.this.reportPressed();
            }
        });
        report.setBackground(composite.getBackground());
    }

    private void reportPressed() {
        try {
            MindMapUIPlugin.getDefault().getErrorReporter().report(this.details);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.close();
    }

    @Override
    protected boolean closePressed() {
        this.setReturnCode(12);
        this.close();
        if (this.closeCallback != null) {
            Display.getCurrent().asyncExec(this.closeCallback);
        }
        return true;
    }

    public void setCloseCallback(Runnable closeCallback) {
        this.closeCallback = closeCallback;
    }

    @Override
    protected void escapeKeyPressed() {
        this.triggerButton(12);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.composite = null;
    }

    @Override
    public void setFocus() {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setFocus();
        }
    }
}

