/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.xmind.core.internal.command.Logger;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Property;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.Request;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartFactory;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.ui.properties.IPropertySectionPart;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FrameFigure;
import org.xmind.ui.gallery.FramePart;
import org.xmind.ui.gallery.GalleryLayout;
import org.xmind.ui.gallery.GallerySelectTool;
import org.xmind.ui.gallery.GalleryViewer;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.properties.IStyleEditingDelegate;
import org.xmind.ui.internal.properties.IStyleEditingSectionPart;
import org.xmind.ui.internal.views.StyleFigure;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.IMindMapViewer;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.StyledPropertySectionPart;
import org.xmind.ui.style.StyleUtils;
import org.xmind.ui.util.MindMapUtils;
import org.xmind.ui.viewers.MButton;

public class StylesPropertySectionPart
extends StyledPropertySectionPart
implements IStyleEditingDelegate {
    private static Class<? extends IStyleEditingSectionPart> styleEditingSectionClass = null;
    private MButton selectStyleWidget;

    @Override
    protected void doRefresh() {
        this.selectStyleWidget.setText(MindMapMessages.StylePropertySectionPart_text);
    }

    @Override
    protected void createContent(Composite parent) {
        this.selectStyleWidget = new MButton(parent, 0);
        this.selectStyleWidget.getControl().setLayoutData((Object)new GridData(4, 4, true, false));
        this.selectStyleWidget.getControl().setToolTipText(MindMapMessages.StylePropertySectionPart_tooltip);
        this.selectStyleWidget.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                StylesPropertySectionPart.this.openSelectStyleDialog();
            }
        });
    }

    private void openSelectStyleDialog() {
        if (this.selectStyleWidget != null && this.selectStyleWidget.getControl() != null && !this.selectStyleWidget.getControl().isDisposed()) {
            Control handle = this.selectStyleWidget.getControl();
            SelectStyleDialog selectStyleDialog = new SelectStyleDialog(handle.getShell(), handle);
            selectStyleDialog.open();
            Shell shell = selectStyleDialog.getShell();
            if (shell != null && !shell.isDisposed()) {
                this.selectStyleWidget.setForceFocus(true);
                shell.addListener(12, new Listener(){

                    public void handleEvent(Event event) {
                        if (StylesPropertySectionPart.this.selectStyleWidget != null && !StylesPropertySectionPart.this.selectStyleWidget.getControl().isDisposed()) {
                            StylesPropertySectionPart.this.selectStyleWidget.setForceFocus(false);
                        }
                    }
                });
            }
        }
    }

    public void setFocus() {
        if (this.selectStyleWidget != null && !this.selectStyleWidget.getControl().isDisposed()) {
            this.selectStyleWidget.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        this.selectStyleWidget = null;
    }

    private String getCurrentStyleType() {
        ISelection selection = this.getCurrentSelection();
        String type = null;
        if (selection instanceof IStructuredSelection) {
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                String t = null;
                if (obj instanceof IStyled) {
                    t = ((IStyled)obj).getStyleType();
                }
                if (t == null) {
                    return null;
                }
                if (type != null && !t.equals(type)) {
                    return null;
                }
                if (type != null) continue;
                type = t;
            }
        }
        return type;
    }

    private List<IStyle> getViewerInput() {
        String type = this.getCurrentStyleType();
        if (type == null) {
            return Collections.emptyList();
        }
        ArrayList<IStyle> list = new ArrayList<IStyle>();
        Set systemStyles = MindMapUI.getResourceManager().getSystemStyleSheet().getStyles("automatic-styles");
        Set userStyles = MindMapUI.getResourceManager().getUserStyleSheet().getAllStyles();
        for (IStyle style : systemStyles) {
            if (!type.equals(style.getType())) continue;
            list.add(style);
        }
        for (IStyle style : userStyles) {
            if (!type.equals(style.getType())) continue;
            list.add(0, style);
        }
        return list;
    }

    private void applyStyle(IStyle style) {
        Request request = this.fillTargets(new Request("modify_style"));
        request.setParameter("resource", (Object)style);
        this.sendRequest(request);
    }

    @Override
    public void styleEditingFinished() {
        this.openSelectStyleDialog();
    }

    private IStyleEditingSectionPart createStyleEditingSectionPart() {
        if (styleEditingSectionClass == null) {
            return null;
        }
        try {
            IStyleEditingSectionPart section = styleEditingSectionClass.newInstance();
            section.init(this.getContainer(), this.getContributedEditor());
            section.setDelegate(this);
            return section;
        }
        catch (Exception e) {
            Logger.log((String)"Failed to create EditStyleContributionItem", (Throwable)e);
            return null;
        }
    }

    public static void setStyleEditingSectionClass(Class<? extends IStyleEditingSectionPart> cls) {
        styleEditingSectionClass = cls;
    }

    private class SelectStyleDialog
    extends PopupDialog
    implements IOpenListener {
        private Control handle;
        private GalleryViewer viewer;
        private IPropertySectionPart styleEditingSection;

        public SelectStyleDialog(Shell parent, Control handle) {
            super(parent, 16, true, true, true, false, false, null, null);
            this.handle = handle;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.viewer = new GalleryViewer();
            Properties properties = this.viewer.getProperties();
            properties.set("org.xmind.ui.gallery.horizontal", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.wrap", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.flatFrames", (Object)Boolean.TRUE);
            properties.set("constrained", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.layout", (Object)new GalleryLayout(1, 3, 1, 1, new Insets(5)));
            properties.set("org.xmind.ui.gallery.frameContentSize", (Object)new Dimension(48, 48));
            properties.set("org.xmind.ui.gallery.titlePlacement", (Object)GalleryViewer.TITLE_TOP);
            properties.set("org.xmind.ui.gallery.singleClickToOpen", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.hideTitle", (Object)Boolean.TRUE);
            properties.set("org.xmind.ui.gallery.solidFrames", (Object)Boolean.FALSE);
            this.viewer.addOpenListener((IOpenListener)this);
            EditDomain editDomain = new EditDomain();
            editDomain.installTool("select tool", (ITool)new GallerySelectTool());
            this.viewer.setEditDomain(editDomain);
            IGraphicalPart part = StylesPropertySectionPart.this.getGraphicalPart(StylesPropertySectionPart.this.getSelectedElements()[0]);
            HashMap<String, String> existedStyle = this.generateExistedStyle(part);
            this.viewer.setPartFactory((IPartFactory)new StylePartFactory(this.viewer.getPartFactory(), existedStyle));
            this.viewer.setLabelProvider((IBaseLabelProvider)new StyleLabelProvider());
            this.viewer.createControl(composite);
            GridData galleryData = new GridData(4, 4, true, true);
            this.viewer.getControl().setLayoutData((Object)galleryData);
            Display display = parent.getDisplay();
            this.viewer.getControl().setBackground(display.getSystemColor(25));
            this.viewer.setInput((Object)StylesPropertySectionPart.this.getViewerInput());
            if (this.styleEditingSection == null) {
                this.styleEditingSection = StylesPropertySectionPart.this.createStyleEditingSectionPart();
            }
            if (this.styleEditingSection != null) {
                Composite editItemParent = new Composite(composite, 0);
                editItemParent.setLayoutData((Object)new GridData(4, 4, true, false));
                this.styleEditingSection.createControl(editItemParent);
            }
            return composite;
        }

        protected void constrainShellSize() {
            super.constrainShellSize();
            if (this.styleEditingSection != null) {
                this.styleEditingSection.setSelection(StylesPropertySectionPart.this.getCurrentSelection());
            }
            if (this.viewer != null) {
                this.viewer.setInput((Object)StylesPropertySectionPart.this.getViewerInput());
            }
        }

        private HashMap<String, String> generateExistedStyle(IGraphicalPart selectedPart) {
            HashMap<String, String> stylePropertiesMap = new HashMap<String, String>();
            IResourceManager resourceManager = MindMapUI.getResourceManager();
            IStyleSheet defaultStyleSheet = resourceManager.getDefaultStyleSheet();
            IStyleSheet userStyleSheet = resourceManager.getUserStyleSheet();
            Object model = MindMapUtils.getRealModel((IPart)selectedPart);
            if (model instanceof IStyled) {
                IStyled styled = (IStyled)model;
                HashSet<String> propertyKeys = new HashSet<String>();
                IGraphicalViewer viewer = StylesPropertySectionPart.this.getActiveViewer();
                if (!(viewer instanceof IMindMapViewer)) {
                    return stylePropertiesMap;
                }
                IMindMap mindMap = ((IMindMapViewer)viewer).getMindMap();
                String styleFamily = MindMapUtils.getFamily(styled, mindMap);
                String userStyleId = styled.getStyleId();
                IStyle userStyle = userStyleSheet.findStyle(userStyleId);
                this.collectPropertyKey(userStyle, propertyKeys);
                IStyle theme = mindMap.getSheet().getTheme();
                if (theme != null) {
                    IStyle themeStyle = theme.getDefaultStyle(styleFamily);
                    this.collectPropertyKey(themeStyle, propertyKeys);
                }
                IStyle defaultStyle = defaultStyleSheet.findStyle(styleFamily);
                this.collectPropertyKey(defaultStyle, propertyKeys);
                IStyleSelector styleSelector = StyleUtils.getStyleSelector(selectedPart);
                for (String key : propertyKeys) {
                    stylePropertiesMap.put(key, styleSelector.getStyleValue(selectedPart, key));
                }
            }
            return stylePropertiesMap;
        }

        private void collectPropertyKey(IStyle style, Set<String> propertyKeys) {
            if (style == null) {
                return;
            }
            Iterator properties = style.properties();
            while (properties.hasNext()) {
                propertyKeys.add(((Property)properties.next()).key);
            }
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.addListener(27, new Listener(){

                public void handleEvent(Event event) {
                    event.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SelectStyleDialog.this.close();
                        }
                    });
                }
            });
        }

        protected List getBackgroundColorExclusions() {
            List list = super.getBackgroundColorExclusions();
            if (this.viewer != null) {
                list.add(this.viewer.getControl());
            }
            return list;
        }

        protected Point getDefaultSize() {
            return new Point(260, 300);
        }

        protected Point getInitialLocation(Point initialSize) {
            if (this.handle != null && !this.handle.isDisposed()) {
                Point loc = this.handle.toDisplay(this.handle.getLocation());
                return new Point(loc.x, loc.y + this.handle.getBounds().height);
            }
            return super.getInitialLocation(initialSize);
        }

        protected IDialogSettings getDialogSettings() {
            return MindMapUIPlugin.getDefault().getDialogSettings("org.xmind.ui.popupDialog");
        }

        public void open(OpenEvent event) {
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof IStyle) {
                this.close();
                final IStyle selectedStyle = (IStyle)o;
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StylesPropertySectionPart.this.applyStyle(selectedStyle);
                    }
                });
                StylesPropertySectionPart.this.selectStyleWidget.setText(selectedStyle.getName());
            }
        }
    }

    private static class StyleLabelProvider
    extends LabelProvider {
        private StyleLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IStyle) {
                IStyle style = (IStyle)element;
                return style.getName();
            }
            return super.getText(element);
        }
    }

    private static class StylePart
    extends GraphicalEditPart {
        private HashMap<String, String> existedStyle;

        public StylePart(Object model, HashMap<String, String> existedStyle) {
            this.setModel(model);
            this.existedStyle = existedStyle;
        }

        public IStyle getStyle() {
            return (IStyle)super.getModel();
        }

        protected IFigure createFigure() {
            return new StyleFigure();
        }

        protected void updateView() {
            super.updateView();
            StyleFigure styleFigure = (StyleFigure)this.getFigure();
            styleFigure.setStyle(this.getStyle());
            styleFigure.setExistedStyle(this.existedStyle);
            Properties properties = ((GalleryViewer)this.getSite().getViewer()).getProperties();
            Dimension size = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            if (size != null) {
                this.getFigure().setPreferredSize(size);
            }
        }
    }

    private class StylePartFactory
    implements IPartFactory {
        private IPartFactory factory;
        private HashMap<String, String> existedStyle;

        public StylePartFactory(IPartFactory factory, HashMap<String, String> existedStyle) {
            this.factory = factory;
            this.existedStyle = existedStyle;
        }

        public IPart createPart(IPart context, Object model) {
            if (context instanceof FramePart && model instanceof IStyle) {
                IStyle style = (IStyle)model;
                FrameFigure figure = ((FramePart)context).getFigure();
                if (figure != null) {
                    figure.setToolTip((IFigure)new Label(style.getName()));
                }
                return new StylePart(style, this.existedStyle);
            }
            return this.factory.createPart(context, model);
        }
    }
}

