/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IFileEntry;
import org.xmind.core.IImage;
import org.xmind.core.IManifest;
import org.xmind.core.IMeta;
import org.xmind.core.IModifiable;
import org.xmind.core.INotesContent;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.command.ICommandStack;
import org.xmind.ui.commands.ModifyMetadataCommand;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.internal.AttachmentImageDescriptor;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.mindmap.ImageDownloader;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.internal.views.Messages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.viewers.FileUtils;
import org.xmind.ui.viewers.IListLayout;
import org.xmind.ui.viewers.IListRenderer;
import org.xmind.ui.viewers.ImageLabel;
import org.xmind.ui.viewers.MListViewer;
import org.xmind.ui.viewers.StraightListLayout;

public class WorkbookMetadataPage
extends Page {
    private static final int PROP_CONTROL = 1;
    private static final int PROP_FOCUS_CONTROL = 2;
    private static final int PROP_CONTENT = 3;
    private static final int PROP_OUTGOING_SELECTION = 4;
    private static final String KEY_WIDGET_FACTORY = String.valueOf(WorkbookMetadataPage.class.getName()) + ".widgetFactory";
    private static final String METADATA_AUTHOR_EMAIL = "author.email";
    private static final String METADATA_AUTHOR_NAME = "author.name";
    private static final String METADATA_AUTHOR_ORG = "author.org";
    private static final String METADATA_ESTIMATED_SIZE = "estimatedSize";
    private static final String METADATA_TOPIC_COUNT = "topicCount";
    private static final String METADATA_WORD_COUNT = "wordCount";
    private static final String METADATA_REVISION_COUNT = "revisionCount";
    private static final String METADATA_MODIFICATION_TIME = "modificationTime";
    private static final String METADATA_MODIFIER_NAME = "modifierName";
    private static final String METADATA_CREATION_TIME = "creationTime";
    private static final String METADATA_ATTACHMENTS = "attachments";
    private static final String METADATA_EXTERNAL_FILES = "externalFiles";
    private static final String METADATA_HYPERLINKS = "hyperlinks";
    private static final String METADATA_IMAGES = "images";
    private static final int PRIMARY_BYTES = 5300;
    private static final int TOPIC_DEFAULT_BYTES = 160;
    private IEditorPart sourceEditor;
    private IWorkbook workbook;
    private CoreEventRegister eventRegister;
    private WidgetFactory factory;
    private Composite composite;
    private ScrolledForm form;
    private List<IWorkbookMetadataPart> parts = new ArrayList<IWorkbookMetadataPart>();
    private Map<IWorkbookMetadataPart, Section> sections = new HashMap<IWorkbookMetadataPart, Section>();
    private IWorkbookMetadataPart activePart = null;
    private boolean reflowScheduled = false;
    private ICoreEventListener coreEventHandler = new ICoreEventListener(){

        public void handleCoreEvent(final CoreEvent event) {
            Display display = this.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    WorkbookMetadataPage.this.refreshParts(event);
                }
            });
        }

        private Display getDisplay() {
            Display display = Display.getCurrent();
            if (display != null) {
                return display;
            }
            Control control = WorkbookMetadataPage.this.getControl();
            if (control == null || control.isDisposed()) {
                return null;
            }
            return control.getDisplay();
        }
    };
    private IPropertyListener propertyChangeHandler = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (source == WorkbookMetadataPage.this.sourceEditor && propId == 258) {
                WorkbookMetadataPage.this.setWorkbook((IWorkbook)WorkbookMetadataPage.this.sourceEditor.getAdapter(IWorkbook.class));
            } else if (source instanceof IWorkbookMetadataPart) {
                if (propId == 1) {
                    WorkbookMetadataPage.this.updateSection((IWorkbookMetadataPart)source);
                    WorkbookMetadataPage.this.scheduleReflow();
                } else if (propId == 2) {
                    WorkbookMetadataPage.this.activePart = (IWorkbookMetadataPart)source;
                } else if (propId == 3) {
                    if (source instanceof IModifiableWorkbookMetadataPart) {
                        WorkbookMetadataPage.this.executeCommand(((IModifiableWorkbookMetadataPart)source).createModificationCommand(WorkbookMetadataPage.this.workbook));
                    }
                } else if (propId == 4) {
                    WorkbookMetadataPage.this.revealSelectionInEditor((IWorkbookMetadataPart)source);
                }
            }
        }
    };

    public WorkbookMetadataPage(IEditorPart sourceEditor) {
        Assert.isNotNull((Object)sourceEditor);
        this.sourceEditor = sourceEditor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.sourceEditor.addPropertyListener(this.propertyChangeHandler);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        StackLayout stack = new StackLayout();
        this.composite.setLayout((Layout)stack);
        this.factory = new WidgetFactory(parent.getDisplay());
        this.factory.getHyperlinkGroup().setHyperlinkUnderlineMode(2);
        this.form = this.factory.createScrolledForm(this.composite);
        stack.topControl = this.form;
        Composite content = this.form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 3;
        content.setLayout((Layout)layout);
        this.createSections(content);
        this.form.getBody().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                WorkbookMetadataPage.this.form.getBody().setFocus();
            }
        });
        this.form.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WorkbookMetadataPage.this.handleDispose();
            }
        });
        this.setWorkbook(this.sourceEditor == null ? null : MindMapUIPlugin.getAdapter(this.sourceEditor, IWorkbook.class));
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
        if (this.form == null || this.form.isDisposed()) {
            return;
        }
        if (this.activePart != null && this.activePart.getFocusControl() != null && !this.activePart.getFocusControl().isDisposed()) {
            this.activePart.getFocusControl().setFocus();
        } else {
            this.form.getBody().setFocus();
        }
    }

    public void dispose() {
        this.sourceEditor.removePropertyListener(this.propertyChangeHandler);
        super.dispose();
    }

    private void createSections(Composite parent) {
        this.addSection(parent, new AuthorInfoPart());
        this.addSection(parent, new WorkbookSummaryPart());
        this.addSection(parent, new AttachmentListPart());
        this.addSection(parent, new ExternalFileListPart());
        this.addSection(parent, new HyperlinkListPart());
        this.addSection(parent, new ImageListPart());
    }

    private void addSection(Composite parent, IWorkbookMetadataPart part) {
        Section section = this.factory.createSection(parent, 16706);
        section.setText(part.getTitle());
        section.setLayoutData((Object)new TableWrapData(256, 128));
        Composite client = this.factory.createComposite((Composite)section, 64);
        client.setData(KEY_WIDGET_FACTORY, (Object)this.factory);
        section.setClient((Control)client);
        part.createControl(client);
        part.refresh(this.workbook, null);
        part.addPropertyListener(this.propertyChangeHandler);
        this.parts.add(part);
        this.sections.put(part, section);
        this.updateSectionVisibility(part, section, part.isVisible());
    }

    private void updateSection(IWorkbookMetadataPart part) {
        Section section = this.sections.get(part);
        if (section != null && !section.isDisposed()) {
            boolean oldVisible;
            boolean visible;
            String oldTitle;
            String title = part.getTitle();
            if (!title.equals(oldTitle = section.getText())) {
                section.setText(title);
            }
            if ((visible = part.isVisible()) != (oldVisible = section.getVisible())) {
                this.updateSectionVisibility(part, section, visible);
            }
            this.scheduleReflow();
        }
    }

    private void updateSectionVisibility(IWorkbookMetadataPart part, Section section, boolean visible) {
        if (visible) {
            section.setParent(this.form.getBody());
            Section lastVisibleSection = null;
            for (IWorkbookMetadataPart p : this.parts) {
                if (p == part) break;
                Section s = this.sections.get(p);
                if (!s.getVisible()) continue;
                lastVisibleSection = s;
            }
            if (lastVisibleSection == null) {
                section.moveAbove(null);
            } else {
                section.moveBelow(lastVisibleSection);
            }
        } else {
            section.setParent(this.composite);
        }
        section.setVisible(visible);
    }

    private void handleDispose() {
        this.setWorkbook(null);
        for (IWorkbookMetadataPart part : this.parts) {
            part.removePropertyListener(this.propertyChangeHandler);
        }
        this.parts.clear();
        this.activePart = null;
        this.sections.clear();
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        this.form = null;
        this.composite = null;
    }

    public void setWorkbook(IWorkbook workbook) {
        IWorkbook oldWorkbook = this.workbook;
        if (workbook == oldWorkbook) {
            return;
        }
        this.workbook = workbook;
        this.workbookChanged(workbook, oldWorkbook);
    }

    private void workbookChanged(IWorkbook workbook, IWorkbook oldWorkbook) {
        ICoreEventSupport support;
        if (this.eventRegister != null) {
            this.eventRegister.unregisterAll();
        }
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            for (IWorkbookMetadataPart part : this.parts) {
                part.refresh(workbook, null);
            }
            this.scheduleReflow();
        }
        if (workbook != null && (support = (ICoreEventSupport)workbook.getAdapter(ICoreEventSupport.class)) != null) {
            if (this.eventRegister == null) {
                this.eventRegister = new CoreEventRegister(this.coreEventHandler);
            }
            this.eventRegister.setNextSupport(support);
            this.registerCoreEventTypes(this.eventRegister);
        }
    }

    private void registerCoreEventTypes(CoreEventRegister register) {
        register.register("metadata");
        register.register("sheetAdd");
        register.register("sheetRemove");
        register.register("topicAdd");
        register.register("topicRemove");
        register.register("fileEntryAdd");
        register.register("fileEntryRemove");
        register.register("topicHyperlink");
        register.register("titleText");
        register.register("imageSource");
        register.register("revisionAdd");
        register.register("revisionRemove");
        register.register("modifyTime");
        register.register("workbookSave");
        register.register("relationshipAdd");
        register.register("relationshipRemove");
        register.register("boundaryAdd");
        register.register("boundaryRemove");
        register.register("topicNotes");
    }

    private synchronized void scheduleReflow() {
        if (this.form == null || this.form.isDisposed()) {
            return;
        }
        if (this.reflowScheduled) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                WorkbookMetadataPage.this.reflowScheduled = false;
                if (WorkbookMetadataPage.this.form == null || WorkbookMetadataPage.this.form.isDisposed()) {
                    return;
                }
                WorkbookMetadataPage.this.form.reflow(true);
            }
        });
        this.reflowScheduled = true;
    }

    private void executeCommand(Command command) {
        ICommandStack commandStack = MindMapUIPlugin.getAdapter(this.sourceEditor, ICommandStack.class);
        if (commandStack != null) {
            commandStack.execute(command);
        } else {
            command.execute();
        }
    }

    private void refreshParts(CoreEvent event) {
        for (IWorkbookMetadataPart part : this.parts) {
            part.refresh(this.workbook, event);
        }
    }

    private void revealSelectionInEditor(IWorkbookMetadataPart part) {
        ISelectionProvider partSelectionProvider = MindMapUIPlugin.getAdapter(part, ISelectionProvider.class);
        if (partSelectionProvider == null) {
            return;
        }
        ISelectionProvider editorSelectionProvider = this.sourceEditor.getSite().getSelectionProvider();
        if (editorSelectionProvider == null) {
            return;
        }
        editorSelectionProvider.setSelection(partSelectionProvider.getSelection());
        this.sourceEditor.getSite().getPage().activate((IWorkbenchPart)this.sourceEditor);
    }

    private static abstract class AbstractWorkbookMetadataListPart
    extends AbstractWorkbookMetadataPart
    implements IAdaptable {
        private MListViewer viewer;

        private AbstractWorkbookMetadataListPart() {
        }

        protected abstract Object[] getElements(WorkbookMetadata var1);

        protected abstract String getText(Object var1);

        protected abstract Image getImage(Object var1, ResourceManager var2);

        protected Point getImageSizeHint() {
            return new Point(-1, -1);
        }

        protected void update(Object element) {
            this.viewer.update(element, null);
            this.firePropertyChange(1);
        }

        protected MListViewer getViewer() {
            return this.viewer;
        }

        @Override
        public void createControl(final Composite parent) {
            WidgetFactory factory = (WidgetFactory)parent.getData(KEY_WIDGET_FACTORY);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            layout.makeColumnsEqualWidth = false;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 3;
            layout.verticalSpacing = 3;
            parent.setLayout((Layout)layout);
            this.viewer = new MListViewer(parent, 0);
            factory.adapt(this.viewer.getControl(), true, true);
            this.viewer.getControl().setMenu(parent.getMenu());
            this.viewer.getControl().setData(KEY_WIDGET_FACTORY, (Object)factory);
            this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
            this.hookFocusableControl(this.viewer.getControl());
            this.viewer.setContentProvider(this.createContentProvider());
            this.viewer.setLabelProvider(this.createLabelProvider());
            this.viewer.setInput((Object)this.metadata);
            this.viewer.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    AbstractWorkbookMetadataListPart.this.firePropertyChange(4);
                }
            });
            final ScrolledComposite scrolledComposite = FormUtil.getScrolledComposite((Control)parent);
            if (scrolledComposite != null) {
                this.viewer.getControl().addListener(16, new Listener(){

                    public void handleEvent(Event event) {
                        Display.getCurrent().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                Display display = Display.getCurrent();
                                if (display == null || display.isDisposed() || scrolledComposite.isDisposed()) {
                                    return;
                                }
                                Control focusControl = display.getFocusControl();
                                if (this.containsControl((Composite)scrolledComposite, focusControl) && !this.containsControl(parent, focusControl)) {
                                    AbstractWorkbookMetadataListPart.this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                                }
                            }
                        });
                    }

                    private boolean containsControl(Composite composite, Control c) {
                        while (c != null) {
                            if (c == composite) {
                                return true;
                            }
                            c = c.getParent();
                        }
                        return false;
                    }
                });
            }
        }

        @Override
        protected void refreshControls() {
            if (this.viewer == null || this.viewer.getControl() == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            this.viewer.refresh();
            this.firePropertyChange(1);
        }

        protected IContentProvider createContentProvider() {
            return new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    WorkbookMetadata metadata = (WorkbookMetadata)inputElement;
                    return AbstractWorkbookMetadataListPart.this.getElements(metadata);
                }
            };
        }

        private IBaseLabelProvider createLabelProvider() {
            return new WorkbookMetadataListLabelProvider(){
                ResourceManager rm;
                {
                    this.rm = new LocalResourceManager(JFaceResources.getResources());
                }

                public String getText(Object element) {
                    return AbstractWorkbookMetadataListPart.this.getText(element);
                }

                public Image getImage(Object element) {
                    return AbstractWorkbookMetadataListPart.this.getImage(element, this.rm);
                }

                @Override
                public Control createListItemForElement(MListViewer viewer, Composite parent, Object element) {
                    Control item = super.createListItemForElement(viewer, parent, element);
                    if (item instanceof WorkbookMetadataListRow) {
                        ((WorkbookMetadataListRow)item).setImageSizeHint(AbstractWorkbookMetadataListPart.this.getImageSizeHint());
                    }
                    return item;
                }

                public void dispose() {
                    super.dispose();
                    this.rm.dispose();
                }
            };
        }

        public <T> T getAdapter(Class<T> adapter) {
            if (adapter == ISelectionProvider.class) {
                return adapter.cast(this.viewer);
            }
            return null;
        }
    }

    private static abstract class AbstractWorkbookMetadataPart
    implements IWorkbookMetadataPart {
        private ListenerList listeners = new ListenerList();
        private Control focusControl = null;
        private Listener focusControlUpdater = new Listener(){

            public void handleEvent(Event event) {
                AbstractWorkbookMetadataPart.this.focusControl = (Control)event.widget;
                AbstractWorkbookMetadataPart.this.firePropertyChange(2);
            }
        };
        private boolean refreshScheduled = false;
        protected final WorkbookMetadata metadata = new WorkbookMetadata();

        private AbstractWorkbookMetadataPart() {
        }

        @Override
        public boolean isVisible() {
            return !this.metadata.isEmpty();
        }

        @Override
        public void addPropertyListener(IPropertyListener listener) {
            this.listeners.add((Object)listener);
        }

        @Override
        public void removePropertyListener(IPropertyListener listener) {
            this.listeners.remove((Object)listener);
        }

        @Override
        public Control getFocusControl() {
            return this.focusControl;
        }

        protected void firePropertyChange(final int propId) {
            final AbstractWorkbookMetadataPart source = this;
            Object[] objectArray = this.listeners.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                final Object listener = objectArray[n2];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        ((IPropertyListener)listener).propertyChanged(source, propId);
                    }
                });
                ++n2;
            }
        }

        protected void hookFocusableControl(Control control) {
            control.addListener(15, this.focusControlUpdater);
        }

        protected void updateText(Text control, String text) {
            if (control == null || control.isDisposed()) {
                return;
            }
            if (text == null) {
                text = "";
            }
            if (text.equals(control.getText())) {
                return;
            }
            Point selection = new Point(text.length(), text.length());
            if (control.isFocusControl()) {
                selection.x = Math.min(selection.x, control.getSelection().x);
                selection.y = Math.min(selection.y, control.getSelection().y);
            }
            control.setText(text);
            if (control.isFocusControl()) {
                control.setSelection(selection);
            }
            this.firePropertyChange(1);
        }

        protected abstract void refreshControls();

        protected void refreshAsynchronously() {
            if (this.refreshScheduled) {
                return;
            }
            Display display = Display.getCurrent();
            if (display == null) {
                return;
            }
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    AbstractWorkbookMetadataPart.this.refreshScheduled = false;
                    AbstractWorkbookMetadataPart.this.refreshControls();
                }
            });
            this.refreshScheduled = true;
        }
    }

    private static class AttachmentListPart
    extends AbstractWorkbookMetadataListPart {
        private AttachmentListPart() {
        }

        @Override
        public String getTitle() {
            return NLS.bind((String)Messages.AttachmentsInspectorSection_title, (Object)this.metadata.sizeOfSet(WorkbookMetadataPage.METADATA_ATTACHMENTS));
        }

        @Override
        public void refresh(IWorkbook workbook, CoreEvent event) {
            Object source;
            WorkbookMetadata oldMetadata = this.metadata.copy();
            Object toUpdate = null;
            if (workbook == null) {
                this.metadata.deleteAll();
            } else if (event == null) {
                this.metadata.deleteAll();
                for (ISheet sheet : workbook.getSheets()) {
                    this.topicAdded(sheet.getRootTopic());
                }
            } else if ("topicAdd".equals(event.getType())) {
                this.topicAdded((ITopic)event.getTarget());
            } else if ("topicRemove".equals(event.getType())) {
                this.topicRemoved((ITopic)event.getTarget());
            } else if ("sheetAdd".equals(event.getType())) {
                this.topicAdded(((ISheet)event.getTarget()).getRootTopic());
            } else if ("sheetRemove".equals(event.getType())) {
                this.topicRemoved(((ISheet)event.getTarget()).getRootTopic());
            } else if ("topicHyperlink".equals(event.getType())) {
                ITopic source2 = (ITopic)event.getSource();
                this.linkChanged(source2, (String)event.getOldValue(), (String)event.getNewValue());
                if (this.metadata.containsInSet(WorkbookMetadataPage.METADATA_ATTACHMENTS, source2)) {
                    toUpdate = source2;
                }
            } else if ("titleText".equals(event.getType()) && this.metadata.containsInSet(WorkbookMetadataPage.METADATA_ATTACHMENTS, source = event.getSource())) {
                toUpdate = source;
            }
            if (!this.metadata.equals(oldMetadata)) {
                this.refreshAsynchronously();
            } else if (toUpdate != null) {
                this.update(toUpdate);
            }
        }

        private void topicAdded(ITopic topic) {
            this.linkChanged(topic, null, topic.getHyperlink());
            Iterator childIter = topic.getAllChildrenIterator();
            while (childIter.hasNext()) {
                this.topicAdded((ITopic)childIter.next());
            }
        }

        private void topicRemoved(ITopic topic) {
            Iterator childIter = topic.getAllChildrenIterator();
            while (childIter.hasNext()) {
                this.topicRemoved((ITopic)childIter.next());
            }
            this.linkChanged(topic, topic.getHyperlink(), null);
        }

        private void linkChanged(ITopic topic, String oldLink, String newLink) {
            IFileEntry newEntry;
            IFileEntry oldEntry = this.findFileEntry(topic, oldLink);
            if (oldEntry != null) {
                this.metadata.removeFromSet(WorkbookMetadataPage.METADATA_ATTACHMENTS, topic);
            }
            if ((newEntry = this.findFileEntry(topic, newLink)) != null) {
                this.metadata.addToSet(WorkbookMetadataPage.METADATA_ATTACHMENTS, topic);
            }
        }

        private IFileEntry findFileEntry(ITopic topic, String link) {
            if (link == null || !HyperlinkUtils.isAttachmentURL((String)link)) {
                return null;
            }
            IManifest manifest = topic.getOwnedWorkbook().getManifest();
            if (manifest == null) {
                return null;
            }
            return manifest.getFileEntry(HyperlinkUtils.toAttachmentPath((String)link));
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            this.getViewer().setComparator((ViewerComparator)new TopicViewerComparator());
        }

        @Override
        protected Object[] getElements(WorkbookMetadata metadata) {
            return metadata.getSet(WorkbookMetadataPage.METADATA_ATTACHMENTS).toArray();
        }

        @Override
        protected String getText(Object element) {
            if (!(element instanceof ITopic)) {
                return "";
            }
            ITopic topic = (ITopic)element;
            String fileName = topic.getTitleText();
            IFileEntry entry = this.findFileEntry(topic, topic.getHyperlink());
            if (entry == null) {
                return fileName;
            }
            long size = entry.getSize();
            return String.format("%s (%s)", fileName, FileUtils.fileLengthToString((long)size));
        }

        @Override
        protected Image getImage(Object element, ResourceManager resourceManager) {
            if (!(element instanceof ITopic)) {
                return null;
            }
            ITopic topic = (ITopic)element;
            String fileName = topic.getTitleText();
            ImageDescriptor icon = MindMapUI.getImages().getFileIcon(fileName, true);
            if (icon == null) {
                icon = MindMapUI.getImages().get("unknownfile.gif", true);
            }
            return (Image)resourceManager.get((DeviceResourceDescriptor)icon);
        }
    }

    private static class AuthorInfoPart
    extends AbstractWorkbookMetadataPart
    implements IModifiableWorkbookMetadataPart {
        private Text nameInput;
        private Text emailInput;
        private Text orgInput;
        private Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                AuthorInfoPart.this.firePropertyChange(3);
            }
        };

        private AuthorInfoPart() {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public String getTitle() {
            return Messages.AuthorInfoInspectorSection_title;
        }

        @Override
        public void createControl(Composite parent) {
            WidgetFactory factory = (WidgetFactory)parent.getData(KEY_WIDGET_FACTORY);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 3;
            layout.numColumns = 2;
            parent.setLayout((Layout)layout);
            this.createLabel(parent, factory, Messages.AuthorInfoInspectorSection_Name);
            this.nameInput = this.createText(parent, factory);
            this.createLabel(parent, factory, Messages.AuthorInfoInspectorSection_Email);
            this.emailInput = this.createText(parent, factory);
            this.createLabel(parent, factory, Messages.AuthorInfoInspectorSection_Organization);
            this.orgInput = this.createText(parent, factory);
        }

        private Label createLabel(Composite parent, WidgetFactory factory, String text) {
            Label label = factory.createLabel(parent, text);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            return label;
        }

        private Text createText(Composite parent, WidgetFactory factory) {
            Text text = factory.createText(parent, "", 4);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            text.addListener(14, this.modifyListener);
            text.addListener(16, this.modifyListener);
            this.hookFocusableControl((Control)text);
            return text;
        }

        @Override
        public void refresh(IWorkbook workbook, CoreEvent event) {
            boolean changed = false;
            if (workbook == null) {
                changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_NAME, "");
                changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_EMAIL, "");
                changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_ORG, "");
            } else if (event == null) {
                IMeta meta = workbook.getMeta();
                changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_NAME, meta.getValue("Author/Name"));
                changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_EMAIL, meta.getValue("Author/Email"));
                changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_ORG, meta.getValue("Author/Org"));
            } else if ("metadata".equals(event.getType())) {
                if ("Author/Name".equals(event.getTarget())) {
                    changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_NAME, (String)event.getNewValue());
                } else if ("Author/Email".equals(event.getTarget())) {
                    changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_EMAIL, (String)event.getNewValue());
                } else if ("Author/Org".equals(event.getTarget())) {
                    changed |= this.metadata.setString(WorkbookMetadataPage.METADATA_AUTHOR_ORG, (String)event.getNewValue());
                }
            }
            if (changed) {
                this.refreshAsynchronously();
            }
        }

        @Override
        protected void refreshControls() {
            String name = this.metadata.getString(WorkbookMetadataPage.METADATA_AUTHOR_NAME);
            if (name == null || "".equals(name)) {
                name = System.getProperty("user.name");
            }
            this.updateText(this.nameInput, name);
            this.updateText(this.emailInput, this.metadata.getString(WorkbookMetadataPage.METADATA_AUTHOR_EMAIL));
            this.updateText(this.orgInput, this.metadata.getString(WorkbookMetadataPage.METADATA_AUTHOR_ORG));
        }

        @Override
        public Command createModificationCommand(IWorkbook workbook) {
            String newName = this.nameInput.getText();
            String newEmail = this.emailInput.getText();
            String newOrg = this.orgInput.getText();
            CompoundCommand command = new CompoundCommand(new Command[]{new ModifyMetadataCommand(workbook, "Author/Name", newName), new ModifyMetadataCommand(workbook, "Author/Email", newEmail), new ModifyMetadataCommand(workbook, "Author/Org", newOrg)});
            if (!command.canExecute()) {
                return null;
            }
            command.setLabel(MindMapMessages.WorkbookMetadata_ModifyAuthorInfo);
            return command;
        }
    }

    private static class ExternalFileListPart
    extends AbstractWorkbookMetadataListPart {
        private ExternalFileListPart() {
        }

        @Override
        public String getTitle() {
            return NLS.bind((String)Messages.ExternalFilesInspectorSection_title, (Object)this.metadata.sizeOfSet(WorkbookMetadataPage.METADATA_EXTERNAL_FILES));
        }

        @Override
        public void refresh(IWorkbook workbook, CoreEvent event) {
            Object source;
            WorkbookMetadata oldMetadata = this.metadata.copy();
            Object toUpdate = null;
            if (workbook == null) {
                this.metadata.deleteAll();
            } else if (event == null) {
                this.metadata.deleteAll();
                this.workbookChanged(workbook);
            } else if ("sheetAdd".equals(event.getType())) {
                this.topicAdded(((ISheet)event.getTarget()).getRootTopic());
            } else if ("sheetRemove".equals(event.getType())) {
                this.topicRemoved(((ISheet)event.getTarget()).getRootTopic());
            } else if ("topicAdd".equals(event.getType())) {
                this.topicAdded((ITopic)event.getTarget());
            } else if ("topicRemove".equals(event.getType())) {
                this.topicRemoved((ITopic)event.getTarget());
            } else if ("topicHyperlink".equals(event.getType())) {
                ITopic source2 = (ITopic)event.getSource();
                this.linkChanged(source2, (String)event.getOldValue(), (String)event.getNewValue());
                if (this.metadata.containsInSet(WorkbookMetadataPage.METADATA_EXTERNAL_FILES, source2)) {
                    toUpdate = source2;
                }
            } else if ("titleText".equals(event.getType()) && this.metadata.containsInSet(WorkbookMetadataPage.METADATA_EXTERNAL_FILES, source = event.getSource())) {
                toUpdate = source;
            }
            if (!this.metadata.equals(oldMetadata)) {
                this.refreshAsynchronously();
            } else if (toUpdate != null) {
                this.update(toUpdate);
            }
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            this.getViewer().setComparator((ViewerComparator)new TopicViewerComparator());
        }

        @Override
        protected Object[] getElements(WorkbookMetadata metadata) {
            return metadata.getSet(WorkbookMetadataPage.METADATA_EXTERNAL_FILES).toArray();
        }

        @Override
        protected Image getImage(Object element, ResourceManager resourceManager) {
            if (!(element instanceof ITopic)) {
                return null;
            }
            ITopic topic = (ITopic)element;
            File file = this.getFile(topic.getHyperlink());
            if (file == null) {
                return null;
            }
            ImageDescriptor icon = MindMapUI.getImages().getFileIcon(file.getAbsolutePath(), true);
            if (icon == null) {
                icon = MindMapUI.getImages().get("unknownfile.gif", true);
            }
            return (Image)resourceManager.get((DeviceResourceDescriptor)icon);
        }

        @Override
        protected String getText(Object element) {
            if (!(element instanceof ITopic)) {
                return "";
            }
            ITopic topic = (ITopic)element;
            File file = this.getFile(topic.getHyperlink());
            if (file == null) {
                return "";
            }
            return file.getName();
        }

        private void workbookChanged(IWorkbook workbook) {
            for (ISheet sheet : workbook.getSheets()) {
                this.topicAdded(sheet.getRootTopic());
            }
        }

        private void topicAdded(ITopic topic) {
            this.linkChanged(topic, null, topic.getHyperlink());
            Iterator childrenIterator = topic.getAllChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.topicAdded((ITopic)childrenIterator.next());
            }
        }

        private void topicRemoved(ITopic topic) {
            Iterator childrenIterator = topic.getAllChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.topicRemoved((ITopic)childrenIterator.next());
            }
            this.linkChanged(topic, topic.getHyperlink(), null);
        }

        private void linkChanged(ITopic topic, String oldLink, String newLink) {
            File newFile;
            File oldFile = this.getFile(oldLink);
            if (oldFile != null) {
                this.metadata.removeFromSet(WorkbookMetadataPage.METADATA_EXTERNAL_FILES, topic);
            }
            if ((newFile = this.getFile(newLink)) != null) {
                this.metadata.addToSet(WorkbookMetadataPage.METADATA_EXTERNAL_FILES, topic);
            }
        }

        private File getFile(String link) {
            if (!FilePathParser.isFileURI(link)) {
                return null;
            }
            return new File(FilePathParser.toPath(link));
        }
    }

    private static class HyperlinkListPart
    extends AbstractWorkbookMetadataListPart {
        private HyperlinkListPart() {
        }

        @Override
        public String getTitle() {
            return NLS.bind((String)Messages.HyperlinkInspectorSection_title, (Object)this.metadata.sizeOfSet(WorkbookMetadataPage.METADATA_HYPERLINKS));
        }

        @Override
        public void refresh(IWorkbook workbook, CoreEvent event) {
            Object source;
            WorkbookMetadata oldMetadata = this.metadata.copy();
            Object toUpdate = null;
            if (workbook == null) {
                this.metadata.deleteAll();
            } else if (event == null) {
                this.metadata.deleteAll();
                this.workbookChanged(workbook);
            } else if ("sheetAdd".equals(event.getType())) {
                this.topicAdded(((ISheet)event.getTarget()).getRootTopic());
            } else if ("sheetRemove".equals(event.getType())) {
                this.topicRemoved(((ISheet)event.getTarget()).getRootTopic());
            } else if ("topicAdd".equals(event.getType())) {
                this.topicAdded((ITopic)event.getTarget());
            } else if ("topicRemove".equals(event.getType())) {
                this.topicRemoved((ITopic)event.getTarget());
            } else if ("topicHyperlink".equals(event.getType())) {
                ITopic source2 = (ITopic)event.getSource();
                this.linkChanged(source2, (String)event.getOldValue(), (String)event.getNewValue());
                if (this.metadata.containsInSet(WorkbookMetadataPage.METADATA_HYPERLINKS, source2)) {
                    toUpdate = source2;
                }
            } else if ("titleText".equals(event.getType()) && this.metadata.containsInSet(WorkbookMetadataPage.METADATA_HYPERLINKS, source = event.getSource())) {
                toUpdate = source;
            }
            if (!this.metadata.equals(oldMetadata)) {
                this.refreshAsynchronously();
            } else if (toUpdate != null) {
                this.update(toUpdate);
            }
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            this.getViewer().setComparator((ViewerComparator)new TopicViewerComparator());
        }

        @Override
        protected Object[] getElements(WorkbookMetadata metadata) {
            return metadata.getSet(WorkbookMetadataPage.METADATA_HYPERLINKS).toArray();
        }

        @Override
        protected Image getImage(Object element, ResourceManager resourceManager) {
            return null;
        }

        @Override
        protected String getText(Object element) {
            if (!(element instanceof ITopic)) {
                return "";
            }
            ITopic topic = (ITopic)element;
            return topic.getHyperlink();
        }

        private void workbookChanged(IWorkbook workbook) {
            for (ISheet sheet : workbook.getSheets()) {
                this.topicAdded(sheet.getRootTopic());
            }
        }

        private void topicAdded(ITopic topic) {
            this.linkChanged(topic, null, topic.getHyperlink());
            Iterator childrenIterator = topic.getAllChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.topicAdded((ITopic)childrenIterator.next());
            }
        }

        private void topicRemoved(ITopic topic) {
            Iterator childrenIterator = topic.getAllChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.topicRemoved((ITopic)childrenIterator.next());
            }
            this.linkChanged(topic, topic.getHyperlink(), null);
        }

        private void linkChanged(ITopic topic, String oldLink, String newLink) {
            if (this.isNormalHyperlink(oldLink)) {
                this.metadata.removeFromSet(WorkbookMetadataPage.METADATA_HYPERLINKS, topic);
            }
            if (this.isNormalHyperlink(newLink)) {
                this.metadata.addToSet(WorkbookMetadataPage.METADATA_HYPERLINKS, topic);
            }
        }

        private boolean isNormalHyperlink(String link) {
            return link != null && !HyperlinkUtils.isAttachmentURL((String)link) && !HyperlinkUtils.isInternalURL((String)link) && !FilePathParser.isFileURI(link);
        }
    }

    private static interface IModifiableWorkbookMetadataPart {
        public Command createModificationCommand(IWorkbook var1);
    }

    private static interface IWorkbookMetadataPart {
        public String getTitle();

        public boolean isVisible();

        public void createControl(Composite var1);

        public void refresh(IWorkbook var1, CoreEvent var2);

        public void addPropertyListener(IPropertyListener var1);

        public void removePropertyListener(IPropertyListener var1);

        public Control getFocusControl();
    }

    private static class ImageListPart
    extends AbstractWorkbookMetadataListPart {
        private ImageListPart() {
        }

        @Override
        public String getTitle() {
            return NLS.bind((String)Messages.ImageInspectorSection_title, (Object)this.metadata.sizeOfSet(WorkbookMetadataPage.METADATA_IMAGES));
        }

        @Override
        public void refresh(IWorkbook workbook, CoreEvent event) {
            Object source;
            WorkbookMetadata oldMetadata = this.metadata.copy();
            Object toUpdate = null;
            if (workbook == null) {
                this.metadata.deleteAll();
            } else if (event == null) {
                this.metadata.deleteAll();
                this.workbookChanged(workbook);
            } else if ("sheetAdd".equals(event.getType())) {
                this.topicAdded(((ISheet)event.getTarget()).getRootTopic());
            } else if ("sheetRemove".equals(event.getTarget())) {
                this.topicRemoved(((ISheet)event.getTarget()).getRootTopic());
            } else if ("topicAdd".equals(event.getType())) {
                this.topicAdded((ITopic)event.getTarget());
            } else if ("topicRemove".equals(event.getType())) {
                this.topicRemoved((ITopic)event.getTarget());
            } else if ("imageSource".equals(event.getType())) {
                ITopic source2 = ((IImage)event.getSource()).getParent();
                this.imageSourceChanged(source2, (String)event.getOldValue(), (String)event.getNewValue());
                if (this.metadata.containsInSet(WorkbookMetadataPage.METADATA_IMAGES, source2)) {
                    toUpdate = source2;
                }
            } else if ("titleText".equals(event.getType()) && this.metadata.containsInSet(WorkbookMetadataPage.METADATA_IMAGES, source = event.getSource())) {
                toUpdate = source;
            }
            if (!this.metadata.equals(oldMetadata)) {
                this.refreshAsynchronously();
            } else if (toUpdate != null) {
                this.update(toUpdate);
            }
        }

        @Override
        public void createControl(Composite parent) {
            super.createControl(parent);
            this.getViewer().setComparator((ViewerComparator)new TopicViewerComparator());
        }

        @Override
        protected Object[] getElements(WorkbookMetadata metadata) {
            return metadata.getSet(WorkbookMetadataPage.METADATA_IMAGES).toArray();
        }

        @Override
        protected String getText(Object element) {
            if (!(element instanceof ITopic)) {
                return "";
            }
            ITopic topic = (ITopic)element;
            String imageURI = topic.getImage().getSource();
            if (HyperlinkUtils.isAttachmentURL((String)imageURI)) {
                String path = HyperlinkUtils.toAttachmentPath((String)imageURI);
                IFileEntry entry = topic.getOwnedWorkbook().getManifest().getFileEntry(path);
                if (entry != null) {
                    return String.format("%s (%s)", topic.getTitleText(), FileUtils.fileLengthToString((long)entry.getSize()));
                }
            }
            return topic.getTitleText();
        }

        @Override
        protected Image getImage(final Object element, ResourceManager resourceManager) {
            if (!(element instanceof ITopic)) {
                return null;
            }
            ITopic topic = (ITopic)element;
            String imageURI = topic.getImage().getSource();
            if (HyperlinkUtils.isAttachmentURL((String)imageURI)) {
                String path = HyperlinkUtils.toAttachmentPath((String)imageURI);
                IWorkbook workbook = topic.getOwnedWorkbook();
                IFileEntry entry = workbook.getManifest().getFileEntry(path);
                ImageDescriptor descriptor = AttachmentImageDescriptor.createFromEntry(workbook, entry);
                return (Image)resourceManager.get((DeviceResourceDescriptor)descriptor);
            }
            if (FilePathParser.isFileURI(imageURI)) {
                String path = FilePathParser.toPath(imageURI);
                ImageDescriptor descriptor = ImageDescriptor.createFromFile(null, (String)path);
                return (Image)resourceManager.get((DeviceResourceDescriptor)descriptor);
            }
            ImageDescriptor descriptor = ImageDownloader.getInstance().getImage(imageURI);
            if (descriptor != null) {
                return (Image)resourceManager.get((DeviceResourceDescriptor)descriptor);
            }
            ImageDownloader.getInstance().register(imageURI, new Runnable(){

                @Override
                public void run() {
                    if (ImageListPart.this.getViewer() == null || ImageListPart.this.getViewer().getControl() == null || ImageListPart.this.getViewer().getControl().isDisposed()) {
                        return;
                    }
                    Display display = ImageListPart.this.getViewer().getControl().getDisplay();
                    if (display == null || display.isDisposed()) {
                        return;
                    }
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            ImageListPart.this.update(element);
                        }
                    });
                }
            });
            return null;
        }

        @Override
        protected Point getImageSizeHint() {
            return new Point(32, 32);
        }

        private void workbookChanged(IWorkbook workbook) {
            for (ISheet sheet : workbook.getSheets()) {
                this.topicAdded(sheet.getRootTopic());
            }
        }

        private void topicAdded(ITopic topic) {
            this.imageSourceChanged(topic, null, topic.getImage().getSource());
            Iterator childrenIterator = topic.getAllChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.topicAdded((ITopic)childrenIterator.next());
            }
        }

        private void topicRemoved(ITopic topic) {
            Iterator childrenIterator = topic.getAllChildrenIterator();
            while (childrenIterator.hasNext()) {
                this.topicRemoved((ITopic)childrenIterator.next());
            }
            this.imageSourceChanged(topic, topic.getImage().getSource(), null);
        }

        private void imageSourceChanged(ITopic topic, String oldSrc, String newSrc) {
            if (oldSrc != null) {
                this.metadata.removeFromSet(WorkbookMetadataPage.METADATA_IMAGES, topic);
            }
            if (newSrc != null) {
                this.metadata.addToSet(WorkbookMetadataPage.METADATA_IMAGES, topic);
            }
        }
    }

    private static class TopicViewerComparator
    extends ViewerComparator {
        private TopicViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return Core.getTopicComparator().compare((ITopic)e1, (ITopic)e2);
        }
    }

    protected static class WorkbookMetadata {
        private final Map<String, Object> delegate = new HashMap<String, Object>();

        protected WorkbookMetadata() {
        }

        public boolean set(String key, Object value) {
            Object oldValue = this.delegate.put(key, value);
            return value != oldValue && (value == null || !value.equals(oldValue));
        }

        public Object get(String key) {
            return this.delegate.get(key);
        }

        public boolean delete(String key) {
            boolean hadValue = this.delegate.containsKey(key);
            this.delegate.remove(key);
            return hadValue;
        }

        public boolean deleteAll() {
            boolean hadValues = !this.delegate.isEmpty();
            this.delegate.clear();
            return hadValues;
        }

        public int getInt(String key) {
            Object value = this.delegate.get(key);
            if (value != null) {
                return (Integer)value;
            }
            return 0;
        }

        public boolean setInt(String key, int value) {
            if (value == 0) {
                return this.delete(key);
            }
            return this.set(key, value);
        }

        public boolean increaseInt(String key, int delta) {
            int value = this.getInt(key);
            return this.setInt(key, value + delta);
        }

        public boolean decreaseInt(String key, int delta) {
            int value = this.getInt(key);
            return this.setInt(key, value - delta);
        }

        public long getLong(String key) {
            Object value = this.delegate.get(key);
            if (value != null) {
                return (Long)value;
            }
            return 0L;
        }

        public boolean setLong(String key, long value) {
            if (value == 0L) {
                return this.delete(key);
            }
            return this.set(key, value);
        }

        public boolean increaseLong(String key, long delta) {
            long value = this.getLong(key);
            return this.setLong(key, value + delta);
        }

        public boolean decreaseLong(String key, long delta) {
            long value = this.getLong(key);
            return this.setLong(key, value - delta);
        }

        public String getString(String key) {
            return (String)this.delegate.get(key);
        }

        public boolean setString(String key, String value) {
            if (value == null) {
                return this.delete(key);
            }
            return this.set(key, value);
        }

        public <T> Set<T> getSet(String key) {
            Object value = this.delegate.get(key);
            if (value != null) {
                return (Set)value;
            }
            return Collections.emptySet();
        }

        public boolean addToSet(String key, Object object) {
            boolean changed = false;
            HashSet<Object> set = (HashSet<Object>)this.delegate.get(key);
            if (set == null) {
                set = new HashSet<Object>();
                this.delegate.put(key, set);
                changed = true;
            }
            return changed |= set.add(object);
        }

        public boolean removeFromSet(String key, Object object) {
            boolean changed = false;
            Set set = (Set)this.delegate.get(key);
            if (set != null) {
                changed |= set.remove(object);
                if (set.isEmpty()) {
                    this.delegate.remove(key);
                    changed = true;
                }
            }
            return changed;
        }

        public int sizeOfSet(String key) {
            Set set = (Set)this.delegate.get(key);
            return set == null ? 0 : set.size();
        }

        public boolean containsInSet(String key, Object object) {
            Set set = (Set)this.delegate.get(key);
            return set != null && set.contains(object);
        }

        public boolean contains(String key) {
            return this.delegate.containsKey(key);
        }

        public Collection<String> keys() {
            return this.delegate.keySet();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public WorkbookMetadata copy() {
            WorkbookMetadata that = new WorkbookMetadata();
            for (String key : this.keys()) {
                HashSet value = this.get(key);
                if (value instanceof Set) {
                    value = new HashSet(value);
                }
                that.set(key, value);
            }
            return that;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof WorkbookMetadata)) {
                return false;
            }
            WorkbookMetadata that = (WorkbookMetadata)obj;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static class WorkbookMetadataListLabelProvider
    extends LabelProvider
    implements IListRenderer {
        private StraightListLayout layout = new StraightListLayout(512);

        private WorkbookMetadataListLabelProvider() {
        }

        public IListLayout getListLayout(MListViewer viewer) {
            return this.layout;
        }

        public Control createListItemForElement(MListViewer viewer, Composite parent, Object element) {
            WidgetFactory factory = (WidgetFactory)viewer.getControl().getData(KEY_WIDGET_FACTORY);
            WorkbookMetadataListRow row = new WorkbookMetadataListRow(parent, factory);
            return row;
        }

        public void updateListItem(MListViewer viewer, Object element, Control item) {
            WorkbookMetadataListRow row = (WorkbookMetadataListRow)item;
            row.setText(this.getText(element));
            row.setImage(this.getImage(element));
        }

        public int getListItemState(MListViewer viewer, Control item) {
            WorkbookMetadataListRow row;
            int state = 0;
            if (item instanceof WorkbookMetadataListRow && (row = (WorkbookMetadataListRow)item).getSelection()) {
                state |= 1;
            }
            return state;
        }

        public void setListItemState(MListViewer viewer, Control item, int state) {
            if (item instanceof WorkbookMetadataListRow) {
                WorkbookMetadataListRow row = (WorkbookMetadataListRow)item;
                row.setSelection((state & 1) != 0);
            }
        }
    }

    private static class WorkbookMetadataListRow
    extends Composite {
        private ImageLabel imageLabel;
        private Label textLabel;
        private boolean selected = false;
        private Color background;
        private Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 3) {
                    WorkbookMetadataListRow.this.getParent().setFocus();
                    WorkbookMetadataListRow.this.handleMouseDown(event);
                } else if (event.type == 8) {
                    WorkbookMetadataListRow.this.handleMouseDoubleClick(event);
                }
            }
        };

        public WorkbookMetadataListRow(Composite parent, WidgetFactory factory) {
            super(parent, 524288);
            this.background = super.getBackground();
            factory.adapt((Control)this, true, true);
            this.setMenu(parent.getMenu());
            this.hookControl((Control)this);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 2;
            layout.marginHeight = 1;
            layout.horizontalSpacing = 2;
            layout.verticalSpacing = 0;
            this.setLayout((Layout)layout);
            this.imageLabel = new ImageLabel((Composite)this, 524288);
            factory.adapt((Control)this.imageLabel, true, true);
            this.imageLabel.setScaleHint(1);
            this.imageLabel.setHorizontalAlignment(0x1000000);
            this.imageLabel.setVerticalAlignment(0x1000000);
            GridData imageLayoutData = new GridData(0x1000000, 0x1000000, false, true);
            imageLayoutData.exclude = true;
            this.imageLabel.setLayoutData((Object)imageLayoutData);
            this.imageLabel.setVisible(false);
            this.imageLabel.setBackground(parent.getDisplay().getSystemColor(37));
            this.imageLabel.setMenu(this.getMenu());
            this.hookControl((Control)this.imageLabel);
            this.textLabel = factory.createLabel((Composite)this, "", 524288);
            this.textLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
            this.textLabel.setBackground(parent.getDisplay().getSystemColor(37));
            this.textLabel.setMenu(this.getMenu());
            this.hookControl((Control)this.textLabel);
        }

        public void setImageSizeHint(Point hint) {
            GridData layoutData = (GridData)this.imageLabel.getLayoutData();
            layoutData.widthHint = hint.x;
            layoutData.heightHint = hint.y;
            this.layout(true);
        }

        private void hookControl(Control c) {
            c.addListener(3, this.listener);
            c.addListener(8, this.listener);
        }

        public void setImage(Image image) {
            this.checkWidget();
            this.imageLabel.setImage(image);
            boolean visible = image != null;
            this.imageLabel.setVisible(visible);
            ((GridData)this.imageLabel.getLayoutData()).exclude = !visible;
            this.layout(true);
        }

        public void setText(String text) {
            this.checkWidget();
            this.textLabel.setText(text);
            this.layout(true);
        }

        public boolean getSelection() {
            return this.selected;
        }

        public void setSelection(boolean selection) {
            this.checkWidget();
            if (selection == this.selected) {
                return;
            }
            this.selected = selection;
            this.updateBackground();
        }

        public Color getBackground() {
            return this.background;
        }

        public void setBackground(Color color) {
            this.checkWidget();
            this.background = color;
            this.updateBackground();
        }

        private void updateBackground() {
            if (this.getSelection()) {
                super.setBackground(this.getDisplay().getSystemColor(26));
            } else {
                super.setBackground(this.background);
            }
        }

        private void handleMouseDown(Event event) {
            Control[] siblings = this.getParent().getChildren();
            int i = 0;
            while (i < siblings.length) {
                Control item = siblings[i];
                if (item instanceof WorkbookMetadataListRow) {
                    ((WorkbookMetadataListRow)item).setSelection(false);
                }
                ++i;
            }
            this.setSelection(true);
            this.getParent().notifyListeners(13, new Event());
        }

        private void handleMouseDoubleClick(Event event) {
            this.getParent().notifyListeners(14, new Event());
        }
    }

    private static class WorkbookSummaryPart
    extends AbstractWorkbookMetadataPart {
        private Text estimatedSizeText;
        private Text topicCountText;
        private Text wordCountText;
        private Text revisionCountText;
        private Text modificationTimeText;
        private Text modifierNameText;
        private Text creationTimeText;

        private WorkbookSummaryPart() {
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public String getTitle() {
            return Messages.FileInfoInspectorSection_title;
        }

        @Override
        public void createControl(Composite parent) {
            WidgetFactory factory = (WidgetFactory)parent.getData(KEY_WIDGET_FACTORY);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 5;
            layout.verticalSpacing = 3;
            layout.numColumns = 2;
            parent.setLayout((Layout)layout);
            this.estimatedSizeText = this.createTextWithLabel(parent, factory, Messages.FileInfoEstimateSize_label);
            this.topicCountText = this.createTextWithLabel(parent, factory, Messages.FileInfoTopics_label);
            this.wordCountText = this.createTextWithLabel(parent, factory, Messages.FileInfoWords_label);
            this.revisionCountText = this.createTextWithLabel(parent, factory, Messages.FileInfoRevisions_label);
            this.modificationTimeText = this.createTextWithLabel(parent, factory, Messages.FileInfoModifiedTime_label);
            this.modifierNameText = this.createTextWithLabel(parent, factory, Messages.FileInfoModifiedBy_label);
            this.creationTimeText = this.createTextWithLabel(parent, factory, Messages.FileInfoCreatedTime_label);
        }

        private Text createTextWithLabel(Composite parent, WidgetFactory factory, String labelText) {
            Label label = factory.createLabel(parent, labelText);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Text text = new Text(parent, 0xC | factory.getOrientation());
            factory.adapt((Control)text, true, false);
            text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.hookFocusableControl((Control)text);
            return text;
        }

        @Override
        public void refresh(IWorkbook workbook, CoreEvent event) {
            WorkbookMetadata oldMetadata = this.metadata.copy();
            if (workbook == null) {
                this.metadata.deleteAll();
            } else if (event == null) {
                this.workbookChanged(workbook);
            } else if ("sheetAdd".equals(event.getType())) {
                this.sheetAdded((ISheet)event.getTarget());
            } else if ("sheetRemove".equals(event.getType())) {
                this.sheetRemoved((ISheet)event.getTarget());
            } else if ("topicAdd".equals(event.getType())) {
                this.topicAdded((ITopic)event.getTarget());
            } else if ("topicRemove".equals(event.getType())) {
                this.topicRemoved((ITopic)event.getTarget());
            } else if ("titleText".equals(event.getType())) {
                this.titleTextChanged((String)event.getOldValue(), (String)event.getNewValue());
            } else if ("topicNotes".equals(event.getType())) {
                if ("plain".equals(event.getTarget())) {
                    this.notesChanged((INotesContent)event.getOldValue(), (INotesContent)event.getNewValue());
                }
            } else if ("fileEntryAdd".equals(event.getType())) {
                this.fileEntryAdded((IFileEntry)event.getTarget());
            } else if ("fileEntryRemove".equals(event.getType())) {
                this.fileEntryRemoved((IFileEntry)event.getTarget());
            } else if ("relationshipAdd".equals(event.getType())) {
                this.relationshipAdded((IRelationship)event.getTarget());
            } else if ("relationshipRemove".equals(event.getType())) {
                this.relationshipRemoved((IRelationship)event.getTarget());
            } else if ("boundaryAdd".equals(event.getType())) {
                this.boundaryAdded((IBoundary)event.getTarget());
            } else if ("boundaryRemove".equals(event.getType())) {
                this.boundaryRemoved((IBoundary)event.getTarget());
            } else if ("revisionAdd".equals(event.getType())) {
                this.metadata.increaseInt(WorkbookMetadataPage.METADATA_REVISION_COUNT, 1);
            } else if ("revisionRemove".equals(event.getType())) {
                this.metadata.decreaseInt(WorkbookMetadataPage.METADATA_REVISION_COUNT, 1);
            } else if ("modifyTime".equals(event.getType()) || "workbookSave".equals(event.getType())) {
                IModifiable source = (IModifiable)event.getSource();
                this.metadata.setLong(WorkbookMetadataPage.METADATA_MODIFICATION_TIME, source.getModifiedTime());
                this.metadata.setString(WorkbookMetadataPage.METADATA_MODIFIER_NAME, source.getModifiedBy());
            }
            if (!this.metadata.equals(oldMetadata)) {
                this.refreshAsynchronously();
            }
        }

        @Override
        protected void refreshControls() {
            this.updateText(this.topicCountText, String.valueOf(this.metadata.getInt(WorkbookMetadataPage.METADATA_TOPIC_COUNT)));
            this.updateText(this.wordCountText, String.valueOf(this.metadata.getInt(WorkbookMetadataPage.METADATA_WORD_COUNT)));
            this.updateText(this.estimatedSizeText, FileUtils.fileLengthToString((long)this.metadata.getLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE)));
            this.updateText(this.revisionCountText, String.valueOf(this.metadata.getInt(WorkbookMetadataPage.METADATA_REVISION_COUNT)));
            this.updateText(this.modificationTimeText, NumberUtils.formatDate((long)this.metadata.getLong(WorkbookMetadataPage.METADATA_MODIFICATION_TIME)));
            this.updateText(this.modifierNameText, this.metadata.getString(WorkbookMetadataPage.METADATA_MODIFIER_NAME));
            this.updateText(this.creationTimeText, this.metadata.getString(WorkbookMetadataPage.METADATA_CREATION_TIME));
        }

        private void workbookChanged(IWorkbook workbook) {
            this.metadata.deleteAll();
            this.metadata.setLong(WorkbookMetadataPage.METADATA_MODIFICATION_TIME, workbook.getModifiedTime());
            String name = workbook.getModifiedBy();
            if (name == null || "".equals(name)) {
                name = System.getProperty("user.name");
            }
            this.metadata.setString(WorkbookMetadataPage.METADATA_MODIFIER_NAME, name);
            this.metadata.setString(WorkbookMetadataPage.METADATA_CREATION_TIME, workbook.getMeta().getValue("Create/Time"));
            this.metadata.setLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, 5300L);
            for (ISheet sheet : workbook.getSheets()) {
                this.sheetAdded(sheet);
            }
            Iterator entryIter = workbook.getManifest().iterFileEntries();
            while (entryIter.hasNext()) {
                this.fileEntryAdded((IFileEntry)entryIter.next());
            }
        }

        private void sheetAdded(ISheet sheet) {
            this.titleTextChanged(null, sheet.getTitleText());
            this.topicAdded(sheet.getRootTopic());
            this.metadata.increaseInt(WorkbookMetadataPage.METADATA_REVISION_COUNT, sheet.getOwnedWorkbook().getRevisionRepository().getRevisionManager(sheet.getId(), "application/vnd.xmind.sheet").getRevisions().size());
            for (IRelationship r : sheet.getRelationships()) {
                this.relationshipAdded(r);
            }
        }

        private void sheetRemoved(ISheet sheet) {
            for (IRelationship r : sheet.getRelationships()) {
                this.relationshipRemoved(r);
            }
            this.metadata.decreaseInt(WorkbookMetadataPage.METADATA_REVISION_COUNT, sheet.getOwnedWorkbook().getRevisionRepository().getRevisionManager(sheet.getId(), "application/vnd.xmind.sheet").getRevisions().size());
            this.topicRemoved(sheet.getRootTopic());
            this.titleTextChanged(sheet.getTitleText(), null);
        }

        private void topicAdded(ITopic topic) {
            this.metadata.increaseInt(WorkbookMetadataPage.METADATA_TOPIC_COUNT, 1);
            this.metadata.increaseLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, 160L);
            this.titleTextChanged(null, topic.getTitleText());
            this.notesChanged(null, topic.getNotes().getContent("plain"));
            Iterator childIter = topic.getAllChildrenIterator();
            while (childIter.hasNext()) {
                this.topicAdded((ITopic)childIter.next());
            }
            for (IBoundary boundary : topic.getBoundaries()) {
                this.boundaryAdded(boundary);
            }
        }

        private void topicRemoved(ITopic topic) {
            for (IBoundary boundary : topic.getBoundaries()) {
                this.boundaryRemoved(boundary);
            }
            Iterator childIter = topic.getAllChildrenIterator();
            while (childIter.hasNext()) {
                this.topicRemoved((ITopic)childIter.next());
            }
            this.notesChanged(topic.getNotes().getContent("plain"), null);
            this.titleTextChanged(topic.getTitleText(), null);
            this.metadata.decreaseLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, 160L);
            this.metadata.decreaseInt(WorkbookMetadataPage.METADATA_TOPIC_COUNT, 1);
        }

        private void titleTextChanged(String oldTitle, String newTitle) {
            if (oldTitle != null) {
                this.metadata.decreaseLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, oldTitle.length());
                this.metadata.decreaseInt(WorkbookMetadataPage.METADATA_WORD_COUNT, WorkbookSummaryPart.countWords(oldTitle));
            }
            if (newTitle != null) {
                this.metadata.increaseLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, newTitle.length());
                this.metadata.increaseInt(WorkbookMetadataPage.METADATA_WORD_COUNT, WorkbookSummaryPart.countWords(newTitle));
            }
        }

        private void notesChanged(INotesContent oldNotes, INotesContent newNotes) {
            String content;
            if (oldNotes instanceof IPlainNotesContent && (content = ((IPlainNotesContent)oldNotes).getTextContent()) != null) {
                this.metadata.decreaseInt(WorkbookMetadataPage.METADATA_WORD_COUNT, WorkbookSummaryPart.countWords(content));
            }
            if (newNotes instanceof IPlainNotesContent && (content = ((IPlainNotesContent)newNotes).getTextContent()) != null) {
                this.metadata.increaseInt(WorkbookMetadataPage.METADATA_WORD_COUNT, WorkbookSummaryPart.countWords(content));
            }
        }

        private void fileEntryAdded(IFileEntry entry) {
            this.metadata.increaseLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, entry.getSize());
        }

        private void fileEntryRemoved(IFileEntry entry) {
            this.metadata.decreaseLong(WorkbookMetadataPage.METADATA_ESTIMATED_SIZE, entry.getSize());
        }

        private void relationshipAdded(IRelationship r) {
            this.titleTextChanged(null, r.getTitleText());
        }

        private void relationshipRemoved(IRelationship r) {
            this.titleTextChanged(r.getTitleText(), null);
        }

        private void boundaryAdded(IBoundary b) {
            this.titleTextChanged(null, b.getTitleText());
        }

        private void boundaryRemoved(IBoundary b) {
            this.titleTextChanged(b.getTitleText(), null);
        }

        private static int countWords(String s) {
            int total = s.length();
            int count = 0;
            boolean inWord = false;
            int i = 0;
            while (i < total) {
                char c = s.charAt(i);
                if (WorkbookSummaryPart.isOneWordCharacter(c)) {
                    if (inWord) {
                        ++count;
                    }
                    ++count;
                    inWord = false;
                } else if (Character.isLetter(c) || Character.isDigit(c)) {
                    inWord = true;
                } else {
                    if (inWord) {
                        ++count;
                    }
                    inWord = false;
                }
                ++i;
            }
            if (inWord) {
                ++count;
            }
            return count;
        }

        private static boolean isOneWordCharacter(char c) {
            Character.UnicodeBlock ub = Character.UnicodeBlock.of(c);
            return ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS || ub == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A || ub == Character.UnicodeBlock.GENERAL_PUNCTUATION || ub == Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION || ub == Character.UnicodeBlock.HALFWIDTH_AND_FULLWIDTH_FORMS;
        }
    }
}

