/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.mindmap;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.draw2d.IOriginBased;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.image.ImageExportUtils;
import org.xmind.gef.image.ViewerExportSourceProvider;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.MindMapUI;

public class MindMapViewerExportSourceProvider
extends ViewerExportSourceProvider {
    public MindMapViewerExportSourceProvider(IGraphicalViewer viewer, Insets margins) {
        super(viewer, margins);
    }

    public MindMapViewerExportSourceProvider(IGraphicalViewer viewer, int allMargin) {
        super(viewer, allMargin);
    }

    public MindMapViewerExportSourceProvider(IGraphicalViewer viewer) {
        super(viewer, viewer.getProperties().getInteger("margin", 15));
    }

    protected void collectContents(List<IFigure> figures) {
        figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_BACKGROUND));
        figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_SHADOW));
        figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_CONTENTS));
        figures.add((IFigure)this.getViewer().getLayer(MindMapUI.LAYER_TITLE));
    }

    protected Rectangle calculateSourceArea(IFigure[] contents) {
        IFigure contentsFigure = this.getContentsFigure();
        if (contentsFigure != null) {
            return ImageExportUtils.getBounds((IFigure)contentsFigure);
        }
        return super.calculateSourceArea(contents);
    }

    protected IFigure getContentsFigure() {
        IPart contentsPart = this.getViewer().getRootPart().getContents();
        if (contentsPart instanceof IGraphicalPart) {
            return ((IGraphicalPart)contentsPart).getFigure();
        }
        return null;
    }

    public Point getOriginPoint() {
        IFigure contentsFigure = this.getContentsFigure();
        if (contentsFigure != null) {
            if (contentsFigure instanceof IOriginBased) {
                return ((IOriginBased)contentsFigure).getOrigin();
            }
            if (contentsFigure instanceof IReferencedFigure) {
                return ((IReferencedFigure)contentsFigure).getReference();
            }
        }
        return this.getSourceArea().getTopLeft();
    }
}

