/**************************************************************************
*   Copyright (C) 2004 by                                                 *
*   karye@users.sourceforge.net                                           *
*   Stefan Bogner <bochi@online.ms>                                       *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <KConfigDialog>
#include <KConfigSkeleton>
#include <QHash>
#include <QRegularExpression>
#include <initializer_list>
#include <kconfigdialog.h>       // for KConfigDialog
#include <qhash.h>               // for QHash
#include <qlist.h>               // for QList
#include <qobjectdefs.h>         // for Q_OBJECT, slots
#include <qregularexpression.h>  // for QRegularExpression
#include <qstring.h>             // for QString, operator+, operator==
#include <qstringlist.h>         // for QStringList
#include <stddef.h>              // for NULL
#include <utility>

#include "settings.h"            // for KurooConfig
#include "ui_options1.h"         // for Options1
#include "ui_options2.h"         // for Options2
#include "ui_options3.h"         // for Options3
#include "ui_options4.h"         // for Options4
#include <qstringliteral.h>

/**
 * @class ConfigDialog
 * @short Kuroo preferences.
 */
class ConfigDialog : public KConfigDialog
{
Q_OBJECT

public:
	ConfigDialog( QWidget *parent, const QString& name, KConfigSkeleton *config );
	~ConfigDialog();

	/**
	 * Read /etc/portage/repos.conf file(s) and extract the repository locations from them
	 * @returns the filesystem paths of each repository configured in repos.conf
	 */
	static const QStringList	readReposConf( QWidget* parent );

private:
	static const QStringList	readMakeConf();
	static void					parseMakeConf();
	static bool					saveMakeConf();
	static void					handleELogClasses( const QString& value );
	static void					handleELogSystem( const QString& value );

private Q_SLOTS:
	static void					slotSaveAll();
	void						slotDefaults();

private:
	bool				m_isDefault;
	Ui::Options1		form1;
	Ui::Options2		form2;
	Ui::Options3		form3;
	Ui::Options4		form4;

	inline static const QRegularExpression m_rxLine = QRegularExpression( QStringLiteral("^(\\w*=)\\s*\"?([^\"#]*)\"?#*") );

	inline static const QHash<QString, void (*)(const QString&)> m_configHash = QHash<QString, void (*)(const QString&)>
		{{QStringLiteral("ACCEPT_KEYWORDS="), KurooConfig::setAcceptKeywords},
		{QStringLiteral("AUTOCLEAN="), nullptr},
		{QStringLiteral("BUILD_PREFIX="), KurooConfig::setBuildPrefix},
		{QStringLiteral("CBUILD="), KurooConfig::setCBuild},
		{QStringLiteral("CCACHE_SIZE="), KurooConfig::setCCacheSize},
		{QStringLiteral("CFLAGS="), KurooConfig::setCFlags},
		{QStringLiteral("CXXFLAGS="), KurooConfig::setCXXFlags},
		{QStringLiteral("CHOST="), KurooConfig::setChost},
		{QStringLiteral("CLEAN_DELAY="), KurooConfig::setCleanDelay},
		{QStringLiteral("CONFIG_PROTECT="), KurooConfig::setConfigProtect},
		{QStringLiteral("CONFIG_PROTECT_MASK="), KurooConfig::setConfigProtectMask},
		{QStringLiteral("DEBUGBUILD="), KurooConfig::setDebugBuild},
		{QStringLiteral("DISTDIR="), KurooConfig::setDirDist},
		{QStringLiteral("FEATURES="), KurooConfig::setFeatures},
		{QStringLiteral("FETCHCOMMAND="), KurooConfig::setFetchCommand},
		{QStringLiteral("GENTOO_MIRRORS="), KurooConfig::setGentooMirrors},
		{QStringLiteral("FTP_PROXY="), KurooConfig::setFtpProxy},
		{QStringLiteral("HTTP_PROXY="), KurooConfig::setHttpProxy},
		{QStringLiteral("MAKEOPTS="), KurooConfig::setMakeOpts},
		{QStringLiteral("NOCOLOR="), nullptr},
		{QStringLiteral("PKG_TMPDIR="), KurooConfig::setDirPkgTmp},
		{QStringLiteral("PKGDIR="), KurooConfig::setDirPkg},
		{QStringLiteral("PORT_LOGDIR="), KurooConfig::setDirPortLog},
		{QStringLiteral("PORTAGE_BINHOST="), KurooConfig::setPortageBinHost},
		{QStringLiteral("PORTAGE_ELOG_CLASSES="), ConfigDialog::handleELogClasses},
		{QStringLiteral("PORTAGE_ELOG_SYSTEM="), ConfigDialog::handleELogSystem},
		{QStringLiteral("PORTAGE_ELOG_COMMAND="), KurooConfig::setElogCustomCmd},
		{QStringLiteral("PORTAGE_ELOG_MAILURI="), KurooConfig::setElogMailURI},
		{QStringLiteral("PORTAGE_ELOG_MAILFROM="), KurooConfig::setElogMailFromURI},
		{QStringLiteral("PORTAGE_ELOG_MAILSUBJECT="), KurooConfig::setElogSubject},
		{QStringLiteral("PORTAGE_NICENESS="), KurooConfig::setPortageNiceness},
		{QStringLiteral("PORTAGE_TMPDIR="), KurooConfig::setDirPortageTmp},
		{QStringLiteral("PORTDIR="), KurooConfig::setDirPortage},
		{QStringLiteral("PORTDIR_OVERLAY="), KurooConfig::setDirPortageOverlay},
		{QStringLiteral("RESUMECOMMAND="), KurooConfig::setResumeCommand},
		{QStringLiteral("ROOT="), KurooConfig::setRoot},
		{QStringLiteral("RSYNC_EXCLUDEFROM="), KurooConfig::setRsyncExcludeFrom},
		{QStringLiteral("RSYNC_PROXY="), KurooConfig::setRsyncProxy},
		{QStringLiteral("RSYNC_RETRIES="), KurooConfig::setRsyncRetries},
		{QStringLiteral("RSYNC_RATELIMIT="), KurooConfig::setRsyncRateLimit},
		{QStringLiteral("RSYNC_TIMEOUT="), KurooConfig::setRsyncTimeOut},
		{QStringLiteral("RPMDIR="), KurooConfig::setDirRpm},
		{QStringLiteral("SYNC="), KurooConfig::setSync},
		{QStringLiteral("USE="), KurooConfig::setUse},
		{QStringLiteral("USE_ORDER="), KurooConfig::setUseOrder}};
		
		inline static const QRegularExpression m_rxAnyConfigVars =
			QRegularExpression( u'(' + m_configHash.keys().replaceInStrings(QStringLiteral("="), QString()).join(u'|') + u')' );
};

#endif
