/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.interval.ia_math;

import net.sourceforge.interval.ia_math.IAException;
import net.sourceforge.interval.ia_math.RMath;
import net.sourceforge.interval.ia_math.RealInterval;

public class IAMath {
    public static final boolean nonempty(RealInterval realInterval) {
        return realInterval.lo <= realInterval.hi;
    }

    public static RealInterval intersect(RealInterval realInterval, RealInterval realInterval2) throws IAException {
        return new RealInterval(Math.max(realInterval.lo, realInterval2.lo), Math.min(realInterval.hi, realInterval2.hi));
    }

    public static RealInterval union(RealInterval realInterval, RealInterval realInterval2) throws IAException {
        return new RealInterval(Math.min(realInterval.lo, realInterval2.lo), Math.max(realInterval.hi, realInterval2.hi));
    }

    public static RealInterval add(RealInterval realInterval, RealInterval realInterval2) {
        RealInterval realInterval3 = new RealInterval();
        realInterval3.lo = RMath.add_lo(realInterval.lo, realInterval2.lo);
        realInterval3.hi = RMath.add_hi(realInterval.hi, realInterval2.hi);
        return realInterval3;
    }

    public static RealInterval sub(RealInterval realInterval, RealInterval realInterval2) {
        RealInterval realInterval3 = new RealInterval();
        realInterval3.lo = RMath.sub_lo(realInterval.lo, realInterval2.hi);
        realInterval3.hi = RMath.sub_hi(realInterval.hi, realInterval2.lo);
        return realInterval3;
    }

    public static RealInterval mul(RealInterval realInterval, RealInterval realInterval2) {
        RealInterval realInterval3 = new RealInterval();
        if (realInterval.lo == 0.0 && realInterval.hi == 0.0 || realInterval2.lo == 0.0 && realInterval2.hi == 0.0) {
            realInterval3.lo = 0.0;
            realInterval3.hi = RMath.NegZero;
        } else if (realInterval.lo >= 0.0) {
            if (realInterval2.lo >= 0.0) {
                realInterval3.lo = Math.max(0.0, RMath.mul_lo(realInterval.lo, realInterval2.lo));
                realInterval3.hi = RMath.mul_hi(realInterval.hi, realInterval2.hi);
            } else if (realInterval2.hi <= 0.0) {
                realInterval3.lo = RMath.mul_lo(realInterval.hi, realInterval2.lo);
                realInterval3.hi = Math.min(0.0, RMath.mul_hi(realInterval.lo, realInterval2.hi));
            } else {
                realInterval3.lo = RMath.mul_lo(realInterval.hi, realInterval2.lo);
                realInterval3.hi = RMath.mul_hi(realInterval.hi, realInterval2.hi);
            }
        } else if (realInterval.hi <= 0.0) {
            if (realInterval2.lo >= 0.0) {
                realInterval3.lo = RMath.mul_lo(realInterval.lo, realInterval2.hi);
                realInterval3.hi = Math.min(0.0, RMath.mul_hi(realInterval.hi, realInterval2.lo));
            } else if (realInterval2.hi <= 0.0) {
                realInterval3.lo = Math.max(0.0, RMath.mul_lo(realInterval.hi, realInterval2.hi));
                realInterval3.hi = RMath.mul_hi(realInterval.lo, realInterval2.lo);
            } else {
                realInterval3.lo = RMath.mul_lo(realInterval.lo, realInterval2.hi);
                realInterval3.hi = RMath.mul_hi(realInterval.lo, realInterval2.lo);
            }
        } else if (realInterval2.lo >= 0.0) {
            realInterval3.lo = RMath.mul_lo(realInterval.lo, realInterval2.hi);
            realInterval3.hi = RMath.mul_hi(realInterval.hi, realInterval2.hi);
        } else if (realInterval2.hi <= 0.0) {
            realInterval3.lo = RMath.mul_lo(realInterval.hi, realInterval2.lo);
            realInterval3.hi = RMath.mul_hi(realInterval.lo, realInterval2.lo);
        } else {
            realInterval3.lo = Math.min(RMath.mul_lo(realInterval.hi, realInterval2.lo), RMath.mul_lo(realInterval.lo, realInterval2.hi));
            realInterval3.hi = Math.max(RMath.mul_hi(realInterval.lo, realInterval2.lo), RMath.mul_hi(realInterval.hi, realInterval2.hi));
        }
        return realInterval3;
    }

    public static RealInterval div(RealInterval realInterval, RealInterval realInterval2) {
        if (realInterval2.lo == 0.0 && realInterval2.hi == 0.0) {
            throw new IAException("div(X,Y): Division by Zero");
        }
        return IAMath.odiv(realInterval, realInterval2);
    }

    public static RealInterval odiv(RealInterval realInterval, RealInterval realInterval2) {
        RealInterval realInterval3 = new RealInterval();
        if (realInterval.lo <= 0.0 && 0.0 <= realInterval.hi && realInterval2.lo <= 0.0 && 0.0 <= realInterval2.hi) {
            realInterval3.lo = Double.NEGATIVE_INFINITY;
            realInterval3.hi = Double.POSITIVE_INFINITY;
        } else {
            if (realInterval2.lo == 0.0) {
                realInterval2.lo = 0.0;
            }
            if (realInterval2.hi == 0.0) {
                realInterval2.hi = RMath.NegZero;
            }
            if (realInterval.lo >= 0.0) {
                if (realInterval2.lo >= 0.0) {
                    realInterval3.lo = Math.max(0.0, RMath.div_lo(realInterval.lo, realInterval2.hi));
                    realInterval3.hi = RMath.div_hi(realInterval.hi, realInterval2.lo);
                } else if (realInterval2.hi <= 0.0) {
                    realInterval3.lo = RMath.div_lo(realInterval.hi, realInterval2.hi);
                    realInterval3.hi = Math.min(0.0, RMath.div_hi(realInterval.lo, realInterval2.lo));
                } else {
                    realInterval3.lo = Double.NEGATIVE_INFINITY;
                    realInterval3.hi = Double.POSITIVE_INFINITY;
                }
            } else if (realInterval.hi <= 0.0) {
                if (realInterval2.lo >= 0.0) {
                    realInterval3.lo = RMath.div_lo(realInterval.lo, realInterval2.lo);
                    realInterval3.hi = Math.min(0.0, RMath.div_hi(realInterval.hi, realInterval2.hi));
                } else if (realInterval2.hi <= 0.0) {
                    realInterval3.lo = Math.max(0.0, RMath.div_lo(realInterval.hi, realInterval2.lo));
                    realInterval3.hi = RMath.div_hi(realInterval.lo, realInterval2.hi);
                } else {
                    realInterval3.lo = Double.NEGATIVE_INFINITY;
                    realInterval3.hi = Double.POSITIVE_INFINITY;
                }
            } else if (realInterval2.lo >= 0.0) {
                realInterval3.lo = RMath.div_lo(realInterval.lo, realInterval2.lo);
                realInterval3.hi = RMath.div_hi(realInterval.hi, realInterval2.lo);
            } else if (realInterval2.hi <= 0.0) {
                realInterval3.lo = RMath.div_lo(realInterval.hi, realInterval2.hi);
                realInterval3.hi = RMath.div_hi(realInterval.lo, realInterval2.hi);
            } else {
                realInterval3.lo = Double.NEGATIVE_INFINITY;
                realInterval3.hi = Double.POSITIVE_INFINITY;
            }
        }
        return realInterval3;
    }

    public static boolean intersect_odiv(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) throws IAException {
        if (realInterval3.lo >= 0.0 || realInterval3.hi <= 0.0) {
            realInterval.intersect(IAMath.odiv(realInterval2, realInterval3));
            return true;
        }
        if (realInterval2.lo > 0.0) {
            double d = RMath.div_hi(realInterval2.lo, realInterval3.lo);
            double d2 = RMath.div_lo(realInterval2.lo, realInterval3.hi);
            if ((realInterval.lo > d || realInterval.lo == 0.0) && realInterval.lo < d2) {
                realInterval.lo = d2;
            }
            if ((realInterval.hi < d2 || realInterval.hi == 0.0) && realInterval.hi > d) {
                realInterval.hi = d;
            }
            if (realInterval.lo <= realInterval.hi) {
                return true;
            }
            throw new IAException("intersect_odiv(Y,Z,X): intersection is an Empty Interval");
        }
        if (realInterval2.hi < 0.0) {
            double d = RMath.div_hi(realInterval2.hi, realInterval3.hi);
            double d3 = RMath.div_lo(realInterval2.hi, realInterval3.lo);
            if ((realInterval.lo > d || realInterval.lo == 0.0) && realInterval.lo < d3) {
                realInterval.lo = d3;
            }
            if ((realInterval.hi < d3 || realInterval.hi == 0.0) && realInterval.hi > d) {
                realInterval.hi = d;
            }
            if (realInterval.lo <= realInterval.hi) {
                return true;
            }
            throw new IAException("intersect_odiv(Y,Z,X): intersection is an Empty Interval");
        }
        return true;
    }

    public static RealInterval uminus(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = -realInterval.hi;
        realInterval2.hi = -realInterval.lo;
        return realInterval2;
    }

    public static RealInterval exp(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = RMath.exp_lo(realInterval.lo);
        realInterval2.hi = RMath.exp_hi(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval log(RealInterval realInterval) throws IAException {
        RealInterval realInterval2 = new RealInterval();
        if (realInterval.hi <= 0.0) {
            throw new IAException("log(X): X<=0 not allowed");
        }
        if (realInterval.lo < 0.0) {
            realInterval.lo = 0.0;
        }
        realInterval2.lo = RMath.log_lo(realInterval.lo);
        realInterval2.hi = RMath.log_hi(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval sin(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        RealInterval realInterval3 = new RealInterval();
        realInterval2 = IAMath.div(realInterval, new RealInterval(RMath.prevfp(Math.PI * 2), RMath.nextfp(Math.PI * 2)));
        realInterval3 = IAMath.sin2pi(realInterval2);
        return realInterval3;
    }

    public static RealInterval cos(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        RealInterval realInterval3 = new RealInterval();
        realInterval2 = IAMath.div(realInterval, new RealInterval(RMath.prevfp(Math.PI * 2), RMath.nextfp(Math.PI * 2)));
        realInterval3 = IAMath.cos2pi(realInterval2);
        return realInterval3;
    }

    public static RealInterval tan(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        RealInterval realInterval3 = new RealInterval();
        realInterval2 = IAMath.div(realInterval, new RealInterval(RMath.prevfp(Math.PI * 2), RMath.nextfp(Math.PI * 2)));
        realInterval3 = IAMath.tan2pi(realInterval2);
        return realInterval3;
    }

    public static RealInterval asin(RealInterval realInterval) throws IAException {
        RealInterval realInterval2 = new RealInterval();
        realInterval.intersect(new RealInterval(-1.0, 1.0));
        realInterval2.lo = RMath.asin_lo(realInterval.lo);
        realInterval2.hi = RMath.asin_hi(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval acos(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = RMath.acos_lo(realInterval.hi);
        realInterval2.hi = RMath.acos_hi(realInterval.lo);
        return realInterval2;
    }

    public static RealInterval atan(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = RMath.atan_lo(realInterval.lo);
        realInterval2.hi = RMath.atan_hi(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval sinRange(int n, int n2) {
        switch (4 * n + n2) {
            case 0: {
                return new RealInterval(-1.0, 1.0);
            }
            case 1: {
                return new RealInterval(1.0, 1.0);
            }
            case 2: {
                return new RealInterval(0.0, 1.0);
            }
            case 3: {
                return new RealInterval(-1.0, 1.0);
            }
            case 4: {
                return new RealInterval(-1.0, 0.0);
            }
            case 5: {
                return new RealInterval(-1.0, 1.0);
            }
            case 6: {
                return new RealInterval(0.0, 0.0);
            }
            case 7: {
                return new RealInterval(-1.0, 0.0);
            }
            case 8: {
                return new RealInterval(-1.0, 0.0);
            }
            case 9: {
                return new RealInterval(-1.0, 1.0);
            }
            case 10: {
                return new RealInterval(-1.0, 1.0);
            }
            case 11: {
                return new RealInterval(-1.0, -1.0);
            }
            case 12: {
                return new RealInterval(0.0, 0.0);
            }
            case 13: {
                return new RealInterval(0.0, 1.0);
            }
            case 14: {
                return new RealInterval(0.0, 1.0);
            }
            case 15: {
                return new RealInterval(-1.0, 1.0);
            }
        }
        System.out.println("ERROR in sinRange(" + n + "," + n2 + ")");
        return new RealInterval(-1.0, 1.0);
    }

    static RealInterval sin2pi0DI(double d) {
        return new RealInterval(RMath.sin2pi_lo(d), RMath.sin2pi_hi(d));
    }

    static RealInterval cos2pi0DI(double d) {
        return new RealInterval(RMath.cos2pi_lo(d), RMath.cos2pi_hi(d));
    }

    static RealInterval eval_sin2pi(double d, int n) {
        switch (n) {
            case 0: {
                return IAMath.sin2pi0DI(d);
            }
            case 1: {
                return IAMath.cos2pi0DI(d);
            }
            case 2: {
                return IAMath.uminus(IAMath.sin2pi0DI(d));
            }
            case 3: {
                return IAMath.uminus(IAMath.cos2pi0DI(d));
            }
        }
        System.out.println("ERROR in eval_sin2pi(" + d + "," + n + ")");
        return new RealInterval();
    }

    public static RealInterval sin2pi(RealInterval realInterval) {
        long l;
        RealInterval realInterval2 = new RealInterval();
        RealInterval realInterval3 = null;
        RealInterval realInterval4 = null;
        RealInterval realInterval5 = null;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (Double.isInfinite(realInterval.lo) || Double.isInfinite(realInterval.hi)) {
            return new RealInterval(-1.0, 1.0);
        }
        double d3 = Math.rint(4.0 * realInterval.lo);
        int n3 = (int)Math.round(d3 - 4.0 * Math.floor(d3 / 4.0));
        double d4 = RMath.sub_lo(realInterval.lo, d3 / 4.0);
        double d5 = Math.floor(d3 / 4.0);
        double d6 = Math.rint(4.0 * realInterval.hi);
        int n4 = (int)Math.round(d6 - 4.0 * Math.floor(d6 / 4.0));
        double d7 = RMath.sub_hi(realInterval.hi, d6 / 4.0);
        double d8 = Math.floor(d6 / 4.0);
        if (d4 <= -0.25 || d4 >= 0.25 || d7 <= -0.25 || d7 >= 0.25) {
            return new RealInterval(-1.0, 1.0);
        }
        long l2 = d7 <= 0.0 ? (long)n4 : (long)(n4 + 1);
        double d9 = (double)(l2 - (l = d4 >= 0.0 ? (long)n3 : (long)(n3 - 1))) + 4.0 * (d8 - d5);
        if (d9 > 4.0) {
            return new RealInterval(-1.0, 1.0);
        }
        realInterval4 = IAMath.eval_sin2pi(d4, n3);
        realInterval5 = IAMath.eval_sin2pi(d7, n4);
        realInterval3 = IAMath.union(realInterval4, realInterval5);
        n = (int)((l + 4L) % 4L);
        n2 = (int)((l2 + 3L) % 4L);
        if (d9 <= 1.0) {
            return realInterval3;
        }
        return IAMath.union(realInterval3, IAMath.sinRange(n, n2));
    }

    public static RealInterval cos2pi(RealInterval realInterval) {
        long l;
        RealInterval realInterval2 = new RealInterval();
        RealInterval realInterval3 = null;
        RealInterval realInterval4 = null;
        RealInterval realInterval5 = null;
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (Double.isInfinite(realInterval.lo) || Double.isInfinite(realInterval.hi)) {
            return new RealInterval(-1.0, 1.0);
        }
        double d3 = Math.rint(4.0 * realInterval.lo);
        int n3 = (int)Math.round(d3 - 4.0 * Math.floor(d3 / 4.0));
        double d4 = RMath.sub_lo(realInterval.lo, d3 / 4.0);
        double d5 = Math.floor(d3 / 4.0);
        double d6 = Math.rint(4.0 * realInterval.hi);
        int n4 = (int)Math.round(d6 - 4.0 * Math.floor(d6 / 4.0));
        double d7 = RMath.sub_hi(realInterval.hi, d6 / 4.0);
        double d8 = Math.floor(d6 / 4.0);
        if (d4 <= -0.25 || d4 >= 0.25 || d7 <= -0.25 || d7 >= 0.25) {
            return new RealInterval(-1.0, 1.0);
        }
        long l2 = d7 <= 0.0 ? (long)n4 : (long)(n4 + 1);
        double d9 = (double)(l2 - (l = d4 >= 0.0 ? (long)n3 : (long)(n3 - 1))) + 4.0 * (d8 - d5);
        if (d9 > 4.0) {
            return new RealInterval(-1.0, 1.0);
        }
        realInterval4 = IAMath.eval_sin2pi(d4, (n3 + 1) % 4);
        realInterval5 = IAMath.eval_sin2pi(d7, (n4 + 1) % 4);
        realInterval3 = IAMath.union(realInterval4, realInterval5);
        n = (int)((l + 4L + 1L) % 4L);
        n2 = (int)((l2 + 3L + 1L) % 4L);
        if (d9 <= 1.0) {
            return realInterval3;
        }
        return IAMath.union(realInterval3, IAMath.sinRange(n, n2));
    }

    public static RealInterval tan2pi(RealInterval realInterval) {
        return IAMath.div(IAMath.sin2pi(realInterval), IAMath.cos2pi(realInterval));
    }

    public static RealInterval asin2pi(RealInterval realInterval) throws IAException {
        RealInterval realInterval2 = new RealInterval();
        realInterval.intersect(new RealInterval(-1.0, 1.0));
        realInterval2.lo = RMath.asin2pi_lo(realInterval.lo);
        realInterval2.hi = RMath.asin2pi_hi(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval acos2pi(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = RMath.acos2pi_lo(realInterval.hi);
        realInterval2.hi = RMath.acos2pi_hi(realInterval.lo);
        return realInterval2;
    }

    public static RealInterval atan2pi(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = RMath.atan2pi_lo(realInterval.lo);
        realInterval2.hi = RMath.atan2pi_hi(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval midpoint(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.hi = realInterval2.lo = (realInterval.lo + realInterval.hi) / 2.0;
        if (Double.NEGATIVE_INFINITY < realInterval2.lo && Double.POSITIVE_INFINITY > realInterval2.lo) {
            return realInterval2;
        }
        if (Double.NEGATIVE_INFINITY == realInterval.lo) {
            if (realInterval.hi > 0.0) {
                realInterval2.hi = realInterval2.lo = 0.0;
                return realInterval2;
            }
            if (realInterval.hi == 0.0) {
                realInterval2.hi = realInterval2.lo = -1.0;
                return realInterval2;
            }
            realInterval2.hi = realInterval2.lo = realInterval.hi * 2.0;
            return realInterval2;
        }
        if (Double.POSITIVE_INFINITY == realInterval.hi) {
            if (realInterval.lo < 0.0) {
                realInterval2.hi = realInterval2.lo = 0.0;
                return realInterval2;
            }
            if (realInterval.lo == 0.0) {
                realInterval2.hi = realInterval2.lo = 1.0;
                return realInterval2;
            }
            realInterval2.hi = realInterval2.lo = realInterval.lo * 2.0;
            return realInterval2;
        }
        realInterval2.lo = realInterval.lo;
        realInterval2.hi = realInterval.hi;
        System.out.println("Error in RealInterval.midpoint");
        return realInterval2;
    }

    public static RealInterval leftendpoint(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = realInterval.lo;
        if (Double.NEGATIVE_INFINITY < realInterval2.lo && Double.POSITIVE_INFINITY > realInterval2.lo) {
            realInterval2.hi = realInterval2.lo;
            return realInterval2;
        }
        realInterval2.hi = realInterval2.lo = RMath.nextfp(realInterval.lo);
        return realInterval2;
    }

    public static RealInterval rightendpoint(RealInterval realInterval) {
        RealInterval realInterval2 = new RealInterval();
        realInterval2.lo = realInterval.hi;
        if (Double.NEGATIVE_INFINITY < realInterval2.lo && Double.POSITIVE_INFINITY > realInterval2.lo) {
            realInterval2.hi = realInterval2.lo;
            return realInterval2;
        }
        realInterval2.hi = realInterval2.lo = RMath.prevfp(realInterval.hi);
        return realInterval2;
    }

    public static RealInterval power(RealInterval realInterval, RealInterval realInterval2) throws IAException {
        if (realInterval.hi <= 0.0) {
            throw new IAException("power(X,Y): X<=0 not allowed");
        }
        if (realInterval.lo < 0.0) {
            realInterval.lo = 0.0;
        }
        RealInterval realInterval3 = IAMath.exp(IAMath.mul(realInterval2, IAMath.log(realInterval)));
        return realInterval3;
    }

    public static RealInterval evenPower(RealInterval realInterval, double d) throws IAException {
        double d2;
        double d3;
        if (d == 0.0) {
            return new RealInterval(1.0);
        }
        if (d > 0.0) {
            if (realInterval.lo >= 0.0) {
                d3 = RMath.pow_lo(realInterval.lo, d);
                d2 = RMath.pow_hi(realInterval.hi, d);
            } else if (realInterval.hi <= 0.0) {
                d3 = RMath.pow_lo(-realInterval.hi, d);
                d2 = RMath.pow_hi(-realInterval.lo, d);
            } else {
                d3 = 0.0;
                d2 = Math.max(RMath.pow_lo(-realInterval.lo, d), RMath.pow_hi(realInterval.hi, d));
            }
        } else {
            if (d < 0.0) {
                return IAMath.div(new RealInterval(1.0), IAMath.evenPower(realInterval, -d));
            }
            throw new IAException("evenPower(X,y): y=Nan not allowed");
        }
        return new RealInterval(d3, d2);
    }

    public static RealInterval oddPower(RealInterval realInterval, double d) throws IAException {
        double d2;
        double d3;
        if (d == 0.0) {
            if (realInterval.lo > 0.0) {
                return new RealInterval(1.0);
            }
            if (realInterval.hi < 0.0) {
                return new RealInterval(-1.0);
            }
            return new RealInterval(-1.0, 1.0);
        }
        if (d > 0.0) {
            if (realInterval.lo >= 0.0) {
                d3 = RMath.pow_lo(realInterval.lo, d);
                d2 = RMath.pow_hi(realInterval.hi, d);
            } else if (realInterval.hi <= 0.0) {
                d3 = -RMath.pow_hi(-realInterval.lo, d);
                d2 = -RMath.pow_lo(-realInterval.hi, d);
            } else {
                d3 = -RMath.pow_hi(-realInterval.lo, d);
                d2 = RMath.pow_hi(realInterval.hi, d);
            }
        } else {
            if (d < 0.0) {
                return IAMath.div(new RealInterval(1.0), IAMath.oddPower(realInterval, -d));
            }
            throw new IAException("oddPower(X,y): X = NaN not allowed");
        }
        return new RealInterval(d3, d2);
    }

    public static RealInterval evenRoot(RealInterval realInterval, double d) throws IAException {
        if (d == 0.0) {
            throw new IAException("evenRoot(X,y): y=0 not allowed");
        }
        if (d > 0.0) {
            double d2;
            double d3 = RMath.div_lo(1.0, d);
            double d4 = RMath.div_hi(1.0, d);
            double d5 = realInterval.lo >= 1.0 ? RMath.pow_lo(realInterval.lo, d3) : (realInterval.lo >= 0.0 ? RMath.pow_lo(realInterval.lo, d4) : 0.0);
            if (realInterval.hi >= 1.0) {
                d2 = RMath.pow_hi(realInterval.hi, d4);
            } else if (realInterval.lo >= 0.0) {
                d2 = RMath.pow_hi(realInterval.hi, d3);
            } else {
                throw new IAException("evenRoot(X,y): X <=0 not allowed");
            }
            return new RealInterval(d5, d2);
        }
        if (d < 0.0) {
            return IAMath.div(new RealInterval(1.0), IAMath.evenRoot(realInterval, -d));
        }
        throw new IAException("evenRoot(X,y): y=NaN not allowed");
    }

    public static RealInterval oddRoot(RealInterval realInterval, double d) throws IAException {
        if (d == 0.0) {
            return RealInterval.fullInterval();
        }
        if (d > 0.0) {
            double d2 = RMath.div_lo(1.0, d);
            double d3 = RMath.div_hi(1.0, d);
            double d4 = realInterval.lo >= 1.0 ? RMath.pow_lo(realInterval.lo, d2) : (realInterval.lo >= 0.0 ? RMath.pow_lo(realInterval.lo, d3) : (realInterval.lo >= -1.0 ? -RMath.pow_hi(-realInterval.lo, d2) : -RMath.pow_hi(-realInterval.lo, d3)));
            double d5 = realInterval.hi >= 1.0 ? RMath.pow_hi(realInterval.hi, d3) : (realInterval.hi >= 0.0 ? RMath.pow_hi(realInterval.hi, d2) : (realInterval.hi >= -1.0 ? -RMath.pow_lo(-realInterval.hi, d3) : -RMath.pow_lo(-realInterval.hi, d2)));
            return new RealInterval(d4, d5);
        }
        if (d < 0.0) {
            return IAMath.div(new RealInterval(1.0), IAMath.oddRoot(realInterval, -d));
        }
        throw new IAException("oddRoot(X,y): y=NaN not allowed");
    }

    public static RealInterval integerPower(RealInterval realInterval, RealInterval realInterval2) throws IAException {
        if (realInterval2.lo != realInterval2.hi || Math.IEEEremainder(realInterval2.lo, 1.0) != 0.0) {
            return RealInterval.fullInterval();
        }
        double d = realInterval2.lo;
        if (Math.IEEEremainder(d, 2.0) == 0.0) {
            return IAMath.evenPower(realInterval, d);
        }
        return IAMath.oddPower(realInterval, d);
    }

    public static RealInterval integerRoot(RealInterval realInterval, RealInterval realInterval2) throws IAException {
        if (realInterval2.lo != realInterval2.hi || Math.IEEEremainder(realInterval2.lo, 1.0) != 0.0) {
            return RealInterval.fullInterval();
        }
        double d = realInterval2.lo;
        if (Math.IEEEremainder(d, 2.0) == 0.0) {
            return IAMath.evenRoot(realInterval, d);
        }
        return IAMath.oddRoot(realInterval, d);
    }

    public static boolean intersectIntegerRoot(RealInterval realInterval, RealInterval realInterval2, RealInterval realInterval3) throws IAException {
        if (realInterval2.lo != realInterval2.hi || Math.IEEEremainder(realInterval2.lo, 1.0) != 0.0) {
            return true;
        }
        double d = realInterval2.lo;
        if (Math.IEEEremainder(d, 2.0) != 0.0) {
            realInterval3.intersect(IAMath.oddRoot(realInterval, d));
        } else {
            RealInterval realInterval4 = IAMath.evenRoot(realInterval, d);
            if (realInterval3.hi < realInterval4.lo) {
                realInterval3.intersect(IAMath.uminus(realInterval4));
            } else if (-realInterval4.lo < realInterval3.lo) {
                realInterval3.intersect(realInterval4);
            } else {
                realInterval3.intersect(new RealInterval(-realInterval4.hi, realInterval4.hi));
            }
        }
        return true;
    }

    public static void main(String[] stringArray) {
        RealInterval realInterval = new RealInterval(5.0);
        RealInterval realInterval2 = IAMath.log(realInterval);
        RealInterval realInterval3 = IAMath.exp(realInterval2);
        System.out.println("a= " + realInterval);
        System.out.println("log(a)= " + realInterval2);
        System.out.println("exp(log(a))= " + realInterval3);
        try {
            realInterval = new RealInterval(-5.0, 0.0);
            realInterval3 = IAMath.exp(IAMath.log(realInterval));
            System.out.println("a= " + realInterval);
            System.out.println("exp(log(a))= " + realInterval3);
        }
        catch (Exception exception) {
            System.out.println("Caught exception " + exception);
        }
    }
}

