/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mortbay.util.Code;
import org.mortbay.util.InetAddrPort;
import org.mortbay.util.Log;
import org.mortbay.util.ThreadPool;

public abstract class ThreadedServer
extends ThreadPool {
    private InetAddrPort _address = null;
    private int _soTimeOut = -1;
    private int _lingerTimeSecs = 30;
    private transient Acceptor _acceptor = null;
    private transient ServerSocket _listen = null;
    private transient boolean _running = false;

    public ThreadedServer() {
    }

    public ServerSocket getServerSocket() {
        return this._listen;
    }

    public ThreadedServer(int port) {
        this.setInetAddrPort(new InetAddrPort(port));
    }

    public ThreadedServer(InetAddress address, int port) {
        this.setInetAddrPort(new InetAddrPort(address, port));
    }

    public ThreadedServer(String host, int port) throws UnknownHostException {
        this.setInetAddrPort(new InetAddrPort(host, port));
    }

    public ThreadedServer(InetAddrPort address) {
        this.setInetAddrPort(address);
    }

    public synchronized void setInetAddrPort(InetAddrPort address) {
        if (this._address != null && this._address.equals(address)) {
            return;
        }
        if (this.isStarted()) {
            Log.warning(this + " is started");
        }
        this._address = address;
    }

    public InetAddrPort getInetAddrPort() {
        if (this._address == null) {
            return null;
        }
        return new InetAddrPort(this._address);
    }

    public synchronized void setHost(String host) throws UnknownHostException {
        if (this._address != null && this._address.getHost() != null && this._address.getHost().equals(host)) {
            return;
        }
        if (this.isStarted()) {
            Log.warning(this + " is started");
        }
        if (this._address == null) {
            this._address = new InetAddrPort(host, 0);
        } else {
            this._address.setHost(host);
        }
    }

    public String getHost() {
        if (this._address == null || this._address.getInetAddress() == null) {
            return null;
        }
        return this._address.getHost();
    }

    public synchronized void setInetAddress(InetAddress addr) {
        if (this._address != null && this._address.getInetAddress() != null && this._address.getInetAddress().equals(addr)) {
            return;
        }
        if (this.isStarted()) {
            Log.warning(this + " is started");
        }
        if (this._address == null) {
            this._address = new InetAddrPort(addr, 0);
        } else {
            this._address.setInetAddress(addr);
        }
    }

    public InetAddress getInetAddress() {
        if (this._address == null) {
            return null;
        }
        return this._address.getInetAddress();
    }

    public synchronized void setPort(int port) {
        if (this._address != null && this._address.getPort() == port) {
            return;
        }
        if (this.isStarted()) {
            Log.warning(this + " is started");
        }
        if (this._address == null) {
            this._address = new InetAddrPort(port);
        } else {
            this._address.setPort(port);
        }
    }

    public int getPort() {
        if (this._address == null) {
            return 0;
        }
        return this._address.getPort();
    }

    public void setMaxReadTimeMs(int ms) {
        Code.warning("setMaxReadTimeMs is deprecated. Use setMaxIdleTimeMs()");
    }

    public int getMaxReadTimeMs() {
        return this.getMaxIdleTimeMs();
    }

    public void setLingerTimeSecs(int ls) {
        this._lingerTimeSecs = ls;
    }

    public int getLingerTimeSecs() {
        return this._lingerTimeSecs;
    }

    protected void handleConnection(InputStream in, OutputStream out) {
        throw new Error("Either handlerConnection must be overridden");
    }

    protected void handleConnection(Socket connection) throws IOException {
        Code.debug((Object)"Handle ", (Object)connection);
        InputStream in = connection.getInputStream();
        OutputStream out = connection.getOutputStream();
        this.handleConnection(in, out);
        out.flush();
        in = null;
        out = null;
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void handle(Object job) {
        block8: {
            Socket socket = (Socket)job;
            this.handleConnection(socket);
            Object var5_3 = null;
            try {
                socket.close();
            }
            catch (Exception e2) {
                Code.warning("Connection problem", e2);
            }
            break block8;
            {
                catch (Exception e) {
                    Code.warning("Connection problem", e);
                    Object var5_4 = null;
                    try {
                        socket.close();
                    }
                    catch (Exception e2) {
                        Code.warning("Connection problem", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    socket.close();
                }
                catch (Exception e2) {
                    Code.warning("Connection problem", e2);
                }
                throw throwable;
            }
        }
    }

    protected ServerSocket newServerSocket(InetAddrPort address, int acceptQueueSize) throws IOException {
        if (address == null) {
            return new ServerSocket(0, acceptQueueSize);
        }
        return new ServerSocket(address.getPort(), acceptQueueSize, address.getInetAddress());
    }

    protected Socket acceptSocket(ServerSocket serverSocket, int timeout) {
        block11: {
            try {
                Socket s = null;
                if (this._soTimeOut != timeout) {
                    this._soTimeOut = timeout;
                    this._listen.setSoTimeout(this._soTimeOut);
                }
                if (this._listen != null) {
                    s = this._listen.accept();
                    try {
                        if (this.getMaxIdleTimeMs() >= 0) {
                            s.setSoTimeout(this.getMaxIdleTimeMs());
                        }
                        if (this._lingerTimeSecs >= 0) {
                            s.setSoLinger(true, this._lingerTimeSecs);
                        } else {
                            s.setSoLinger(false, 0);
                        }
                    }
                    catch (Exception e) {
                        Code.ignore(e);
                    }
                }
                return s;
            }
            catch (SocketException e) {
                Code.ignore(e);
            }
            catch (InterruptedIOException e) {
                if (!Code.verbose(99)) break block11;
                Code.ignore(e);
            }
            catch (IOException e) {
                Code.warning(e);
            }
        }
        return null;
    }

    public void open() throws IOException {
        if (this._listen == null) {
            this._listen = this.newServerSocket(this._address, this.getMaxThreads() > 0 ? this.getMaxThreads() + 1 : 50);
            if (this._address == null) {
                this._address = new InetAddrPort(this._listen.getInetAddress(), this._listen.getLocalPort());
            } else {
                if (this._address.getInetAddress() == null) {
                    this._address.setInetAddress(this._listen.getInetAddress());
                }
                if (this._address.getPort() == 0) {
                    this._address.setPort(this._listen.getLocalPort());
                }
            }
            this._soTimeOut = this.getMaxIdleTimeMs();
            if (this._soTimeOut >= 0) {
                this._listen.setSoTimeout(this._soTimeOut);
            }
        }
    }

    public synchronized void start() throws Exception {
        try {
            if (this.isStarted()) {
                return;
            }
            this.open();
            this._running = true;
            this._acceptor = new Acceptor();
            this._acceptor.setDaemon(this.isDaemon());
            this._acceptor.start();
            super.start();
        }
        catch (Exception e) {
            Code.warning("Failed to start: " + this);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        ThreadedServer threadedServer = this;
        synchronized (threadedServer) {
            this._running = false;
            Code.debug((Object)"closing ", (Object)this._listen);
            try {
                if (this._listen != null) {
                    this._listen.close();
                }
            }
            catch (IOException e) {
                Code.warning(e);
            }
            Thread.yield();
            if (this._acceptor != null) {
                this._acceptor.interrupt();
                this.wait(this.getMaxIdleTimeMs());
                if (this._acceptor != null) {
                    this._acceptor.forceStop();
                    this._acceptor = null;
                }
            }
        }
        try {
            super.stop();
        }
        catch (Exception e) {
            Code.warning(e);
        }
        this._listen = null;
        this._acceptor = null;
    }

    protected void stopJob(Thread thread, Object job) {
        if (job instanceof Socket) {
            try {
                ((Socket)job).close();
            }
            catch (Exception e) {
                Code.ignore(e);
            }
        }
        super.stopJob(thread, job);
    }

    public String toString() {
        if (this._address == null) {
            return this.getName() + "@0.0.0.0:0";
        }
        if (this._listen != null) {
            return this.getName() + "@" + this._listen.getInetAddress().getHostAddress() + ":" + this._listen.getLocalPort();
        }
        return this.getName() + "@" + this.getInetAddrPort();
    }

    private class Acceptor
    extends Thread {
        private Acceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            ThreadedServer threadedServer = ThreadedServer.this;
            try {
                this.setName("Acceptor " + ThreadedServer.this._listen);
                while (ThreadedServer.this._running) {
                    try {
                        Socket socket = ThreadedServer.this.acceptSocket(ThreadedServer.this._listen, ThreadedServer.this._soTimeOut);
                        if (ThreadedServer.this._running) {
                            if (socket == null) {
                                threadedServer.shrink();
                                continue;
                            }
                            threadedServer.run(socket);
                            continue;
                        }
                        if (socket == null) continue;
                        socket.close();
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        if (ThreadedServer.this._running) {
                            Code.warning(e);
                            continue;
                        }
                        Code.debug(e);
                    }
                    catch (Error e) {
                        Code.warning(e);
                        break;
                    }
                }
            }
            finally {
                if (ThreadedServer.this._running) {
                    Code.warning("Stopping " + this.getName());
                } else {
                    Log.event("Stopping " + this.getName());
                }
                ThreadedServer threadedServer2 = threadedServer;
                synchronized (threadedServer2) {
                    ThreadedServer.this._acceptor = null;
                    threadedServer.notifyAll();
                }
            }
        }

        void forceStop() {
            block3: {
                if (ThreadedServer.this._listen == null || ThreadedServer.this._address == null) break block3;
                InetAddress addr = ThreadedServer.this._address.getInetAddress();
                try {
                    if (addr == null || addr.toString().startsWith("0.0.0.0")) {
                        addr = InetAddress.getByName("127.0.0.1");
                    }
                    Code.debug("Self connect to close listener ", addr, ":" + ThreadedServer.this._address.getPort());
                    Socket socket = new Socket(addr, ThreadedServer.this._address.getPort());
                    Thread.yield();
                    socket.close();
                    Thread.yield();
                }
                catch (IOException e) {
                    Code.debug((Object)"problem stopping acceptor ", addr, (Object)": ", e);
                }
            }
        }
    }
}

