/*
  Copyright(C) 2002-2007 Pierre Mazire
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

/*
  scapi.h

  Simple Configuration API
*/

#ifndef SCAPI_SCAPI_H
#define SCAPI_SCAPI_H

#include <stdio.h>

extern FILE *Libscapi_out;
extern FILE *Libscapi_err;

extern unsigned int Libscapi_WARNING_On;
extern unsigned int Libscapi_ERROR_On;
extern unsigned int Libscapi_OUTPUT_On;
extern unsigned int Libscapi_DEBUG_On;
extern unsigned int Libscapi_HEADER_OUTPUT_On;
extern unsigned int Libscapi_HEADER_WARNING_On;
extern unsigned int Libscapi_HEADER_ERROR_On;
extern unsigned int Libscapi_HEADER_DEBUG_On;
extern unsigned int Libscapi_HEADER_OUTPUT_LIBNAME_On;
extern unsigned int Libscapi_HEADER_WARNING_LIBNAME_On;
extern unsigned int Libscapi_HEADER_ERROR_LIBNAME_On;
extern unsigned int Libscapi_HEADER_DEBUG_LIBNAME_On;


typedef enum e_OptionType {NO_ARG=0,FREE_ARG,SET_ARG} e_OptionType;
typedef enum e_OptionFlags {SCAPI_NO_FLAGS=0x00,
			    SCAPI_OPTION_USED=0x01,
			    SCAPI_MULTIPLE_ARGS=0x02} e_OptionFlags;

typedef struct s_Option
{
  e_OptionType Type; 
  unsigned char *Name;
  unsigned char *ShortName;
  unsigned char *ConfFileName;
  void (*ConfFileFunc)();
  unsigned int NbrSetArgs;
  unsigned char **SetArgs;
  unsigned char *ArgDescription;
  e_OptionFlags Flags;
  unsigned char *Separator;
  unsigned int NbrArgs;
  unsigned char **Args;
  unsigned char *Help;
} s_Option;

typedef struct s_Context
{
  unsigned char *Title;
  unsigned char *Author;
  unsigned char *Copyright;
  unsigned int VerMaj;
  unsigned int VerMin;
  unsigned int VerMisc;
  unsigned char *GlobalConfFile;
  unsigned char *LocalConfFile;
  unsigned int NbrOptions;
  s_Option **Options;
} s_Context;

typedef struct s_Options
{
  unsigned char *Title;
  unsigned char *Author;
  unsigned char *Copyright;
  unsigned int VerMaj;
  unsigned int VerMin;
  unsigned int VerMisc;
  unsigned char *Usage;  
  unsigned int NbrContexts;
  s_Context **Contexts;
  unsigned int NbrUnknownTokens;
  unsigned char **UnknownTokens;
} s_Options;

s_Options *InitOptions(unsigned char *Title,
		       unsigned char *Author,
		       unsigned char *Copyright,
		       unsigned int VerMaj,
		       unsigned int VerMin,
		       unsigned int VerMisc);

s_Options *AddContext(s_Options *Options,
		      s_Context *Context);

s_Options *SetOptionsUsage(s_Options *Options,unsigned char *Usage);

s_Options *ParseConfFile(s_Options *Options,
			 s_Context *Context,
			 unsigned char *File);

s_Options *ParseOptions(s_Options *Options,unsigned int argc,
			char **argv);

unsigned int GetOption(s_Options *Options,unsigned char *Option,
		       unsigned char ***Value);

void FreeOptions(s_Options *Options);

s_Context *InitContext(unsigned char *Title,
		       unsigned char *Author,
		       unsigned char *Copyright,
		       unsigned int VerMaj,
		       unsigned int VerMin,
		       unsigned int VerMisc);

s_Context *SetGlobalConfFile(s_Context *Context,unsigned char *File);

s_Context *SetLocalConfFile(s_Context *Context,unsigned char *File);

void DisplayOptionsHelp(s_Options *Options,
		     unsigned int SizeColumnOptionNames,
		     unsigned int SizeColumnOptionHelp);

s_Context *AddOption(s_Options *Options,
		     s_Context *Context, 
		     unsigned char *Name,
		     e_OptionType Type);

s_Context *SetOptionFlags(s_Context *Context,
			  unsigned char *Option,
			  e_OptionFlags Flags);

s_Context *SetOptionSeparator(s_Context *Context,
			      unsigned char *Option,
			      unsigned char *Separator);

s_Context *SetOptionShortName(s_Options *Options,
			      s_Context *Context, 
			      unsigned char *Option,
			      unsigned char *ShortName);

s_Context *SetOptionConfFileName(s_Options *Options,
				 s_Context *Context,
				 unsigned char *Option,
				 unsigned char *token,
				 void (*Function)(s_Option *,s_Context *));

s_Context *SetOptionDefaultValue(s_Context *Context,
				 unsigned char *Option,
				 unsigned char *Value);

s_Context *SetOptionHelp(s_Context *Context, 
			 unsigned char *Option,
			 unsigned char *ArgDescription,
			 unsigned char *Help);

s_Context *AddOptionArg(s_Context *Context,unsigned char *Option,
			unsigned char *Arg);

void FreeContext(s_Context *Context);

unsigned char *SCAPI_ReadConfNextToken(void);

#endif
