/********************************************************************************************************
 * QRNA - Comparative analysis of biological sequences 
 *         with pair hidden Markov models, pair stochastic context-free
 *        grammars, and probabilistic evolutionary  models.
 *       
 * Version 2.0.0 (JUN 2003)
 *
 * Copyright (C) 2000-2003 Howard Hughes Medical Institute/Washington University School of Medicine
 * All Rights Reserved
 * 
 *     This source code is distributed under the terms of the
 *     GNU General Public License. See the files COPYING and LICENSE
 *     for details.
 ***********************************************************************************************************/

/* matrix.h
 * ANSI prototypes for all external functions.
 * 
 */
#ifndef FUNCSH_INCLUDED
#define FUNCSH_INCLUDED

#include <stdio.h>
/* from matrix.c: functions for matrix manipulations
 */
extern double *Cal_Id(int L);
extern double *Cal_LUP_Decomp(FILE *ofp, double *M, int *perm, int L, int verbose);
extern double *Cal_M_Exp(FILE *ofp, double *M, int L, double power, int verbose);
extern double *Cal_M_Inv(FILE *ofp, double *M, int L, int verbose);
extern double *Cal_M_Log(FILE *ofp, double *M, int L, int verbose);
extern double *Cal_M_MinId(double *M, int L);
extern double *Cal_M_num_Prod(FILE *ofp, double *M, double num, int Li, int Lj, int verbose);
extern double *Cal_M_N_Prod(FILE *ofp, double *M, double *N, int Li, int Lj, int Lk, int verbose);
extern double *Cal_M_N_Sum(FILE *ofp, double *M, double *N, int Li, int Lj, int add, int verbose);
extern double *Col_From_M(double *A, int Lrow, int Lcol, int col_i);
extern void    Comp_Id(double *Id, int L);
extern void    Comp_M_Exp(FILE *ofp, double *M, int L, double power, int verbose);
extern void    Comp_M_Inv(FILE *ofp, double *M, int L, int verbose);
extern void    Comp_M_Log(FILE *ofp, double *M, int L, int verbose);
extern void    Comp_M_MinId(double *M, int L);
extern void    Comp_M_num_Prod(FILE *ofp, double *M, double num, int Li, int Lj, int verbose);
extern void    Comp_M_N_Prod(FILE *ofp, double *M, double *N, int L, int verbose);
extern void    Comp_M_N_Sum(FILE *ofp, double *M, double *N, int Li, int Lj, int add, int verbose);
extern void    CopyMatrix (double *copyQ, double *Q, int N, int M);
extern int     IsDiagonal (double *A, int dim);
extern double *HessenbergForm(FILE *ofp, double *A, int L);
extern void    Hessenberg2Eigenvalues(FILE *ofp, double *H, int L, struct eigenvalue_s **ret_eigen, int pedantic, int verbose);
extern void    QR_Decomposition (FILE *ofp, double *X, double *Q, double *R, int n, int pedantic, int verbose);
extern double *Row_From_M(double *A, int Lrow, int Lcol, int row_i);
extern void    SecondDegree_Solutions(double a, double b, double c, struct eigenvalue_s *eigen, int idx);
extern void    Solve_LU_Eq(FILE *ofp, double *LU, double *b, int L, int verbose);

#endif /*FUNCSH_INCLUDED*/

