function testPlatform(re) {
  var _window$navigator$use;
  return typeof window !== 'undefined' && window.navigator != null ?
  //@ts-expect-error ignore userAgentData type issue
  re.test(((_window$navigator$use = window.navigator['userAgentData']) === null || _window$navigator$use === void 0 ? void 0 : _window$navigator$use.platform) || window.navigator.platform) : false;
}
function isIPhone() {
  return testPlatform(/^iPhone/i);
}
function isMac() {
  return testPlatform(/^Mac/i);
}
function isIPad() {
  return testPlatform(/^iPad/i) ||
  // iPadOS 13 lies and says it's a Mac, but we can distinguish by detecting touch support.
  // eslint-disable-next-line compat/compat
  isMac() && navigator.maxTouchPoints > 1;
}
function isIOS() {
  return isIPhone() || isIPad();
}
export function isSafari() {
  if (typeof window !== 'undefined' && window.navigator != null) {
    var _window$navigator$use2;
    var ua = (_window$navigator$use2 = window.navigator.userAgent) === null || _window$navigator$use2 === void 0 ? void 0 : _window$navigator$use2.toLowerCase();
    return ua ? ua.includes('safari') && !ua.includes('chrome') : false;
  }
  return false;
}
export function isAppleDevice() {
  return isMac() || isIOS();
}