// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using Xunit;

namespace System.DirectoryServices.Tests
{
    public class ActiveDirectorySecurityTests
    {
        [Fact]
        public void Ctor_Default()
        {
            var security = new ActiveDirectorySecurity();
            Assert.Equal(typeof(ActiveDirectoryRights), security.AccessRightType);
            Assert.Equal(typeof(ActiveDirectoryAccessRule), security.AccessRuleType);
            Assert.Equal(typeof(ActiveDirectoryAuditRule), security.AuditRuleType);
        }
    }
}
