/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.language.sql.GeneratorSql;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomainMapper {
    private static final ConfigurationKey MAPPING_KEY = Configuration.makeKey((String)"sql", (String)"domainmapping");
    private static final String ROOT_TAG = "<tns:mappings xmlns:tns=\"http://www.argouml.org/Namespace/argouml-sql\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.argouml.org/Namespace/argouml-sql domainmapping.xsd \">";
    private static final String XML_FILE_NAME = "domainmapping.xml";
    private static final String XML_TAG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private Map<String, Map<String, String>> databases = new HashMap<String, Map<String, String>>();
    private String indent;
    private static final Logger LOG = Logger.getLogger(DomainMapper.class);

    public DomainMapper() {
        this.load();
    }

    public void clear(Class codeCreatorClass) {
        this.getMappingsFor(codeCreatorClass).clear();
    }

    public String getDatatype(Class codeCreatorClass, String domain) {
        String dt;
        Map<String, String> mappings = this.getMappingsFor(codeCreatorClass);
        String datatype = domain;
        if (mappings != null && (dt = mappings.get(domain)) != null) {
            datatype = dt;
        }
        return datatype;
    }

    private Map<String, String> getMappingsFor(String codeCreatorClassName) {
        Map<String, String> mappings = this.databases.get(codeCreatorClassName);
        if (mappings == null) {
            mappings = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.databases.put(codeCreatorClassName, mappings);
        }
        return mappings;
    }

    public Map<String, String> getMappingsFor(Class codeCreatorClass) {
        return this.getMappingsFor(codeCreatorClass.getName());
    }

    private InputStream getDomainMap() {
        String domainMap = Configuration.getString((ConfigurationKey)MAPPING_KEY);
        InputStream is = new StringBufferInputStream(domainMap);
        if ("".equals(domainMap)) {
            try {
                URL url = this.getClass().getResource(XML_FILE_NAME).toURI().toURL();
                is = url.openStream();
            }
            catch (URISyntaxException e) {
                LOG.warn((Object)"Could not find domainmapping file", (Throwable)e);
            }
            catch (MalformedURLException e) {
                LOG.warn((Object)"Could not find domainmapping file", (Throwable)e);
            }
            catch (IOException e) {
                LOG.warn((Object)"Error reading/fetching domain map", (Throwable)e);
            }
        }
        return is;
    }

    public void load() {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = docBuilder.parse(this.getDomainMap());
            Element root = document.getDocumentElement();
            NodeList childs = root.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                if (child.getNodeType() != 1) continue;
                NamedNodeMap attributes = child.getAttributes();
                String name = attributes.getNamedItem("name").getTextContent();
                Map<String, String> mappings = this.getMappingsFor(name);
                this.readMappings(mappings, child.getChildNodes());
            }
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
    }

    public void save() {
        StringWriter sw = new StringWriter(1024);
        try {
            ((Writer)sw).write(XML_TAG);
            ((Writer)sw).write(GeneratorSql.LINE_SEPARATOR);
            ((Writer)sw).write(ROOT_TAG);
            ((Writer)sw).write(GeneratorSql.LINE_SEPARATOR);
            this.indent = "\t";
            Set<Map.Entry<String, Map<String, String>>> dbEntries = this.databases.entrySet();
            for (Map.Entry<String, Map<String, String>> entry : dbEntries) {
                String className = entry.getKey();
                Map<String, String> mappings = entry.getValue();
                StringBuffer sb = new StringBuffer();
                sb.append(this.indent);
                sb.append("<tns:database name=\"");
                sb.append(className);
                sb.append("\">").append(GeneratorSql.LINE_SEPARATOR);
                ((Writer)sw).write(sb.toString());
                this.writeMappings(sw, mappings);
                ((Writer)sw).write("</tns:database>");
            }
            ((Writer)sw).write("</tns:mappings>");
            ((Writer)sw).close();
        }
        catch (IOException e) {
            LOG.error((Object)"Exception", (Throwable)e);
        }
        Configuration.setString((ConfigurationKey)MAPPING_KEY, (String)((Object)sw).toString());
    }

    public void setDatatype(Class codeCreatorClass, String domain, String datatype) {
        Map<String, String> mappings = this.getMappingsFor(codeCreatorClass);
        mappings.put(domain, datatype);
    }

    private void readMappings(Map<String, String> mappings, NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node mapping = nodes.item(i);
            if (mapping.getNodeType() != 1) continue;
            NamedNodeMap attributes = mapping.getAttributes();
            Node src = attributes.getNamedItem("umltype");
            Node dst = attributes.getNamedItem("dbtype");
            String srcText = src.getTextContent();
            String dstText = dst.getTextContent();
            mappings.put(srcText, dstText);
        }
    }

    private void writeMappings(Writer fw, Map<String, String> mappings) throws IOException {
        String oldIndent = this.indent;
        this.indent = this.indent + "\t";
        Set<Map.Entry<String, String>> entries = mappings.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String domain = entry.getKey();
            String datatype = entry.getValue();
            StringBuffer sb = new StringBuffer();
            sb.append(this.indent);
            sb.append("<tns:mapping umltype=\"");
            sb.append(domain);
            sb.append("\" dbtype=\"");
            sb.append(datatype);
            sb.append("\" />").append(GeneratorSql.LINE_SEPARATOR);
            fw.write(sb.toString());
        }
        this.indent = oldIndent;
    }
}

