/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.util.List;
import org.argouml.language.sql.ColumnDefinition;
import org.argouml.language.sql.ForeignKeyDefinition;
import org.argouml.language.sql.SqlCodeCreator;
import org.argouml.language.sql.TableDefinition;
import org.argouml.language.sql.Utils;

public class FirebirdSqlCodeCreator
implements SqlCodeCreator {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private int primaryKeyCounter;
    private int exceptionCounter;

    public FirebirdSqlCodeCreator() {
        this.resetCounters();
    }

    public void resetCounters() {
        this.primaryKeyCounter = 1;
        this.exceptionCounter = 1;
    }

    public String createForeignKey(ForeignKeyDefinition foreignKeyDefinition) {
        String tableName = foreignKeyDefinition.getTableName();
        List<String> columnNames = foreignKeyDefinition.getColumnNames();
        String referencesTableName = foreignKeyDefinition.getReferencesTableName();
        List<String> referencesColumnNames = foreignKeyDefinition.getReferencesColumnNames();
        String foreignKeyName = foreignKeyDefinition.getForeignKeyName();
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEPARATOR);
        sb.append("ALTER TABLE ").append(tableName);
        sb.append(" ADD CONSTRAINT ").append(foreignKeyName).append(LINE_SEPARATOR);
        sb.append("FOREIGN KEY (");
        sb.append(Utils.stringsToCommaString(columnNames));
        sb.append(") REFERENCES ");
        sb.append(referencesTableName).append(" (");
        sb.append(Utils.stringsToCommaString(referencesColumnNames));
        sb.append(")");
        int refLower = foreignKeyDefinition.getReferencesLower();
        if (refLower == 0) {
            sb.append(" ON DELETE SET NULL");
        } else {
            sb.append(" ON DELETE CASCADE");
        }
        sb.append(";").append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        int upper = foreignKeyDefinition.getUpper();
        if (upper == 1) {
            sb.append(this.getOneToOneTrigger(foreignKeyDefinition));
        }
        return sb.toString();
    }

    private String getOneToOneTriggerBody(ForeignKeyDefinition fkDef, String exceptionName) {
        String tableName = fkDef.getTableName();
        StringBuffer sb = new StringBuffer();
        sb.append("    DECLARE VARIABLE x INTEGER;").append(LINE_SEPARATOR);
        sb.append("BEGIN").append(LINE_SEPARATOR);
        sb.append("    ");
        sb.append("SELECT COUNT(*) FROM ").append(tableName);
        sb.append(" WHERE ");
        StringBuffer sbWhere = new StringBuffer();
        List<String> columnNames = fkDef.getColumnNames();
        for (int i = 0; i < columnNames.size(); ++i) {
            if (sbWhere.length() > 0) {
                sbWhere.append(" AND ");
            }
            String colName = columnNames.get(i);
            sbWhere.append(colName);
            sbWhere.append(" = NEW.").append(colName);
        }
        List pkFields = fkDef.getTable().getPrimaryKeyFields();
        for (int i = 0; i < pkFields.size(); ++i) {
            String pkFieldName = (String)pkFields.get(i);
            sbWhere.append(" AND ").append(pkFieldName);
            sbWhere.append(" <> NEW.").append(pkFieldName);
            sbWhere.append(" ");
        }
        sb.append(sbWhere).append(" INTO :x;").append(LINE_SEPARATOR);
        sb.append("    IF (:x = 1) THEN").append(LINE_SEPARATOR);
        sb.append("        ");
        sb.append("EXCEPTION ").append(exceptionName);
        sb.append(";").append(LINE_SEPARATOR);
        sb.append("END !!").append(LINE_SEPARATOR);
        return sb.toString();
    }

    private String getOneToOneTrigger(ForeignKeyDefinition fkDef) {
        String excName1to1violated = "EXC_ONE_TO_ONE_VIOLATED" + this.exceptionCounter;
        ++this.exceptionCounter;
        String tableName = fkDef.getTableName();
        String referencesTableName = fkDef.getReferencesTableName();
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE EXCEPTION ").append(excName1to1violated);
        sb.append(" 'One record in ").append(referencesTableName);
        sb.append(" references more than one record in ").append(tableName);
        sb.append("';").append(LINE_SEPARATOR);
        sb.append("SET TERM !! ;").append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        String shortTableName = Utils.getShortName(tableName, 22);
        sb.append("CREATE TRIGGER trig_bef_ins_").append(shortTableName);
        sb.append(" FOR ").append(tableName);
        sb.append(LINE_SEPARATOR);
        sb.append("BEFORE INSERT AS").append(LINE_SEPARATOR);
        sb.append(this.getOneToOneTriggerBody(fkDef, excName1to1violated));
        sb.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        sb.append("CREATE TRIGGER trig_bef_upd_").append(shortTableName);
        sb.append(" FOR ").append(tableName);
        sb.append(LINE_SEPARATOR);
        sb.append("BEFORE UPDATE AS").append(LINE_SEPARATOR);
        sb.append(this.getOneToOneTriggerBody(fkDef, excName1to1violated));
        sb.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        sb.append("SET TERM ; !!").append(LINE_SEPARATOR);
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    public String createTable(TableDefinition tableDefinition) {
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ");
        sb.append(tableDefinition.getName()).append(" (");
        sb.append(LINE_SEPARATOR);
        for (ColumnDefinition colDef : tableDefinition.getColumnDefinitions()) {
            sb.append("    ");
            sb.append(colDef.getName()).append(" ");
            sb.append(colDef.getDatatype());
            Boolean nullable = colDef.getNullable();
            if (nullable != null && nullable.equals(Boolean.FALSE)) {
                sb.append(" ").append("NOT NULL");
            }
            sb.append(",").append(LINE_SEPARATOR);
        }
        StringBuffer sbPk = new StringBuffer();
        for (String primaryKeyField : tableDefinition.getPrimaryKeyFields()) {
            if (sbPk.length() > 0) {
                sbPk.append(", ");
            }
            sbPk.append(primaryKeyField);
        }
        sb.append("CONSTRAINT PK").append(this.primaryKeyCounter);
        sb.append(" PRIMARY KEY (").append(sbPk).append(")");
        sb.append(LINE_SEPARATOR);
        sb.append(");").append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        ++this.primaryKeyCounter;
        return sb.toString();
    }

    public String getName() {
        return "Firebird";
    }
}

