/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.argouml.model.Model;

final class Utils {
    private static final String FILE_PREFIX = "file:";
    private static final String JAR_PREFIX = "jar:";
    public static final String CLASS_SUFFIX = ".class";

    public static Object getAssociationForName(Object relation, String assocName) {
        Object association = null;
        Collection assocEnds = Model.getFacade().getAssociationEnds(relation);
        for (Object assocEnd : assocEnds) {
            Object assoc = Model.getFacade().getAssociation(assocEnd);
            String name = Model.getFacade().getName(assoc);
            if (!name.equals(assocName)) continue;
            association = assoc;
        }
        return association;
    }

    public static Object getAttributeForName(Object relation, String attributeName) {
        Object attribute = null;
        List attributes = Model.getFacade().getAttributes(relation);
        for (Object attr : attributes) {
            if (!Model.getFacade().getName(attr).equals(attributeName)) continue;
            attribute = attr;
            break;
        }
        return attribute;
    }

    public static List getFkAttributes(Object relation, Object association) {
        String assocName = Model.getFacade().getName(association);
        List attributes = Model.getFacade().getAttributes(relation);
        Iterator it = attributes.iterator();
        ArrayList fkAttributes = new ArrayList();
        while (it.hasNext()) {
            Object attribute = it.next();
            String s = Model.getFacade().getTaggedValueValue(attribute, "association_name");
            if (!s.equals(assocName)) continue;
            fkAttributes.add(attribute);
        }
        return fkAttributes;
    }

    public static List getPrimaryKeyAttributes(Object relation) {
        ArrayList result = new ArrayList();
        List attributes = Model.getFacade().getAttributes(relation);
        for (Object attribute : attributes) {
            if (!Utils.isPk(attribute)) continue;
            result.add(attribute);
        }
        return result;
    }

    public static boolean isFk(Object attribute) {
        return Model.getFacade().isStereotype(attribute, "FK");
    }

    public static boolean isPk(Object attribute) {
        return Model.getFacade().isStereotype(attribute, "PK");
    }

    public static boolean isNotNull(Object attribute) {
        return Model.getFacade().isStereotype(attribute, "NOT_NULL");
    }

    public static boolean isNull(Object attribute) {
        return Model.getFacade().isStereotype(attribute, "NULL");
    }

    public static Object getSourceAttribute(Object fkAttribute, Object srcRelation) {
        String srcColName = Model.getFacade().getTaggedValueValue(fkAttribute, "source_column");
        Object srcAttr = null;
        if (srcColName.equals("")) {
            List pkAttrs;
            srcColName = Model.getFacade().getName(fkAttribute);
            srcAttr = Utils.getAttributeForName(srcRelation, srcColName);
            if (srcAttr == null && (pkAttrs = Utils.getPrimaryKeyAttributes(srcRelation)).size() == 1) {
                srcAttr = pkAttrs.iterator().next();
            }
        } else {
            srcAttr = Utils.getAttributeForName(srcRelation, srcColName);
        }
        return srcAttr;
    }

    public static String stringsToString(List strings, String separators) {
        StringBuffer sb = new StringBuffer();
        for (String s : strings) {
            if (sb.length() > 0) {
                sb.append(separators);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static String stringsToCommaString(List strings) {
        return Utils.stringsToString(strings, ",");
    }

    private Utils() {
    }

    public static List stringToStringList(String string, String delimiters) {
        StringTokenizer st = new StringTokenizer(string, delimiters);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static List stringToStringList(String string) {
        StringTokenizer st = new StringTokenizer(string);
        ArrayList<String> result = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            result.add(st.nextToken());
        }
        return result;
    }

    public static String getShortName(String longName, int maxLength) {
        char[] vowels = new char[]{'a', 'e', 'i', 'o', 'u'};
        String shortName = longName;
        while (shortName.length() > maxLength) {
            int index = -1;
            for (int i = 0; i < vowels.length; ++i) {
                int lastIndex = shortName.lastIndexOf(vowels[i]);
                if (lastIndex <= index) continue;
                index = lastIndex;
            }
            if (index == -1) break;
            String firstPart = shortName.substring(0, index);
            String lastPart = shortName.substring(index + 1, shortName.length());
            shortName = firstPart + lastPart;
        }
        if (shortName.length() > maxLength) {
            shortName = shortName.substring(0, maxLength);
        }
        return shortName;
    }

    public static String getModuleRoot() {
        String resName = Utils.class.getName();
        resName = "/" + resName.replace('.', '/') + CLASS_SUFFIX;
        String extForm = Utils.class.getResource(resName).toExternalForm();
        String moduleRoot = extForm.substring(0, extForm.length() - resName.length());
        if (moduleRoot.startsWith(JAR_PREFIX)) {
            if ((moduleRoot = moduleRoot.substring(JAR_PREFIX.length())).endsWith("!")) {
                moduleRoot = moduleRoot.substring(0, moduleRoot.length() - 1);
            }
            int p = moduleRoot.lastIndexOf(47);
            moduleRoot = moduleRoot.substring(0, p);
        }
        if (moduleRoot.startsWith(FILE_PREFIX)) {
            moduleRoot = moduleRoot.substring(FILE_PREFIX.length());
        }
        return moduleRoot;
    }
}

