/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import java.util.ArrayList;
import org.argouml.model.DataTypesHelper;
import org.argouml.model.euml.DataTypesFactoryEUMLImpl;
import org.argouml.model.euml.EUMLModelImplementation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataTypesHelperEUMLImpl
implements DataTypesHelper {
    private EUMLModelImplementation modelImpl;

    public DataTypesHelperEUMLImpl(EUMLModelImplementation implementation) {
        this.modelImpl = implementation;
    }

    @Override
    public boolean equalsCHOICEKind(Object kind) {
        return PseudostateKind.CHOICE_LITERAL.equals(kind);
    }

    @Override
    public boolean equalsDeepHistoryKind(Object kind) {
        return PseudostateKind.DEEP_HISTORY_LITERAL.equals(kind);
    }

    @Override
    public boolean equalsFORKKind(Object kind) {
        return PseudostateKind.FORK_LITERAL.equals(kind);
    }

    @Override
    public boolean equalsINITIALKind(Object kind) {
        return PseudostateKind.INITIAL_LITERAL.equals(kind);
    }

    @Override
    public boolean equalsJOINKind(Object kind) {
        return PseudostateKind.JOIN_LITERAL.equals(kind);
    }

    @Override
    public boolean equalsJUNCTIONKind(Object kind) {
        return PseudostateKind.JUNCTION_LITERAL.equals(kind);
    }

    @Override
    public boolean equalsShallowHistoryKind(Object kind) {
        return PseudostateKind.SHALLOW_HISTORY_LITERAL.equals(kind);
    }

    @Override
    public String getBody(Object handle) {
        EList bodies = null;
        if (handle instanceof OpaqueExpression) {
            bodies = ((OpaqueExpression)handle).getBodies();
        } else if (handle instanceof OpaqueBehavior) {
            bodies = ((OpaqueBehavior)handle).getBodies();
        } else {
            throw new IllegalArgumentException("handle must be instance of OpaqueExpression or OpaqueBehavior");
        }
        return bodies.size() < 1 ? null : (String)bodies.get(0);
    }

    @Override
    public String getLanguage(Object handle) {
        EList langs = null;
        if (handle instanceof OpaqueExpression) {
            langs = ((OpaqueExpression)handle).getLanguages();
        } else if (handle instanceof OpaqueBehavior) {
            langs = ((OpaqueBehavior)handle).getLanguages();
        } else {
            throw new IllegalArgumentException("handle must be instance of OpaqueExpression or OpaqueBehavior. We got " + handle);
        }
        return langs.size() < 1 ? null : (String)langs.get(0);
    }

    @Override
    public String multiplicityToString(Object multiplicity) {
        if (!(multiplicity instanceof MultiplicityElement)) {
            throw new IllegalArgumentException("multiplicity must be instance of MultiplicityElement");
        }
        MultiplicityElement mult = (MultiplicityElement)multiplicity;
        if (mult.getLower() == mult.getUpper()) {
            return DataTypesFactoryEUMLImpl.boundToString(mult.getLower());
        }
        return DataTypesFactoryEUMLImpl.boundToString(mult.getLower()) + ".." + DataTypesFactoryEUMLImpl.boundToString(mult.getUpper());
    }

    @Override
    public Object setBody(Object handle, String body) {
        EList bodies = null;
        if (handle instanceof OpaqueExpression) {
            bodies = ((OpaqueExpression)handle).getBodies();
        } else if (handle instanceof OpaqueBehavior) {
            bodies = ((OpaqueBehavior)handle).getBodies();
        } else {
            throw new IllegalArgumentException("handle must be instance of OpaqueExpression or OpaqueBehavior");
        }
        if (bodies.size() > 1) {
            throw new IllegalStateException("Only one body/lang supported");
        }
        bodies.clear();
        bodies.add(body);
        return handle;
    }

    @Override
    public Object setLanguage(Object handle, String language) {
        EList langs = null;
        if (handle instanceof OpaqueExpression) {
            langs = ((OpaqueExpression)handle).getLanguages();
        } else if (handle instanceof OpaqueBehavior) {
            langs = ((OpaqueBehavior)handle).getLanguages();
        } else {
            throw new IllegalArgumentException("handle must be instance of OpaqueExpression or OpaqueBehavior");
        }
        if (langs.size() > 1) {
            throw new IllegalStateException("Only one body/lang supported");
        }
        langs.clear();
        langs.add(language);
        return handle;
    }

    public ArrayList<String> getValueSpecifications() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("OpaqueExpression");
        list.add("LiteralString");
        list.add("LiteralBoolean");
        return list;
    }

    @Override
    public Object createValueSpecification(Object handle, String type) {
        ValueSpecification newValueSpecification = null;
        if (handle instanceof Property) {
            Property property = (Property)handle;
            String[] tabValues = null;
            if (type.equals("LiteralBoolean")) {
                newValueSpecification = (ValueSpecification)UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getLiteralBoolean());
            } else if (type.equals("LiteralNull")) {
                newValueSpecification = (ValueSpecification)UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getLiteralNull());
            } else if (type.equals("LiteralString")) {
                newValueSpecification = (ValueSpecification)UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getLiteralString());
                tabValues = new String[]{""};
            } else if (type.equals("LiteralUnlimitedNatural")) {
                newValueSpecification = (ValueSpecification)UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getLiteralUnlimitedNatural());
                tabValues = new String[]{"0"};
            } else if (type.equals("LiteralInteger")) {
                newValueSpecification = (ValueSpecification)UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getLiteralInteger());
                tabValues = new String[]{"0"};
            } else if (type.equals("OpaqueExpression")) {
                newValueSpecification = (ValueSpecification)UMLFactory.eINSTANCE.create(UMLPackage.eINSTANCE.getOpaqueExpression());
                this.setLanguage(newValueSpecification, "");
                this.setBody(newValueSpecification, "");
            }
            if (tabValues != null) {
                this.modifyValueSpecification(newValueSpecification, tabValues);
            }
            if (newValueSpecification != null) {
                property.setDefaultValue(newValueSpecification);
            }
        }
        return newValueSpecification;
    }

    @Override
    public void modifyValueSpecification(Object handle, Object[] tabValues) {
        if (handle instanceof LiteralBoolean) {
            LiteralBoolean lb = (LiteralBoolean)handle;
            if (tabValues != null && tabValues.length == 1) {
                Boolean value = (Boolean)tabValues[0];
                lb.setValue(value.booleanValue());
            }
        } else if (!(handle instanceof LiteralNull)) {
            if (handle instanceof LiteralString) {
                LiteralString ls = (LiteralString)handle;
                if (tabValues != null && tabValues.length == 1) {
                    String value = (String)tabValues[0];
                    ls.setValue(value);
                }
            } else if (handle instanceof LiteralUnlimitedNatural) {
                LiteralUnlimitedNatural ls = (LiteralUnlimitedNatural)handle;
                if (tabValues != null && tabValues.length == 1) {
                    Integer value = (Integer)tabValues[0];
                    ls.setValue(value.intValue());
                }
            } else if (handle instanceof LiteralInteger) {
                LiteralInteger ls = (LiteralInteger)handle;
                if (tabValues != null && tabValues.length == 1) {
                    Integer value = (Integer)tabValues[0];
                    ls.setValue(value.intValue());
                }
            } else if (handle instanceof OpaqueExpression) {
                OpaqueExpression oe = (OpaqueExpression)handle;
                EList bodies = oe.getBodies();
                EList langs = oe.getLanguages();
                bodies.clear();
                langs.clear();
                for (int i = 0; i < tabValues.length; i += 2) {
                    bodies.add((String)tabValues[i]);
                    langs.add((String)tabValues[i + 1]);
                }
            }
        }
    }

    @Override
    public Object[] getValueSpecificationValues(Object handle) {
        Object[] tabValues = null;
        if (handle instanceof LiteralBoolean) {
            LiteralBoolean lb = (LiteralBoolean)handle;
            tabValues = new Boolean[]{lb.isValue()};
        } else if (!(handle instanceof LiteralNull)) {
            if (handle instanceof LiteralString) {
                LiteralString ls = (LiteralString)handle;
                tabValues = new String[]{ls.getValue()};
            } else if (handle instanceof LiteralUnlimitedNatural) {
                LiteralUnlimitedNatural lun = (LiteralUnlimitedNatural)handle;
                tabValues = new String[]{"" + lun.getValue()};
            } else if (handle instanceof LiteralInteger) {
                LiteralInteger li = (LiteralInteger)handle;
                tabValues = new Integer[]{li.getValue()};
            } else if (handle instanceof OpaqueExpression) {
                OpaqueExpression oe = (OpaqueExpression)handle;
                EList bodies = oe.getBodies();
                EList langs = oe.getLanguages();
                if (bodies.size() > 0) {
                    tabValues = new String[bodies.size() * 2];
                    for (int i = 0; i < bodies.size(); ++i) {
                        tabValues[i * 2] = bodies.get(i);
                        tabValues[i * 2 + 1] = langs.get(i);
                    }
                }
            }
        }
        return tabValues;
    }
}

