/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Prefs;

public class PrefsEditor
extends Frame {
    private static final long serialVersionUID = -4707206125138468506L;
    private Checkbox _tryOffScreenCB;
    private Checkbox _printGridCB;
    private Checkbox _printBackgroundCB;
    private Button _moreRepaints;
    private Button _fewerRepaints;
    private Button _close;

    public PrefsEditor() {
        this.setTitle("Prefs");
        this.setBackground(Color.lightGray);
        this._tryOffScreenCB = new Checkbox("Flicker-free repaint");
        this._moreRepaints = new Button("More Repaints");
        this._fewerRepaints = new Button("Fewer Repaints");
        this._printGridCB = new Checkbox("Print Grid");
        this._printBackgroundCB = new Checkbox("Print Background");
        Panel p = new Panel();
        p.setLayout(new GridLayout(6, 1));
        this._tryOffScreenCB.setState(Globals.getPrefs().getTryOffScreen());
        this._printGridCB.setState(Globals.getPrefs().getPrintGrid());
        this._printBackgroundCB.setState(Globals.getPrefs().getPrintBackground());
        p.add(this._tryOffScreenCB);
        p.add(this._moreRepaints);
        p.add(this._fewerRepaints);
        p.add(this._printGridCB);
        p.add(this._printBackgroundCB);
        this.add("Center", p);
        this._close = new Button("Close");
        Panel bottomPanel = new Panel();
        bottomPanel.add("Center", this._close);
        this.add("South", bottomPanel);
        this.pack();
    }

    public void close() {
        this.dispose();
    }

    public void processEvent(AWTEvent e) {
        switch (e.getID()) {
            case 201: {
                if (e.getSource() != this) break;
                this.close();
            }
        }
        super.processEvent(e);
    }

    public boolean action(Event e, Object what) {
        Prefs p = Globals.getPrefs();
        if (e.target == this._tryOffScreenCB) {
            p.setTryOffScreen(!p.getTryOffScreen());
            this._tryOffScreenCB.setState(p.getTryOffScreen());
            return true;
        }
        if (e.target == this._moreRepaints) {
            return true;
        }
        if (e.target == this._fewerRepaints) {
            return true;
        }
        if (e.target == this._close) {
            this.close();
            return true;
        }
        if (e.target == this._printGridCB) {
            p.setPrintGrid(!p.getPrintGrid());
            this._printGridCB.setState(p.getPrintGrid());
            return true;
        }
        if (e.target == this._printBackgroundCB) {
            p.setPrintBackground(!p.getPrintBackground());
            this._printBackgroundCB.setState(p.getPrintBackground());
            return true;
        }
        return false;
    }
}

