/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import org.tigris.gef.presentation.Fig;

public class FigCube
extends Fig
implements Serializable {
    private static final long serialVersionUID = 7798364480460523733L;
    private int D = 20;

    public FigCube(int x, int y, int w, int h, Color lColor, Color fColor) {
        super(x, y, w, h, lColor, fColor);
    }

    public FigCube(int x, int y, int w, int h) {
        super(x, y, w, h);
    }

    public void paint(Graphics g) {
        Color fillColor = this.getFillColor();
        Color lineColor = this.getLineColor();
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(fillColor);
        g.fillRect(x, y, w, h);
        g.setColor(lineColor);
        g.drawRect(x, y, w, h);
        g.setColor(fillColor);
        g.fillPolygon(new int[]{x, x + this.D, x + w + this.D, x + w}, new int[]{y, y - this.D, y - this.D, y}, 4);
        g.setColor(lineColor);
        g.drawPolygon(new int[]{x, x + this.D, x + w + this.D, x + w}, new int[]{y, y - this.D, y - this.D, y}, 4);
        g.setColor(fillColor);
        g.fillPolygon(new int[]{x + w + this.D, x + w + this.D, x + w, x + w}, new int[]{y - this.D, y + h - this.D, y + h, y}, 4);
        g.setColor(lineColor);
        g.drawPolygon(new int[]{x + w + this.D, x + w + this.D, x + w, x + w}, new int[]{y - this.D, y + h - this.D, y + h, y}, 4);
    }

    public int getDepth() {
        return this.D;
    }

    public void setDepth(int depth) {
        this.D = depth;
    }

    public void appendSvg(StringBuffer sb) {
        sb.append("<rect id='").append(this.getId()).append("' x='").append(this.getX()).append("' y='").append(this.getY()).append("' width='").append(this.getWidth()).append("' height='").append(this.getHeight()).append("'");
        this.appendSvgStyle(sb);
        sb.append(" />");
    }
}

