/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import org.tigris.gef.util.Util;

public class ResourceLoader {
    private static HashMap _resourceCache = new HashMap();
    private static List _resourceLocations = new ArrayList();
    private static List _resourceExtensions = new ArrayList();

    public static ImageIcon lookupIconResource(String resource) {
        return ResourceLoader.lookupIconResource(resource, resource);
    }

    public static ImageIcon lookupIconResource(String resource, String desc) {
        return ResourceLoader.lookupIconResource(resource, desc, null);
    }

    public static ImageIcon lookupIconResource(String resource, ClassLoader loader) {
        return ResourceLoader.lookupIconResource(resource, resource, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon lookupIconResource(String resource, String desc, ClassLoader loader) {
        String strippedName = Util.stripJunk(resource);
        if (ResourceLoader.isInCache(strippedName)) {
            return (ImageIcon)_resourceCache.get(strippedName);
        }
        ImageIcon res = null;
        URL imgURL = null;
        try {
            for (String tmpExt : _resourceExtensions) {
                Iterator locations = _resourceLocations.iterator();
                while (locations.hasNext()) {
                    String imageName = (String)locations.next() + "/" + strippedName + "." + tmpExt;
                    imgURL = loader == null ? ResourceLoader.class.getResource(imageName) : loader.getResource(imageName);
                    if (imgURL == null) continue;
                    break;
                }
                if (imgURL == null) continue;
                break;
            }
            if (imgURL == null) {
                return null;
            }
            res = new ImageIcon(imgURL, desc);
            HashMap extensions = _resourceCache;
            synchronized (extensions) {
                _resourceCache.put(strippedName, res);
            }
            return res;
        }
        catch (Exception ex) {
            System.err.println("Exception in looking up IconResource");
            ex.printStackTrace();
            return new ImageIcon(strippedName);
        }
    }

    public static void addResourceLocation(String location) {
        if (!ResourceLoader.containsLocation(location)) {
            _resourceLocations.add(location);
        }
    }

    public static void addResourceExtension(String extension) {
        if (!ResourceLoader.containsExtension(extension)) {
            _resourceExtensions.add(extension);
        }
    }

    public static void removeResourceLocation(String location) {
        for (String loc : _resourceLocations) {
            if (!loc.equals(location)) continue;
            _resourceLocations.remove(loc);
            break;
        }
    }

    public static void removeResourceExtension(String extension) {
        for (String ext : _resourceExtensions) {
            if (!ext.equals(extension)) continue;
            _resourceExtensions.remove(ext);
            break;
        }
    }

    public static boolean containsExtension(String extension) {
        return _resourceExtensions.contains(extension);
    }

    public static boolean containsLocation(String location) {
        return _resourceLocations.contains(location);
    }

    public static boolean isInCache(String resource) {
        return _resourceCache.containsKey(resource);
    }
}

