/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.DeleteInstanceEvent;
import org.argouml.model.Model;
import org.argouml.uml.CommentEdge;
import org.argouml.uml.diagram.UMLMutableGraphSupport;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.FigModifyingMode;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.ModeManager;
import org.tigris.gef.graph.MutableGraphModel;

class SequenceDiagramGraphModel
extends UMLMutableGraphSupport
implements VetoableChangeListener,
PropertyChangeListener,
MutableGraphModel {
    private static final Logger LOG = Logger.getLogger(SequenceDiagramGraphModel.class);
    private Object collaboration;
    private Object interaction;

    public List getPorts(Object element) {
        LinkedList<Object> ports = new LinkedList<Object>();
        if (Model.getFacade().isAClassifierRole(element)) {
            ports.addAll(Model.getFacade().getReceivedMessages(element));
            ports.addAll(Model.getFacade().getSentMessages(element));
        } else if (Model.getFacade().isAMessage(element)) {
            ports.add(Model.getFacade().getSender(element));
            ports.add(Model.getFacade().getReceiver(element));
        }
        return ports;
    }

    public List getInEdges(Object element) {
        LinkedList ports = new LinkedList();
        if (Model.getFacade().isAClassifierRole(element)) {
            ports.addAll(Model.getFacade().getSentMessages(element));
        }
        return ports;
    }

    public List getOutEdges(Object element) {
        LinkedList ports = new LinkedList();
        if (Model.getFacade().isAClassifierRole(element)) {
            ports.addAll(Model.getFacade().getReceivedMessages(element));
        }
        return ports;
    }

    public Object getOwner(Object port) {
        return port;
    }

    public Object getCollaboration() {
        if (this.collaboration == null) {
            LOG.debug((Object)"The collaboration is null so creating a new collaboration");
            this.collaboration = Model.getCollaborationsFactory().buildCollaboration(ProjectManager.getManager().getCurrentProject().getRoot());
        }
        return this.collaboration;
    }

    public void setCollaboration(Object c) {
        LOG.debug((Object)("Setting the collaboration of sequence diagram to " + c));
        this.collaboration = c;
        Collection interactions = Model.getFacade().getInteractions(c);
        if (!interactions.isEmpty()) {
            this.interaction = interactions.iterator().next();
        }
    }

    private Object getInteraction() {
        if (this.interaction == null) {
            this.interaction = Model.getCollaborationsFactory().buildInteraction(this.collaboration);
            LOG.debug((Object)"Interaction built.");
            Model.getPump().addModelEventListener((PropertyChangeListener)this, this.interaction);
        }
        return this.interaction;
    }

    public Object getOwner() {
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            return this.getCollaboration();
        }
        return this.getInteraction();
    }

    public boolean canAddNode(Object node) {
        if (node == null) {
            return false;
        }
        if (this.getNodes().contains(node)) {
            return false;
        }
        if (Model.getFacade().isAComment(node)) {
            return true;
        }
        return Model.getFacade().isAModelElement(node) && Model.getFacade().getNamespace(node) == this.getCollaboration();
    }

    public boolean canAddEdge(Object edge) {
        if (edge == null) {
            return false;
        }
        if (this.getEdges().contains(edge)) {
            return false;
        }
        Object end0 = null;
        Object end1 = null;
        if (Model.getFacade().isAMessage(edge)) {
            end0 = Model.getFacade().getSender(edge);
            end1 = Model.getFacade().getReceiver(edge);
        } else if (edge instanceof CommentEdge) {
            end0 = ((CommentEdge)edge).getSource();
            end1 = ((CommentEdge)edge).getDestination();
        } else {
            return false;
        }
        if (end0 == null || end1 == null) {
            LOG.error((Object)"Edge rejected. Its ends are not attached to anything");
            return false;
        }
        if (!this.containsNode(end0) && !this.containsEdge(end0)) {
            LOG.error((Object)("Edge rejected. Its source end is attached to " + end0 + " but this is not in the graph model"));
            return false;
        }
        if (!this.containsNode(end1) && !this.containsEdge(end1)) {
            LOG.error((Object)("Edge rejected. Its destination end is attached to " + end1 + " but this is not in the graph model"));
            return false;
        }
        return true;
    }

    public void addNode(Object node) {
        if (this.canAddNode(node)) {
            this.getNodes().add(node);
            this.fireNodeAdded(node);
        }
    }

    public void vetoableChange(PropertyChangeEvent pce) throws PropertyVetoException {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof DeleteInstanceEvent && evt.getSource() == this.interaction) {
            Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.interaction);
            this.interaction = null;
        }
    }

    public Object connect(Object fromPort, Object toPort, Object edgeType) {
        if (!this.canConnect(fromPort, toPort, edgeType)) {
            return null;
        }
        if (edgeType == CommentEdge.class) {
            return super.connect(fromPort, toPort, edgeType);
        }
        Editor curEditor = Globals.curEditor();
        ModeManager modeManager = curEditor.getModeManager();
        FigModifyingMode mode = modeManager.top();
        Hashtable args = mode.getArgs();
        Object actionType = args.get("action");
        return this.connectMessage(fromPort, toPort, actionType);
    }

    public Object connectMessage(Object fromPort, Object toPort, Object messageSort) {
        if (Model.getFacade().getUmlVersion().charAt(0) == '1') {
            return this.createMessage1(fromPort, toPort, messageSort);
        }
        return this.createMessage2(fromPort, toPort, messageSort);
    }

    private Object createMessage1(Object fromPort, Object toPort, Object messageSort) {
        Object edge = null;
        Object action = null;
        if (Model.getMessageSort().getSynchCall().equals(messageSort)) {
            action = Model.getCommonBehaviorFactory().createCallAction();
            Model.getCommonBehaviorHelper().setAsynchronous(action, false);
        } else if (Model.getMessageSort().getASynchCall().equals(messageSort)) {
            action = Model.getCommonBehaviorFactory().createCallAction();
            Model.getCommonBehaviorHelper().setAsynchronous(action, true);
        } else if (Model.getMessageSort().getCreateMessage().equals(messageSort)) {
            action = Model.getCommonBehaviorFactory().createCreateAction();
            Model.getCommonBehaviorHelper().setAsynchronous(action, false);
        } else if (Model.getMessageSort().getReply().equals(messageSort)) {
            action = Model.getCommonBehaviorFactory().createReturnAction();
            Model.getCommonBehaviorHelper().setAsynchronous(action, true);
        } else if (Model.getMessageSort().getDeleteMessage().equals(messageSort)) {
            action = Model.getCommonBehaviorFactory().createDestroyAction();
            Model.getCommonBehaviorHelper().setAsynchronous(action, false);
        } else if (Model.getMessageSort().getASynchSignal().equals(messageSort)) {
            action = Model.getCommonBehaviorFactory().createSendAction();
            Model.getCommonBehaviorHelper().setAsynchronous(action, true);
        } else if (Model.getMetaTypes().getTerminateAction().equals(messageSort)) {
            // empty if block
        }
        if (fromPort != null && toPort != null) {
            Object associationRole = Model.getCollaborationsHelper().getAssociationRole(fromPort, toPort);
            if (associationRole == null) {
                associationRole = Model.getCollaborationsFactory().buildAssociationRole(fromPort, toPort);
            }
            Object message = Model.getCollaborationsFactory().buildMessage(this.getInteraction(), associationRole);
            if (action != null) {
                Model.getCollaborationsHelper().setAction(message, action);
                Model.getCoreHelper().setNamespace(action, this.getCollaboration());
            }
            Model.getCollaborationsHelper().setSender(message, fromPort);
            Model.getCommonBehaviorHelper().setReceiver(message, toPort);
            this.addEdge(message);
            edge = message;
        }
        if (edge == null) {
            LOG.debug((Object)"Incorrect edge");
        }
        return edge;
    }

    private Object createMessage2(Object fromPort, Object toPort, Object messageSort) {
        if (fromPort != null && toPort != null) {
            Object message = Model.getCollaborationsFactory().buildMessage(fromPort, toPort);
            Model.getCollaborationsHelper().setMessageSort(message, messageSort);
            this.addEdge(message);
            return message;
        }
        LOG.debug((Object)"Incorrect edge");
        return null;
    }

    public void addEdge(Object edge) {
        if (this.canAddEdge(edge)) {
            this.getEdges().add(edge);
            this.fireEdgeAdded(edge);
        }
    }
}

